/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.callsite;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.Activator;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.internal.tmf.core.analysis.callsite.CallsiteAnalysis;
import org.eclipse.tracecompass.tmf.core.analysis.callsite.ITmfCallsiteIterator;
import org.eclipse.tracecompass.tmf.core.analysis.callsite.TimeCallsite;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;
import org.eclipse.tracecompass.tmf.core.event.lookup.TmfCallsite;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CallsiteTest {
    private static final String KERNEL_ANALYSIS = "testfiles/kernel_analysis/lttng_kernel_analysis.xml";
    private static final List<@NonNull ITmfCallsite> EXPECTED_40 = Arrays.asList(new TmfCallsite("fs/open.c", Long.valueOf(0L)));
    private static final List<@NonNull ITmfCallsite> EXPECTED_71 = Arrays.asList(new TmfCallsite("fs/read_write.c", Long.valueOf(0L)));
    private TmfXmlKernelTraceStub fTrace;

    @Before
    public void init() throws TmfTraceException {
        IPath filePath = Activator.getAbsoluteFilePath(KERNEL_ANALYSIS);
        this.fTrace = new TmfXmlKernelTraceStub();
        this.fTrace.initTrace(null, filePath.toOSString(), TmfEvent.class);
        this.fTrace.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)this.fTrace, null));
    }

    @After
    public void teardown() {
        this.fTrace.dispose();
    }

    @Test
    public void testCallsiteAnalysis() {
        TmfXmlKernelTraceStub trace = this.fTrace;
        Assert.assertNotNull((Object)((Object)trace));
        CallsiteAnalysis module = (CallsiteAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, CallsiteAnalysis.class, (String)"org.eclipse.tracecompass.tmf.core.analysis.callsite");
        Assert.assertNotNull((Object)module);
        Assert.assertTrue((boolean)module.schedule().isOK());
        Assert.assertTrue((boolean)module.waitForCompletion());
        String uuid = String.valueOf(this.fTrace.getUUID());
        String cpu = "cpu";
        Assert.assertEquals(Collections.emptyList(), (Object)module.getCallsites(uuid, cpu, "0", 39L));
        Assert.assertEquals(EXPECTED_40, (Object)module.getCallsites(uuid, cpu, "0", 40L));
        Assert.assertEquals(EXPECTED_40, (Object)module.getCallsites(uuid, cpu, "0", 41L));
        Assert.assertEquals(EXPECTED_40, (Object)module.getCallsites(uuid, cpu, "0", 70L));
        Assert.assertEquals(EXPECTED_71, (Object)module.getCallsites(uuid, cpu, "0", 71L));
        Assert.assertEquals(EXPECTED_71, (Object)module.getCallsites(uuid, cpu, "0", 72L));
        Assert.assertEquals(Collections.emptyList(), (Object)module.getCallsites("Hello", cpu, "0", 42L));
        Assert.assertEquals(Collections.emptyList(), (Object)module.getCallsites(uuid, cpu, "1", 42L));
        Assert.assertEquals(Collections.emptyList(), (Object)module.getCallsites(uuid, cpu, "0", 12L));
        Assert.assertEquals(Collections.emptyList(), (Object)module.getCallsites(uuid, cpu, "..", 42L));
    }

    @Test
    public void testIterator() {
        TmfXmlKernelTraceStub trace = this.fTrace;
        Assert.assertNotNull((Object)((Object)trace));
        CallsiteAnalysis module = (CallsiteAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, CallsiteAnalysis.class, (String)"org.eclipse.tracecompass.tmf.core.analysis.callsite");
        Assert.assertNotNull((Object)module);
        Assert.assertTrue((boolean)module.schedule().isOK());
        Assert.assertTrue((boolean)module.waitForCompletion());
        UUID uuid = trace.getUUID();
        Assert.assertNotNull((Object)uuid);
        String cpu = "cpu";
        ITmfCallsiteIterator iter = module.iterator(uuid.toString(), cpu, "0", 1L);
        CallsiteTest.evaluateNextIterator((Iterator<TimeCallsite>)iter, 40L, new TmfCallsite("fs/open.c", Long.valueOf(0L)));
        CallsiteTest.evaluateNextIterator((Iterator<TimeCallsite>)iter, 71L, new TmfCallsite("fs/read_write.c", Long.valueOf(0L)));
        CallsiteTest.evaluateEmptyNextIterator((Iterator<TimeCallsite>)iter);
        CallsiteTest.evaluateEmptyNextIterator((Iterator<TimeCallsite>)iter);
        iter = module.iterator(uuid.toString(), cpu, "0", 40L);
        CallsiteTest.evaluateNextIterator((Iterator<TimeCallsite>)iter, 40L, new TmfCallsite("fs/open.c", Long.valueOf(0L)));
        iter = module.iterator(uuid.toString(), cpu, "0", 71L);
        CallsiteTest.evaluateNextIterator((Iterator<TimeCallsite>)iter, 71L, new TmfCallsite("fs/read_write.c", Long.valueOf(0L)));
        iter = module.iterator(uuid.toString(), cpu, "0", 72L);
        CallsiteTest.evaluateEmptyNextIterator((Iterator<TimeCallsite>)iter);
        iter = module.iterator(uuid.toString(), cpu, "0", 99L);
        CallsiteTest.evaluatePrevIterator(iter, 71L, new TmfCallsite("fs/read_write.c", Long.valueOf(0L)));
        CallsiteTest.evaluatePrevIterator(iter, 40L, new TmfCallsite("fs/open.c", Long.valueOf(0L)));
        CallsiteTest.evaluateEmptyPrevIterator(iter);
        CallsiteTest.evaluateEmptyPrevIterator(iter);
        iter = module.iterator(uuid.toString(), cpu, "0", 71L);
        CallsiteTest.evaluatePrevIterator(iter, 71L, new TmfCallsite("fs/read_write.c", Long.valueOf(0L)));
        iter = module.iterator(uuid.toString(), cpu, "0", 40L);
        CallsiteTest.evaluatePrevIterator(iter, 40L, new TmfCallsite("fs/open.c", Long.valueOf(0L)));
        iter = module.iterator(uuid.toString(), cpu, "0", 39L);
        CallsiteTest.evaluateEmptyPrevIterator(iter);
        iter = module.iterator(uuid.toString(), cpu, "0", 42L);
        int i = 0;
        while (i < 10) {
            CallsiteTest.evaluateNextIterator((Iterator<TimeCallsite>)iter, 71L, new TmfCallsite("fs/read_write.c", Long.valueOf(0L)));
            CallsiteTest.evaluateEmptyNextIterator((Iterator<TimeCallsite>)iter);
            CallsiteTest.evaluatePrevIterator(iter, 40L, new TmfCallsite("fs/open.c", Long.valueOf(0L)));
            CallsiteTest.evaluateEmptyPrevIterator(iter);
            ++i;
        }
        iter = module.iterator(uuid.toString(), cpu, "0", 42L);
        i = 0;
        while (i < 10) {
            CallsiteTest.evaluatePrevIterator(iter, 40L, new TmfCallsite("fs/open.c", Long.valueOf(0L)));
            CallsiteTest.evaluateEmptyPrevIterator(iter);
            CallsiteTest.evaluateNextIterator((Iterator<TimeCallsite>)iter, 71L, new TmfCallsite("fs/read_write.c", Long.valueOf(0L)));
            CallsiteTest.evaluateEmptyNextIterator((Iterator<TimeCallsite>)iter);
            ++i;
        }
        iter = module.iterator("", cpu, "0", 42L);
        CallsiteTest.evaluateEmptyNextIterator((Iterator<TimeCallsite>)iter);
        CallsiteTest.evaluateEmptyPrevIterator(iter);
        iter = module.iterator(uuid.toString(), cpu, "elephant", 42L);
        CallsiteTest.evaluateEmptyNextIterator((Iterator<TimeCallsite>)iter);
        CallsiteTest.evaluateEmptyPrevIterator(iter);
    }

    private static void evaluateEmptyNextIterator(Iterator<@NonNull TimeCallsite> iter) {
        Assert.assertFalse((boolean)iter.hasNext());
    }

    private static void evaluateEmptyPrevIterator(ITmfCallsiteIterator iter) {
        Assert.assertFalse((boolean)iter.hasPrevious());
    }

    private static void evaluateNextIterator(Iterator<@NonNull TimeCallsite> iter, long time, TmfCallsite callsite) {
        Assert.assertTrue((boolean)iter.hasNext());
        TimeCallsite next = iter.next();
        Assert.assertEquals((long)time, (long)next.getTime());
        Assert.assertEquals((Object)callsite, (Object)next.getCallsite());
    }

    private static void evaluatePrevIterator(ITmfCallsiteIterator iter, long time, TmfCallsite callsite) {
        Assert.assertTrue((boolean)iter.hasPrevious());
        TimeCallsite previous = iter.previous();
        Assert.assertEquals((long)time, (long)previous.getTime());
        Assert.assertEquals((Object)callsite, (Object)previous.getCallsite());
    }
}

