/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.perf.analysis.syscall;

import java.io.File;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.latency.SystemCallLatencyAnalysis;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.junit.Assert;
import org.junit.Test;

public class SystemCallAnalysisBenchmark {
    public static final String TEST_ID = "org.eclipse.tracecompass#System Call Analysis#";
    private static final String TEST_BUILD = "Building Analysis (%s)";
    private static final String TEST_MEMORY = "Memory Usage (%s)";
    private static final int LOOP_COUNT = 25;
    private RunMethod cpu = (pm, module) -> {
        pm.start();
        TmfTestHelper.executeAnalysis((IAnalysisModule)module);
        pm.stop();
    };
    private RunMethod memory = (pm, module) -> {
        System.gc();
        pm.start();
        TmfTestHelper.executeAnalysis((IAnalysisModule)module);
        System.gc();
        pm.stop();
    };

    @Test
    public void testTrace2() {
        SystemCallAnalysisBenchmark.runTest(CtfTestTrace.TRACE2, String.format(TEST_BUILD, "Trace2"), this.cpu, Dimension.CPU_TIME);
        SystemCallAnalysisBenchmark.runTest(CtfTestTrace.TRACE2, String.format(TEST_MEMORY, "Trace2"), this.memory, Dimension.USED_JAVA_HEAP);
    }

    @Test
    public void testManyThreads() {
        SystemCallAnalysisBenchmark.runTest(CtfTestTrace.MANY_THREADS, String.format(TEST_BUILD, "Many threads"), this.cpu, Dimension.CPU_TIME);
        SystemCallAnalysisBenchmark.runTest(CtfTestTrace.MANY_THREADS, String.format(TEST_MEMORY, "Many threads"), this.memory, Dimension.USED_JAVA_HEAP);
    }

    @Test
    public void testDjangoHttpd() {
        SystemCallAnalysisBenchmark.runTest(CtfTestTrace.DJANGO_HTTPD, String.format(TEST_BUILD, "Django HTTPD"), this.cpu, Dimension.CPU_TIME);
        SystemCallAnalysisBenchmark.runTest(CtfTestTrace.DJANGO_HTTPD, String.format(TEST_MEMORY, "Django HTTPD"), this.memory, Dimension.USED_JAVA_HEAP);
    }

    private static void runTest(@NonNull CtfTestTrace testTrace, String testName, RunMethod method, Dimension dimension) {
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter(TEST_ID + testName);
        perf.tagAsSummary(pm, "Syscall " + testName, dimension);
        int i = 0;
        while (i < 25) {
            block13: {
                LttngKernelTrace trace = null;
                IAnalysisModule module = null;
                String path = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)testTrace).getPath();
                try {
                    try {
                        trace = new LttngKernelTrace();
                        trace.initTrace(null, path, CtfTmfEvent.class);
                        trace.traceOpened(new TmfTraceOpenedSignal((Object)trace, (ITmfTrace)trace, null));
                        module = trace.getAnalysisModule("org.eclipse.tracecompass.analysis.os.linux.kernel.tid");
                        Assert.assertNotNull((Object)module);
                        module.schedule();
                        module.waitForCompletion();
                        module = new SystemCallLatencyAnalysis();
                        module.setId("test");
                        module.setTrace((ITmfTrace)trace);
                        method.execute(pm, module);
                        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
                        File[] fileArray = suppDir.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            file.delete();
                            ++n2;
                        }
                    }
                    catch (TmfAnalysisException | TmfTraceException e) {
                        Assert.fail((String)e.getMessage());
                        if (module != null) {
                            module.dispose();
                        }
                        if (trace != null) {
                            trace.dispose();
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (module != null) {
                        module.dispose();
                    }
                    if (trace != null) {
                        trace.dispose();
                    }
                    throw throwable;
                }
                if (module != null) {
                    module.dispose();
                }
                if (trace != null) {
                    trace.dispose();
                }
            }
            ++i;
        }
        pm.commit();
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)testTrace);
    }

    private static interface RunMethod {
        public void execute(PerformanceMeter var1, IAnalysisModule var2);
    }
}

