/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.tests.math;

import org.junit.Assert;
import org.junit.Test;

public abstract class BaseSaturatedArithmeticTest {
    @Test
    public void testMult0() {
        Assert.assertEquals((long)0L, (long)this.multiply(0, 0));
        Assert.assertEquals((long)0L, (long)this.multiply(0, 1));
        Assert.assertEquals((long)0L, (long)this.multiply(1, 0));
        Assert.assertEquals((long)0L, (long)this.multiply(42, 0));
        Assert.assertEquals((long)0L, (long)this.multiply(0, 42));
        Assert.assertEquals((long)0L, (long)this.multiply(-42, 0));
        Assert.assertEquals((long)0L, (long)this.multiply(0, -42));
        Assert.assertEquals((long)0L, (long)this.multiply(Integer.MAX_VALUE, 0));
        Assert.assertEquals((long)0L, (long)this.multiply(0, Integer.MAX_VALUE));
        Assert.assertEquals((long)0L, (long)this.multiply(Integer.MIN_VALUE, 0));
        Assert.assertEquals((long)0L, (long)this.multiply(0, Integer.MIN_VALUE));
    }

    @Test
    public void testMult1() {
        Assert.assertEquals((long)0L, (long)this.multiply(0, 1));
        Assert.assertEquals((long)1L, (long)this.multiply(1, 1));
        Assert.assertEquals((long)42L, (long)this.multiply(42, 1));
        Assert.assertEquals((long)42L, (long)this.multiply(1, 42));
        Assert.assertEquals((long)-42L, (long)this.multiply(-42, 1));
        Assert.assertEquals((long)-42L, (long)this.multiply(1, -42));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.multiply(Integer.MAX_VALUE, 1));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.multiply(1, Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)this.multiply(Integer.MIN_VALUE, 1));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)this.multiply(1, Integer.MIN_VALUE));
    }

    @Test
    public void testMult100() {
        Assert.assertEquals((long)10000L, (long)this.multiply(100, 100));
        Assert.assertEquals((long)-10000L, (long)this.multiply(100, -100));
        Assert.assertEquals((long)-10000L, (long)this.multiply(-100, 100));
        Assert.assertEquals((long)10000L, (long)this.multiply(-100, -100));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.multiply(Integer.MAX_VALUE, 100));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.multiply(100, Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)this.multiply(Integer.MIN_VALUE, 100));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)this.multiply(100, Integer.MIN_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)this.multiply(Integer.MAX_VALUE, -100));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)this.multiply(-100, Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.multiply(Integer.MIN_VALUE, -100));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.multiply(-100, Integer.MIN_VALUE));
    }

    @Test
    public void testMultLimit() {
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.multiply(Integer.MAX_VALUE, Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)this.multiply(Integer.MAX_VALUE, Integer.MIN_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)this.multiply(Integer.MIN_VALUE, Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.multiply(Integer.MIN_VALUE, Integer.MIN_VALUE));
    }

    @Test
    public void testMult0L() {
        Assert.assertEquals((long)0L, (long)this.multiply(0L, 0L));
        Assert.assertEquals((long)0L, (long)this.multiply(0L, 1L));
        Assert.assertEquals((long)0L, (long)this.multiply(1L, 0L));
        Assert.assertEquals((long)0L, (long)this.multiply(42L, 0L));
        Assert.assertEquals((long)0L, (long)this.multiply(0L, 42L));
        Assert.assertEquals((long)0L, (long)this.multiply(-42L, 0L));
        Assert.assertEquals((long)0L, (long)this.multiply(0L, -42L));
        Assert.assertEquals((long)0L, (long)this.multiply(Long.MAX_VALUE, 0L));
        Assert.assertEquals((long)0L, (long)this.multiply(0L, Long.MAX_VALUE));
        Assert.assertEquals((long)0L, (long)this.multiply(Long.MIN_VALUE, 0L));
        Assert.assertEquals((long)0L, (long)this.multiply(0L, Long.MIN_VALUE));
    }

    @Test
    public void testMult1L() {
        Assert.assertEquals((long)0L, (long)this.multiply(0L, 1L));
        Assert.assertEquals((long)1L, (long)this.multiply(1L, 1L));
        Assert.assertEquals((long)42L, (long)this.multiply(42L, 1L));
        Assert.assertEquals((long)42L, (long)this.multiply(1L, 42L));
        Assert.assertEquals((long)-42L, (long)this.multiply(-42L, 1L));
        Assert.assertEquals((long)-42L, (long)this.multiply(1L, -42L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.multiply(Long.MAX_VALUE, 1L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.multiply(1L, Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)this.multiply(Long.MIN_VALUE, 1L));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)this.multiply(1L, Long.MIN_VALUE));
    }

    @Test
    public void testMult100L() {
        Assert.assertEquals((long)10000L, (long)this.multiply(100L, 100L));
        Assert.assertEquals((long)-10000L, (long)this.multiply(100L, -100L));
        Assert.assertEquals((long)-10000L, (long)this.multiply(-100L, 100L));
        Assert.assertEquals((long)10000L, (long)this.multiply(-100L, -100L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.multiply(Long.MAX_VALUE, 100L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.multiply(100L, Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)this.multiply(Long.MIN_VALUE, 100L));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)this.multiply(100L, Long.MIN_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)this.multiply(Long.MAX_VALUE, -100L));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)this.multiply(-100L, Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.multiply(Long.MIN_VALUE, -100L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.multiply(-100L, Long.MIN_VALUE));
    }

    @Test
    public void testMultLimitL() {
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.multiply(Long.MAX_VALUE, Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)this.multiply(Long.MAX_VALUE, Long.MIN_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)this.multiply(Long.MIN_VALUE, Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.multiply(Long.MIN_VALUE, Long.MIN_VALUE));
    }

    @Test
    public void testAdd0() {
        Assert.assertEquals((long)0L, (long)this.add(0, 0));
        Assert.assertEquals((long)1L, (long)this.add(0, 1));
        Assert.assertEquals((long)1L, (long)this.add(1, 0));
        Assert.assertEquals((long)42L, (long)this.add(42, 0));
        Assert.assertEquals((long)42L, (long)this.add(0, 42));
        Assert.assertEquals((long)-42L, (long)this.add(-42, 0));
        Assert.assertEquals((long)-42L, (long)this.add(0, -42));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.add(Integer.MAX_VALUE, 0));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.add(0, Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)this.add(Integer.MIN_VALUE, 0));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)this.add(0, Integer.MIN_VALUE));
    }

    @Test
    public void testAdd100() {
        Assert.assertEquals((long)200L, (long)this.add(100, 100));
        Assert.assertEquals((long)0L, (long)this.add(100, -100));
        Assert.assertEquals((long)0L, (long)this.add(-100, 100));
        Assert.assertEquals((long)-200L, (long)this.add(-100, -100));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.add(Integer.MAX_VALUE, 100));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.add(100, Integer.MAX_VALUE));
        Assert.assertEquals((long)-2147483548L, (long)this.add(Integer.MIN_VALUE, 100));
        Assert.assertEquals((long)-2147483548L, (long)this.add(100, Integer.MIN_VALUE));
        Assert.assertEquals((long)2147483547L, (long)this.add(Integer.MAX_VALUE, -100));
        Assert.assertEquals((long)2147483547L, (long)this.add(-100, Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)this.add(Integer.MIN_VALUE, -100));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)this.add(-100, Integer.MIN_VALUE));
    }

    @Test
    public void testAddLimit() {
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.add(Integer.MAX_VALUE, Integer.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)this.add(Integer.MAX_VALUE, Integer.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)this.add(Integer.MIN_VALUE, Integer.MAX_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)this.add(Integer.MIN_VALUE, Integer.MIN_VALUE));
    }

    @Test
    public void testAdd0L() {
        Assert.assertEquals((long)0L, (long)this.add(0L, 0L));
        Assert.assertEquals((long)1L, (long)this.add(0L, 1L));
        Assert.assertEquals((long)1L, (long)this.add(1L, 0L));
        Assert.assertEquals((long)42L, (long)this.add(42L, 0L));
        Assert.assertEquals((long)42L, (long)this.add(0L, 42L));
        Assert.assertEquals((long)-42L, (long)this.add(-42L, 0L));
        Assert.assertEquals((long)-42L, (long)this.add(0L, -42L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.add(Long.MAX_VALUE, 0L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.add(0L, Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)this.add(Long.MIN_VALUE, 0L));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)this.add(0L, Long.MIN_VALUE));
    }

    @Test
    public void testAdd100L() {
        Assert.assertEquals((long)200L, (long)this.add(100L, 100L));
        Assert.assertEquals((long)0L, (long)this.add(100L, -100L));
        Assert.assertEquals((long)0L, (long)this.add(-100L, 100L));
        Assert.assertEquals((long)-200L, (long)this.add(-100L, -100L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.add(Long.MAX_VALUE, 100L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.add(100L, Long.MAX_VALUE));
        Assert.assertEquals((long)-9223372036854775708L, (long)this.add(Long.MIN_VALUE, 100L));
        Assert.assertEquals((long)-9223372036854775708L, (long)this.add(100L, Long.MIN_VALUE));
        Assert.assertEquals((long)9223372036854775707L, (long)this.add(Long.MAX_VALUE, -100L));
        Assert.assertEquals((long)9223372036854775707L, (long)this.add(-100L, Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)this.add(Long.MIN_VALUE, -100L));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)this.add(-100L, Long.MIN_VALUE));
    }

    @Test
    public void testAddLimitL() {
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.add(Long.MAX_VALUE, Long.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)this.add(Long.MAX_VALUE, Long.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)this.add(Long.MIN_VALUE, Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)this.add(Long.MIN_VALUE, Long.MIN_VALUE));
    }

    @Test
    public void testSameSign() {
        Assert.assertTrue((boolean)this.sameSign(0L, 0L));
        Assert.assertTrue((boolean)this.sameSign(0L, 0L));
        Assert.assertFalse((boolean)this.sameSign(0L, -100L));
        Assert.assertFalse((boolean)this.sameSign(-100L, 0L));
        Assert.assertTrue((boolean)this.sameSign(0L, 100L));
        Assert.assertTrue((boolean)this.sameSign(100L, 0L));
        Assert.assertFalse((boolean)this.sameSign(0L, -100L));
        Assert.assertFalse((boolean)this.sameSign(-100L, 0L));
        Assert.assertTrue((boolean)this.sameSign(0L, 100L));
        Assert.assertTrue((boolean)this.sameSign(100L, 0L));
        Assert.assertTrue((boolean)this.sameSign(100L, 100L));
        Assert.assertFalse((boolean)this.sameSign(100L, -100L));
        Assert.assertFalse((boolean)this.sameSign(-100L, 100L));
        Assert.assertTrue((boolean)this.sameSign(-100L, -100L));
        Assert.assertTrue((boolean)this.sameSign(Long.MAX_VALUE, 100L));
        Assert.assertTrue((boolean)this.sameSign(100L, Long.MAX_VALUE));
        Assert.assertFalse((boolean)this.sameSign(Long.MIN_VALUE, 100L));
        Assert.assertFalse((boolean)this.sameSign(100L, Long.MIN_VALUE));
        Assert.assertFalse((boolean)this.sameSign(Long.MAX_VALUE, -100L));
        Assert.assertFalse((boolean)this.sameSign(-100L, Long.MAX_VALUE));
        Assert.assertTrue((boolean)this.sameSign(Long.MIN_VALUE, -100L));
        Assert.assertTrue((boolean)this.sameSign(-100L, Long.MIN_VALUE));
    }

    protected abstract int multiply(int var1, int var2);

    protected abstract long multiply(long var1, long var3);

    protected abstract int add(int var1, int var2);

    protected abstract long add(long var1, long var3);

    protected abstract boolean sameSign(long var1, long var3);
}

