/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.IDataDrivenCompilationUnit;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlOutputEntryCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenOutputEntry;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenPresentationState;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenTimeGraphProviderFactory;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.w3c.dom.Element;

public class TmfXmlTimeGraphViewCu
implements IDataDrivenCompilationUnit {
    private final List<DataDrivenPresentationState> fValues;
    private final List<TmfXmlOutputEntryCu> fEntries;
    private final Set<String> fAnalysisIds;

    private TmfXmlTimeGraphViewCu(List<DataDrivenPresentationState> values, List<TmfXmlOutputEntryCu> entriesCu, Set<String> analysisIds) {
        this.fValues = values;
        this.fEntries = entriesCu;
        this.fAnalysisIds = analysisIds;
    }

    @Override
    public DataDrivenTimeGraphProviderFactory generate() {
        List<DataDrivenOutputEntry> entries = this.fEntries.stream().map(TmfXmlOutputEntryCu::generate).collect(Collectors.toList());
        return new DataDrivenTimeGraphProviderFactory(entries, this.fAnalysisIds, this.fValues);
    }

    public static @Nullable TmfXmlTimeGraphViewCu compile(AnalysisCompilationData compilationData, Element viewElement) {
        ArrayList<DataDrivenPresentationState> values = new ArrayList<DataDrivenPresentationState>();
        List<Element> childElements = TmfXmlUtils.getChildElements(viewElement, "definedValue");
        for (Element element : childElements) {
            values.add(new DataDrivenPresentationState(element.getAttribute("value"), element.getAttribute("name"), element.getAttribute("color")));
        }
        Set<@NonNull String> analysisIds = TmfXmlUtils.getViewAnalysisIds(viewElement);
        List<Element> entries = TmfXmlUtils.getChildElements(viewElement, "entry");
        ArrayList<TmfXmlOutputEntryCu> entriesCu = new ArrayList<TmfXmlOutputEntryCu>();
        for (Element entry : entries) {
            TmfXmlOutputEntryCu entryCu = TmfXmlOutputEntryCu.compile(compilationData, entry);
            if (entryCu == null) continue;
            entriesCu.add(entryCu);
        }
        return new TmfXmlTimeGraphViewCu(values, entriesCu, analysisIds);
    }
}

