/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.perf.event.matching;

import java.util.Collections;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.event.matching.TcpEventMatching;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.event.matching.TcpLttngEventMatching;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.event.matching.ITmfMatchEventDefinition;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.tracecompass.tmf.core.synchronization.SynchronizationAlgorithm;
import org.eclipse.tracecompass.tmf.core.synchronization.SynchronizationManager;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TraceSynchronizationBenchmark {
    private static final String TEST_ID = "org.eclipse.linuxtools#Trace synchronization#";
    private static final String TIME = " (time)";
    private static final String MEMORY = " (memory usage)";
    private static final String TEST_SUMMARY = "Trace synchronization";

    @BeforeClass
    public static void setUp() {
        TmfEventMatching.registerMatchObject((ITmfMatchEventDefinition)new TcpEventMatching());
        TmfEventMatching.registerMatchObject((ITmfMatchEventDefinition)new TcpLttngEventMatching());
    }

    @Test
    public void testSmallTraces() {
        CtfTmfTrace trace1 = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.SYNC_SRC);
        CtfTmfTrace trace2 = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.SYNC_DEST);
        ITmfTrace[] traces = new ITmfTrace[]{trace1, trace2};
        TmfExperiment experiment = new TmfExperiment(CtfTmfEvent.class, "Test experiment", traces, 5000, null);
        TraceSynchronizationBenchmark.runCpuTest(experiment, "Match TCP events", 40);
        trace1.dispose();
        trace2.dispose();
    }

    @Test
    public void testDjangoTraces() {
        CtfTmfTrace trace1 = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.DJANGO_CLIENT);
        CtfTmfTrace trace2 = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.DJANGO_DB);
        CtfTmfTrace trace3 = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.DJANGO_HTTPD);
        ITmfTrace[] traces = new ITmfTrace[]{trace1, trace2, trace3};
        TmfExperiment experiment = new TmfExperiment(CtfTmfEvent.class, "Test experiment", traces, 5000, null);
        TraceSynchronizationBenchmark.runCpuTest(experiment, "Django traces", 10);
        TraceSynchronizationBenchmark.runMemoryTest(experiment, "Django traces", 10);
        trace1.dispose();
        trace2.dispose();
        trace3.dispose();
    }

    private static void runCpuTest(@NonNull TmfExperiment experiment, String testName, int loop_count) {
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter(TEST_ID + testName + TIME);
        perf.tagAsSummary(pm, "Trace synchronization:" + testName + TIME, Dimension.CPU_TIME);
        int i = 0;
        while (i < loop_count) {
            pm.start();
            SynchronizationManager.synchronizeTraces(null, Collections.singleton(experiment), (boolean)true);
            pm.stop();
            ++i;
        }
        pm.commit();
    }

    private static void runMemoryTest(@NonNull TmfExperiment experiment, String testName, int loop_count) {
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter(TEST_ID + testName + MEMORY);
        perf.tagAsSummary(pm, "Trace synchronization:" + testName + MEMORY, Dimension.USED_JAVA_HEAP);
        int i = 0;
        while (i < loop_count) {
            System.gc();
            pm.start();
            SynchronizationAlgorithm algo = SynchronizationManager.synchronizeTraces(null, Collections.singleton(experiment), (boolean)true);
            Assert.assertNotNull((Object)algo);
            System.gc();
            pm.stop();
            ++i;
        }
        pm.commit();
    }
}

