/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.core.templateengine.process.Messages;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessParameter;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.ProcessRunnerFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;

public class Process {
    public static final String ELEM_TYPE = "type";
    private ProcessRunner processRunner;
    private ProcessArgument[] args;
    private TemplateCore template;
    private String id;
    private String processType;

    public Process(TemplateCore template, Element element, String id) {
        this.template = template;
        this.id = id;
        this.processType = element.getAttribute(ELEM_TYPE);
        this.processRunner = ProcessRunnerFactory.getDefault().getProcessRunner(this.processType);
        if (this.processRunner != null) {
            this.buildArgs(template, element);
        }
    }

    private void buildArgs(TemplateCore templateCore, Element element) {
        List<Element> children = TemplateEngine.getChildrenOfElement(element);
        ProcessParameter[] params = this.processRunner.getProcessParameters();
        ArrayList<ProcessArgument> list = new ArrayList<ProcessArgument>(params.length);
        int childIndex = 0;
        int i = 0;
        while (i < params.length) {
            Element child;
            ProcessParameter param = params[i];
            boolean childrenRemain = childIndex < children.size();
            Element element2 = child = childrenRemain ? children.get(childIndex) : null;
            if (param.isExternal() && (child == null || !param.getName().equals(child.getAttribute("name")))) {
                list.add(new ProcessArgument(templateCore, param));
            } else if (childrenRemain) {
                list.add(new ProcessArgument(templateCore, child));
                ++childIndex;
            }
            ++i;
        }
        while (childIndex < children.size()) {
            list.add(new ProcessArgument(templateCore, children.get(childIndex++)));
        }
        this.args = list.toArray(new ProcessArgument[list.size()]);
    }

    public boolean isReadyToProcess() {
        return this.processRunner != null && this.processRunner.areArgumentsMatchingRequiredParameters(this.args) && this.areAllMacrosExpandable();
    }

    private boolean areAllMacrosExpandable() {
        if (this.args != null) {
            int i = 0;
            while (i < this.args.length) {
                ProcessArgument arg = this.args[i];
                if (!arg.areAllMacrosExpandable()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private String getFirstNonExpandableMacroMessage(ProcessArgument[] args2) {
        if (this.args != null) {
            int i = 0;
            while (i < this.args.length) {
                ProcessArgument arg = this.args[i];
                String macro = arg.getFirstNonExpandableMacro();
                if (macro != null) {
                    return Messages.getString("Process.argument") + arg.getName() + Messages.getString("Process.expandableMacro") + macro;
                }
                ++i;
            }
        }
        return null;
    }

    private String getProcessMessage(int code, String msg) {
        switch (code) {
            case 4: {
                return this.id + Messages.getString("Process.error") + msg;
            }
            case 0: {
                return this.id + Messages.getString("Process.success") + msg;
            }
        }
        return this.id + Messages.getString("Process.info") + msg;
    }

    public IStatus process(IProgressMonitor monitor) throws ProcessFailureException {
        if (this.processRunner == null) {
            throw new ProcessFailureException(Messages.getString("Process.unknownProcess") + this.processType);
        }
        if (!this.processRunner.areArgumentsMatchingRequiredParameters(this.args)) {
            throw new ProcessFailureException(this.processRunner.getArgumentsMismatchMessage(this.args));
        }
        if (!this.areAllMacrosExpandable()) {
            throw new ProcessFailureException(this.getProcessMessage(4, this.getFirstNonExpandableMacroMessage(this.args)));
        }
        this.resolve();
        this.processRunner.process(this.template, this.args, this.id, monitor);
        return new Status(1, this.getClass(), 0, this.getProcessMessage(0, Messages.getString("Process.executedSuccessfully") + String.valueOf(Arrays.asList(this.args))), null);
    }

    private void resolve() {
        if (this.args != null) {
            int i = 0;
            while (i < this.args.length) {
                ProcessArgument arg = this.args[i];
                if (!arg.isResolved()) {
                    arg.resolve();
                }
                ++i;
            }
        }
    }

    public Set<String> getMacros() {
        HashSet<String> set = null;
        if (this.args != null) {
            int i = 0;
            while (i < this.args.length) {
                ProcessArgument arg = this.args[i];
                Set<String> subSet = arg.getMacros();
                if (subSet != null) {
                    if (set == null) {
                        set = new HashSet<String>();
                    }
                    set.addAll(subSet);
                }
                ++i;
            }
        }
        return set;
    }

    public String toString() {
        return this.id;
    }
}

