/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.callstack.core.Activator;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.FlowsRowModel;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.Otf2FlowsAnalysis;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.AbstractTimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class Otf2FlowsDataProvider
extends AbstractTimeGraphDataProvider<Otf2FlowsAnalysis, TimeGraphEntryModel>
implements IOutputStyleProvider {
    public static final String SUFFIX = ".dataprovider";
    private static final String TOTAL_FLOW = "Total flow : ";
    private static final String FLOW_UNIT = "MB/s";

    public static String getFullDataProviderId() {
        return Otf2FlowsAnalysis.getFullAnalysisId() + SUFFIX;
    }

    public Otf2FlowsDataProvider(ITmfTrace trace, Otf2FlowsAnalysis analysisModule) {
        super(trace, (TmfStateSystemAnalysisModule)analysisModule);
    }

    public String getId() {
        return ((Otf2FlowsAnalysis)this.getAnalysisModule()).getId() + SUFFIX;
    }

    public TmfModelResponse<OutputStyleModel> fetchStyle(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public TmfModelResponse<List<ITimeGraphArrow>> fetchArrows(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public TmfModelResponse<Map<String, String>> fetchTooltip(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        ITmfStateSystem ss = ((Otf2FlowsAnalysis)this.getAnalysisModule()).getStateSystem();
        List requestedTimes = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
        List requestedEntries = DataProviderParameterUtils.extractSelectedItems(fetchParameters);
        if (ss == null || requestedEntries == null || requestedEntries.size() != 1 || requestedTimes == null || requestedTimes.size() != 1) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        Map entryIdToQuarks = this.getSelectedEntries(requestedEntries);
        double totalFlow = 0.0;
        Integer quark = (Integer)entryIdToQuarks.get(requestedEntries.get(0));
        if (quark == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        List quarksToQuery = ss.getSubAttributes(quark.intValue(), true);
        if (quarksToQuery.isEmpty()) {
            quarksToQuery.add(quark);
        }
        try {
            for (ITmfStateInterval interval : ss.query2D((Collection)quarksToQuery, (Collection)requestedTimes)) {
                totalFlow += interval.getValueDouble();
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException e) {
            Activator.getInstance().logError(e.getMessage(), e);
        }
        HashMap<String, CallSite> model = new HashMap<String, CallSite>();
        model.put(TOTAL_FLOW, (CallSite)((Object)(String.valueOf(totalFlow * 1000.0) + FLOW_UNIT)));
        return new TmfModelResponse(model, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private void fillLeafQuarks(ITmfStateSystem ss, Map<Integer, FlowsRowModel> quarkRowMap, List<Integer> leafQuarks, int quark) {
        List subQuarks = ss.getSubAttributes(quark, false);
        if (subQuarks.isEmpty()) {
            leafQuarks.add(quark);
        }
        FlowsRowModel parentFlowsRowModel = quarkRowMap.get(quark);
        for (Integer subQuark : subQuarks) {
            quarkRowMap.put(subQuark, new FlowsRowModel(this.getId(subQuark), new ArrayList<ITimeGraphState>(), parentFlowsRowModel));
            this.fillLeafQuarks(ss, quarkRowMap, leafQuarks, subQuark);
        }
    }

    private void fillRowModels(ITmfStateSystem ss, Map<Integer, FlowsRowModel> quarkRowMap, int childQuark, Map<Integer, Predicate<Multimap<String, Object>>> predicates, @Nullable IProgressMonitor monitor) {
        Integer parentQuark = ss.getParentAttributeQuark(childQuark);
        if (parentQuark != -1) {
            FlowsRowModel parentFlowRowModel = quarkRowMap.get(childQuark);
            FlowsRowModel flowRowModel = quarkRowMap.get(parentQuark);
            if (parentFlowRowModel != null && flowRowModel != null) {
                flowRowModel.computeStatisticsAndStates(this, predicates, monitor);
                quarkRowMap.put(parentQuark, flowRowModel);
                this.fillRowModels(ss, quarkRowMap, parentQuark, predicates, monitor);
            }
        }
    }

    protected @Nullable TimeGraphModel getRowModel(ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        SelectionTimeQueryFilter filter;
        HashMap<Integer, Predicate<Multimap<String, Object>>> predicates = new HashMap<Integer, Predicate<Multimap<String, Object>>>();
        Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(parameters);
        if (regexesMap != null) {
            predicates.putAll(this.computeRegexPredicate(regexesMap));
        }
        if ((filter = FetchParametersUtils.createSelectionTimeQuery(parameters)) == null) {
            return null;
        }
        Collection times = Otf2FlowsDataProvider.getTimes((TimeQueryFilter)filter, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
        ArrayList<Integer> leafQuarks = new ArrayList<Integer>();
        HashMap<Integer, FlowsRowModel> quarkRowMap = new HashMap<Integer, FlowsRowModel>();
        this.fillLeafQuarks(ss, quarkRowMap, leafQuarks, -1);
        for (ITmfStateInterval interval : ss.query2D(leafQuarks, times)) {
            int quark = interval.getAttribute();
            long startTime = interval.getStartTime();
            long endTime = interval.getEndTime();
            double flowValue = interval.getValueDouble();
            FlowsRowModel rowModel = (FlowsRowModel)((Object)quarkRowMap.get(quark));
            if (rowModel == null) continue;
            rowModel.addFlowChange(startTime, flowValue);
            rowModel.addFlowChange(endTime, -flowValue);
        }
        Iterator<Object> iterator = leafQuarks.iterator();
        while (iterator.hasNext()) {
            int leafQuark = (Integer)iterator.next();
            this.fillRowModels(ss, quarkRowMap, leafQuark, predicates, monitor);
        }
        ArrayList<TimeGraphRowModel> rows = new ArrayList<TimeGraphRowModel>();
        for (Map.Entry entry : quarkRowMap.entrySet()) {
            long entryId = this.getId((Integer)entry.getKey());
            List eventList = Objects.requireNonNull((FlowsRowModel)((Object)entry.getValue())).getStates();
            rows.add(new TimeGraphRowModel(entryId, eventList));
        }
        return new TimeGraphModel(rows);
    }

    protected boolean isCacheable() {
        return false;
    }

    protected TmfTreeModel<TimeGraphEntryModel> getTree(ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        long parentId = this.getId(-1);
        builder.add((Object)new TimeGraphEntryModel(parentId, -1L, String.valueOf(this.getTrace().getName()), ss.getStartTime(), ss.getCurrentEndTime()));
        this.addChildren(ss, (ImmutableList.Builder<TimeGraphEntryModel>)builder, -1, parentId);
        return new TmfTreeModel(Collections.emptyList(), (List)builder.build());
    }

    private void addChildren(ITmfStateSystem ss, ImmutableList.Builder<TimeGraphEntryModel> builder, int quark, long parentId) {
        for (Integer child : ss.getSubAttributes(quark, false)) {
            long childId = this.getId(child);
            String name = ss.getAttributeName(child.intValue());
            builder.add((Object)new TimeGraphEntryModel(childId, parentId, name, ss.getStartTime(), ss.getCurrentEndTime(), true));
            this.addChildren(ss, builder, child, childId);
        }
    }
}

