/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.callstack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.incubator.callstack.core.base.EdgeStateValue;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.AbstractOtf2StateProvider;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.IOtf2Constants;
import org.eclipse.tracecompass.incubator.internal.otf2.core.mpi.AllToRootIdentifiers;
import org.eclipse.tracecompass.incubator.internal.otf2.core.mpi.CollectiveOperationIdentifiers;
import org.eclipse.tracecompass.incubator.internal.otf2.core.mpi.MessageIdentifiers;
import org.eclipse.tracecompass.incubator.internal.otf2.core.mpi.RootToAllIdentifiers;
import org.eclipse.tracecompass.incubator.internal.otf2.core.trace.Location;
import org.eclipse.tracecompass.incubator.internal.otf2.core.trace.LocationGroup;
import org.eclipse.tracecompass.incubator.internal.otf2.core.trace.SystemTreeNode;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class Otf2CallStackStateProvider
extends AbstractOtf2StateProvider {
    private static final String ID = "org.eclipse.tracecompass.incubator.otf2.callstackstateprovider";
    public static final String PROCESSES = "Processes";
    private final Map<Long, CallstackSystemTreeNode> fMapSystemTreeNode = new HashMap<Long, CallstackSystemTreeNode>();
    private final Map<Long, CallstackLocationGroup> fMapLocationGroup = new HashMap<Long, CallstackLocationGroup>();
    private final Map<Long, CallstackLocation> fMapLocation = new HashMap<Long, CallstackLocation>();
    private final Map<MessageIdentifiers, ITmfEvent> fMsgDataEvent = new HashMap<MessageIdentifiers, ITmfEvent>();
    private final Queue<RootToAllIdentifiers> fRootToAllQueue = new LinkedList<RootToAllIdentifiers>();
    private final Queue<AllToRootIdentifiers> fAllToRootQueue = new LinkedList<AllToRootIdentifiers>();
    private boolean fAllDefinitionsRead = false;

    private int getSystemTreeNodeQuark(long systemTreeNodeId) {
        CallstackSystemTreeNode systemTreeNode = this.fMapSystemTreeNode.get(systemTreeNodeId);
        if (systemTreeNode == null) {
            return -1;
        }
        return systemTreeNode.getQuark();
    }

    private int getLocationGroupQuark(long locationGroupId) {
        CallstackLocationGroup locationGroup = this.fMapLocationGroup.get(locationGroupId);
        if (locationGroup == null) {
            return -1;
        }
        return locationGroup.getQuark();
    }

    public Otf2CallStackStateProvider(@Nullable ITmfTrace trace) {
        super(trace, ID);
    }

    public int getVersion() {
        return 2;
    }

    @Override
    public ITmfStateProvider getNewInstance() {
        return new Otf2CallStackStateProvider(this.getTrace());
    }

    @Override
    protected void processGlobalDefinition(ITmfEvent event, String name) {
        switch (name) {
            case "String": {
                this.processStringDefinition(event);
                break;
            }
            case "Region": {
                this.processRegionDefinition(event);
                break;
            }
            case "Location": {
                this.processLocationDefinition(event);
                break;
            }
            case "LocationGroup": {
                this.processLocationGroupDefinition(event);
                break;
            }
            case "Comm": {
                this.processCommunicatorDefinition(event);
                break;
            }
            case "Group": {
                this.processGroupDefinition(event);
                break;
            }
            case "GroupMember": {
                this.processGroupMemberDefinition(event);
                break;
            }
            case "SystemTreeNode": {
                this.processSystemTreeNodeDefinition(event);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void processLocationDefinition(ITmfEvent event) {
        CallstackLocation location = new CallstackLocation(event);
        this.fMapLocation.put(location.getId(), location);
    }

    private void processLocationGroupDefinition(ITmfEvent event) {
        CallstackLocationGroup locationGroup = new CallstackLocationGroup(event);
        this.fMapLocationGroup.put(locationGroup.getId(), locationGroup);
    }

    private void processSystemTreeNodeDefinition(ITmfEvent event) {
        CallstackSystemTreeNode systemTreeNode = new CallstackSystemTreeNode(event);
        this.fMapSystemTreeNode.put(systemTreeNode.getId(), systemTreeNode);
    }

    @Override
    protected void processOtf2Event(ITmfEvent event, String name, ITmfStateSystemBuilder ssb) {
        long locationId;
        CallstackLocation location;
        if (!this.fAllDefinitionsRead) {
            this.initializeQuarks(ssb);
            this.fAllDefinitionsRead = true;
        }
        if ((location = this.fMapLocation.get(locationId = this.getLocationId(event))) == null) {
            return;
        }
        switch (name) {
            case "Enter": {
                location.enter(event, ssb);
                break;
            }
            case "Leave": {
                location.leave(event, ssb);
                break;
            }
            case "MpiSend": 
            case "MpiIsend": {
                location.mpiSend(event);
                break;
            }
            case "MpiRecv": 
            case "MpiIrecv": {
                location.mpiRecv(event, ssb);
                break;
            }
            case "MpiCollectiveBegin": {
                location.mpiCollectiveBegin(event);
                break;
            }
            case "MpiCollectiveEnd": {
                Otf2CallStackStateProvider.processMpiCollectiveEnd(event, ssb, location);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void initializeQuarks(ITmfStateSystemBuilder ssb) {
        for (CallstackSystemTreeNode systemTreeNode : this.fMapSystemTreeNode.values()) {
            systemTreeNode.initializeQuarks(ssb);
        }
        for (CallstackLocationGroup locationGroup : this.fMapLocationGroup.values()) {
            locationGroup.initializeQuarks(ssb);
        }
        for (CallstackLocation location : this.fMapLocation.values()) {
            location.initializeQuarks(ssb);
        }
    }

    private static void processMpiCollectiveEnd(ITmfEvent event, ITmfStateSystemBuilder ssb, CallstackLocation location) {
        ITmfEventField content = event.getContent();
        Integer operationCode = (Integer)content.getFieldValue(Integer.class, new String[]{"collectiveOp"});
        if (operationCode == null) {
            return;
        }
        switch (IOtf2Constants.getOperation(operationCode)) {
            case BCAST: 
            case SCATTER: 
            case SCATTERV: {
                location.mpiRootToAll(event, ssb);
                return;
            }
            case GATHER: 
            case GATHERV: 
            case REDUCE: {
                location.mpiAllToRoot(event, ssb);
                return;
            }
        }
    }

    private static void addArrow(ITmfStateSystemBuilder ssb, Long startTime, Long endTime, int id, HostThread src, HostThread dest) {
        int edgeQuark = Otf2CallStackStateProvider.getAvailableEdgeQuark(ssb, startTime);
        EdgeStateValue edgeStateValue = new EdgeStateValue(id, src, dest);
        ssb.modifyAttribute(startTime.longValue(), (Object)edgeStateValue, edgeQuark);
        ssb.modifyAttribute(endTime.longValue(), null, edgeQuark);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static int getAvailableEdgeQuark(ITmfStateSystemBuilder ssb, Long startTime) {
        int edgeRoot = ssb.getQuarkAbsoluteAndAdd(new String[]{"Edges"});
        @NonNull List subQuarks = ssb.getSubAttributes(edgeRoot, false);
        Iterator iterator = subQuarks.iterator();
        while (iterator.hasNext()) {
            int quark = (Integer)iterator.next();
            long start = ssb.getOngoingStartTime(quark);
            Object value = ssb.queryOngoing(quark);
            if (value != null || start > startTime) continue;
            return quark;
        }
        return ssb.getQuarkRelativeAndAdd(edgeRoot, new String[]{Integer.toString(subQuarks.size())});
    }

    private class CallstackLocation
    extends Location {
        private long fCollectiveBeginTimestamp;
        private int fLocationQuark;
        private int fCallStackQuark;

        public CallstackLocation(ITmfEvent event) {
            super(event);
            this.fCollectiveBeginTimestamp = 0L;
            this.fLocationQuark = -1;
            this.fCallStackQuark = -1;
        }

        public void initializeQuarks(ITmfStateSystemBuilder ssb) {
            String locationName = this.getName(Otf2CallStackStateProvider.this.getStringId());
            int processQuark = Otf2CallStackStateProvider.this.getLocationGroupQuark(this.getLocationGroupId());
            this.fLocationQuark = ssb.getQuarkRelativeAndAdd(processQuark, new String[]{locationName});
            this.fCallStackQuark = ssb.getQuarkRelativeAndAdd(this.fLocationQuark, new String[]{"CallStack"});
        }

        public void enter(ITmfEvent event, ITmfStateSystemBuilder ssb) {
            ITmfEventField content = event.getContent();
            long timestamp = event.getTimestamp().toNanos();
            ssb.updateOngoingState((ITmfStateValue)TmfStateValue.newValueLong((long)this.getId()), this.fLocationQuark);
            Integer regionRef = (Integer)content.getFieldValue(Integer.class, new String[]{"region"});
            if (regionRef == null) {
                ssb.modifyAttribute(timestamp, null, this.fCallStackQuark);
                return;
            }
            ssb.pushAttribute(timestamp, (Object)Otf2CallStackStateProvider.this.getRegionNameFromRegionId(regionRef), this.fCallStackQuark);
        }

        public void leave(ITmfEvent event, ITmfStateSystemBuilder ssb) {
            long timestamp = event.getTimestamp().toNanos();
            ssb.popAttribute(timestamp, this.fCallStackQuark);
        }

        public void mpiSend(ITmfEvent srcEvent) {
            ITmfEventField content = srcEvent.getContent();
            Integer communicator = (Integer)content.getFieldValue(Integer.class, new String[]{"communicator"});
            if (communicator == null) {
                return;
            }
            Integer srcRank = Otf2CallStackStateProvider.this.getRank(this.getId(), communicator);
            Integer destRank = (Integer)content.getFieldValue(Integer.class, new String[]{"receiver"});
            Integer messageTag = (Integer)content.getFieldValue(Integer.class, new String[]{"msgTag"});
            if (destRank == null || messageTag == null || srcRank == -1) {
                return;
            }
            Otf2CallStackStateProvider.this.fMsgDataEvent.put(new MessageIdentifiers(communicator, srcRank, destRank, messageTag), srcEvent);
        }

        public void mpiRecv(ITmfEvent destEvent, ITmfStateSystemBuilder ssb) {
            ITmfEventField content = destEvent.getContent();
            Integer communicator = (Integer)content.getFieldValue(Integer.class, new String[]{"communicator"});
            if (communicator == null) {
                return;
            }
            Integer srcRank = (Integer)content.getFieldValue(Integer.class, new String[]{"sender"});
            Integer destRank = Otf2CallStackStateProvider.this.getRank(this.getId(), communicator);
            Integer messageTag = (Integer)content.getFieldValue(Integer.class, new String[]{"msgTag"});
            if (srcRank == null || messageTag == null || destRank == -1) {
                return;
            }
            ITmfEvent srcEvent = Otf2CallStackStateProvider.this.fMsgDataEvent.remove(new MessageIdentifiers(communicator, srcRank, destRank, messageTag));
            if (srcEvent == null) {
                return;
            }
            long srcLocationId = Otf2CallStackStateProvider.this.getLocationId(srcEvent);
            HostThread src = new HostThread(srcEvent.getTrace().getHostId(), Integer.valueOf((int)srcLocationId));
            HostThread dest = new HostThread(destEvent.getTrace().getHostId(), Integer.valueOf((int)this.getId()));
            Otf2CallStackStateProvider.addArrow(ssb, srcEvent.getTimestamp().toNanos(), destEvent.getTimestamp().toNanos(), messageTag, src, dest);
        }

        public void mpiCollectiveBegin(ITmfEvent event) {
            this.fCollectiveBeginTimestamp = event.getTimestamp().toNanos();
        }

        public void mpiRootToAll(ITmfEvent destEvent, ITmfStateSystemBuilder ssb) {
            ITmfEventField content = destEvent.getContent();
            Integer root = (Integer)content.getFieldValue(Integer.class, new String[]{"root"});
            Integer communicator = (Integer)content.getFieldValue(Integer.class, new String[]{"communicator"});
            Integer operationCode = (Integer)content.getFieldValue(Integer.class, new String[]{"collectiveOp"});
            if (root == null || communicator == null || operationCode == null) {
                return;
            }
            long srcLocationId = Otf2CallStackStateProvider.this.getLocationIdFromRank(root, communicator);
            CollectiveOperationIdentifiers associatedOperation = null;
            for (RootToAllIdentifiers operationProperties : Otf2CallStackStateProvider.this.fRootToAllQueue) {
                if (!operationProperties.isAssociatedOperation(operationCode, srcLocationId, communicator, this.getId())) continue;
                associatedOperation = operationProperties;
            }
            ITmfEvent srcEvent = null;
            if (associatedOperation == null) {
                srcEvent = destEvent;
                ArrayList members = Otf2CallStackStateProvider.this.getMembersFromCommunicatorReference(communicator);
                ArrayList<Long> pendingLocations = new ArrayList<Long>(members);
                associatedOperation = new RootToAllIdentifiers(operationCode, communicator, srcLocationId, srcEvent, pendingLocations);
                Otf2CallStackStateProvider.this.fRootToAllQueue.add((RootToAllIdentifiers)associatedOperation);
            }
            associatedOperation.locationCalledOperation(this.getId(), this.fCollectiveBeginTimestamp);
            if (associatedOperation.isOperationDone()) {
                Otf2CallStackStateProvider.this.fRootToAllQueue.remove(associatedOperation);
            }
            if (srcLocationId == this.getId()) {
                return;
            }
            if (srcEvent == null) {
                srcEvent = ((RootToAllIdentifiers)associatedOperation).getBeginEvent();
            }
            HostThread src = new HostThread(srcEvent.getTrace().getHostId(), Integer.valueOf((int)srcLocationId));
            HostThread dest = new HostThread(destEvent.getTrace().getHostId(), Integer.valueOf((int)this.getId()));
            Otf2CallStackStateProvider.addArrow(ssb, srcEvent.getTimestamp().toNanos(), destEvent.getTimestamp().toNanos(), root, src, dest);
        }

        public void mpiAllToRoot(ITmfEvent srcEvent, ITmfStateSystemBuilder ssb) {
            ITmfEventField content = srcEvent.getContent();
            Integer root = (Integer)content.getFieldValue(Integer.class, new String[]{"root"});
            Integer communicator = (Integer)content.getFieldValue(Integer.class, new String[]{"communicator"});
            Integer operationCode = (Integer)content.getFieldValue(Integer.class, new String[]{"collectiveOp"});
            if (root == null || communicator == null || operationCode == null) {
                return;
            }
            long destLocationId = Otf2CallStackStateProvider.this.getLocationIdFromRank(root, communicator);
            AllToRootIdentifiers associatedOperation = null;
            for (AllToRootIdentifiers operationProperties : Otf2CallStackStateProvider.this.fAllToRootQueue) {
                if (!operationProperties.isAssociatedOperation(operationCode, destLocationId, communicator, this.getId())) continue;
                associatedOperation = operationProperties;
            }
            if (associatedOperation == null) {
                ArrayList members = Otf2CallStackStateProvider.this.getMembersFromCommunicatorReference(communicator);
                ArrayList<Long> pendingLocations = new ArrayList<Long>(members);
                associatedOperation = new AllToRootIdentifiers(operationCode, communicator, destLocationId, pendingLocations);
                Otf2CallStackStateProvider.this.fAllToRootQueue.add(associatedOperation);
            }
            associatedOperation.locationCalledOperation(this.getId(), srcEvent);
            if (associatedOperation.isOperationDone()) {
                Otf2CallStackStateProvider.this.fAllToRootQueue.remove(associatedOperation);
                Collection<ITmfEvent> sentEvents = associatedOperation.getBeginEvents();
                for (ITmfEvent sentEvent : sentEvents) {
                    HostThread src = new HostThread(sentEvent.getTrace().getHostId(), Integer.valueOf((int)Otf2CallStackStateProvider.this.getLocationId(sentEvent)));
                    HostThread dest = new HostThread(srcEvent.getTrace().getHostId(), Integer.valueOf((int)Otf2CallStackStateProvider.this.getLocationId(srcEvent)));
                    Otf2CallStackStateProvider.addArrow(ssb, sentEvent.getTimestamp().toNanos(), srcEvent.getTimestamp().toNanos(), 0, src, dest);
                }
            }
        }
    }

    private class CallstackLocationGroup
    extends LocationGroup {
        private int fLocationGroupQuark;

        public CallstackLocationGroup(ITmfEvent event) {
            super(event);
            this.fLocationGroupQuark = -1;
        }

        public void initializeQuarks(ITmfStateSystemBuilder ssb) {
            long parentId = this.getParentId();
            String fullName = this.getFullName(Otf2CallStackStateProvider.this.getStringId());
            int nodeQuark = Otf2CallStackStateProvider.this.getSystemTreeNodeQuark(parentId);
            if (nodeQuark != -1) {
                this.fLocationGroupQuark = ssb.getQuarkRelativeAndAdd(nodeQuark, new String[]{fullName});
            }
        }

        public int getQuark() {
            return this.fLocationGroupQuark;
        }
    }

    private class CallstackSystemTreeNode
    extends SystemTreeNode {
        private int fSystemTreeNodeQuark;

        public CallstackSystemTreeNode(ITmfEvent event) {
            super(event);
            this.fSystemTreeNodeQuark = -1;
        }

        public void initializeQuarks(ITmfStateSystemBuilder ssb) {
            String fullName = this.getFullName(Otf2CallStackStateProvider.this.getStringId());
            long parentId = this.getParentId();
            if (this.isRootNode()) {
                this.fSystemTreeNodeQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{Otf2CallStackStateProvider.PROCESSES, fullName});
            } else {
                int machineQuark = Otf2CallStackStateProvider.this.getSystemTreeNodeQuark(parentId);
                if (machineQuark == -1) {
                    CallstackSystemTreeNode parentNode = Otf2CallStackStateProvider.this.fMapSystemTreeNode.get(parentId);
                    if (parentNode == null) {
                        return;
                    }
                    parentNode.initializeQuarks(ssb);
                    machineQuark = Otf2CallStackStateProvider.this.getSystemTreeNodeQuark(parentId);
                }
                if (machineQuark != -1) {
                    this.fSystemTreeNodeQuark = ssb.getQuarkRelativeAndAdd(machineQuark, new String[]{fullName});
                }
            }
        }

        public int getQuark() {
            return this.fSystemTreeNodeQuark;
        }
    }
}

