/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers;

import org.eclipse.tracecompass.incubator.internal.rocm.core.Activator;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.RocmEventLayout;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.IRocmEventHandler;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class OperationEventHandler
implements IRocmEventHandler {
    private static final String QUEUES = "Queues";
    private static final String ROCM_AGENT = "ROCm Agent ";
    private static final String QUEUE = "Queue ";
    private static final String UNKNOWN = "Unknown Operation";

    @Override
    public void handleEvent(ITmfEvent event, ITmfStateSystemBuilder ssb, RocmEventLayout layout) {
        Long timestamp = event.getTimestamp().toNanos();
        boolean isHipOperationBegin = event.getName().equals(layout.getHipOperationBegin());
        boolean isHipOperationEnd = event.getName().equals(layout.getHipOperationEnd());
        if (isHipOperationBegin || isHipOperationEnd) {
            String operationName = "";
            if (isHipOperationBegin) {
                try {
                    operationName = OperationEventHandler.getCorrespondingHipCall(event, ssb, layout);
                    if (operationName.equals("")) {
                        operationName = (String)event.getContent().getFieldValue(String.class, new String[]{layout.fieldOperationName()});
                    }
                }
                catch (AttributeNotFoundException e) {
                    Activator.getInstance().logError(e.getMessage());
                }
            }
            Integer agentId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{layout.fieldAgentId()});
            Integer queueId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{layout.fieldQueueId()});
            Long correlationId = (Long)event.getContent().getFieldValue(Long.class, new String[]{layout.fieldCorrelationId()});
            if (agentId == null || queueId == null || correlationId == null) {
                return;
            }
            int rootQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"root", QUEUES});
            int agentQuark = ssb.getQuarkRelativeAndAdd(rootQuark, new String[]{ROCM_AGENT + agentId.toString()});
            int queueQuark = ssb.getQuarkRelativeAndAdd(agentQuark, new String[]{QUEUE + queueId.toString()});
            int callStackQuark = ssb.getQuarkRelativeAndAdd(queueQuark, new String[]{"CallStack"});
            if (isHipOperationBegin) {
                int depth = 1;
                int subQuark = ssb.getQuarkRelativeAndAdd(callStackQuark, new String[]{String.valueOf(depth)});
                while (!ssb.queryOngoingState(subQuark).isNull()) {
                    subQuark = ssb.getQuarkRelativeAndAdd(callStackQuark, new String[]{String.valueOf(++depth)});
                }
                ssb.modifyAttribute(timestamp.longValue(), (Object)operationName, subQuark);
                ssb.modifyAttribute(timestamp.longValue(), (Object)depth, callStackQuark);
                int correlationIdQuark = ssb.getQuarkRelativeAndAdd(subQuark, new String[]{"correlation_id"});
                ssb.modifyAttribute(timestamp.longValue(), (Object)correlationId, correlationIdQuark);
            } else {
                int depth = 1;
                int maxDepth = ssb.queryOngoingState(callStackQuark).unboxInt();
                int subQuark = ssb.getQuarkRelativeAndAdd(callStackQuark, new String[]{String.valueOf(depth)});
                try {
                    while (ssb.queryOngoingState(ssb.getQuarkRelative(subQuark, new String[]{"correlation_id"})).unboxLong() != correlationId.longValue()) {
                        subQuark = ssb.getQuarkRelative(callStackQuark, new String[]{String.valueOf(++depth)});
                    }
                    int previousQuark = -1;
                    while (!ssb.queryOngoingState(subQuark).isNull()) {
                        if (depth >= maxDepth) {
                            ssb.modifyAttribute(timestamp.longValue(), null, subQuark);
                            ssb.modifyAttribute(timestamp.longValue(), (Object)(depth - 1), callStackQuark);
                            break;
                        }
                        previousQuark = subQuark;
                        subQuark = ssb.getQuarkRelative(callStackQuark, new String[]{String.valueOf(++depth)});
                        int nextCorrelationIdQuark = ssb.getQuarkRelativeAndAdd(subQuark, new String[]{"correlation_id"});
                        Long nextCorrelationId = ssb.queryOngoingState(nextCorrelationIdQuark).unboxLong();
                        ssb.modifyAttribute(timestamp.longValue(), null, previousQuark);
                        ssb.modifyAttribute(timestamp.longValue(), ssb.queryOngoingState(subQuark).unboxValue(), previousQuark);
                        ssb.modifyAttribute(timestamp.longValue(), (Object)nextCorrelationId, ssb.getQuarkRelativeAndAdd(previousQuark, new String[]{"correlation_id"}));
                    }
                }
                catch (AttributeNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String getCorrespondingHipCall(ITmfEvent event, ITmfStateSystemBuilder ssb, RocmEventLayout layout) throws AttributeNotFoundException {
        Long correlationId = (Long)event.getContent().getFieldValue(Long.class, new String[]{layout.fieldCorrelationId()});
        if (correlationId == null) {
            return UNKNOWN;
        }
        int operationsQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"hip_operation_queues"});
        long ts = event.getTimestamp().getValue();
        int depth = 1;
        int subQuark = ssb.getQuarkRelative(operationsQuark, new String[]{String.valueOf(depth)});
        while (correlationId.longValue() != ssb.queryOngoingState(subQuark).unboxLong()) {
            subQuark = ssb.getQuarkRelative(operationsQuark, new String[]{String.valueOf(++depth)});
        }
        ssb.modifyAttribute(ts, null, subQuark);
        int nameQuark = ssb.getQuarkRelative(subQuark, new String[]{"name"});
        String hipOperationName = ssb.queryOngoingState(nameQuark).unboxStr();
        ssb.modifyAttribute(ts, null, nameQuark);
        return hipOperationName;
    }
}

