/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.scope;

import java.util.Locale;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.IIndexSee;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.base.AbstractHelpScope;

public class IntersectionScope
extends AbstractHelpScope {
    AbstractHelpScope[] scopes;

    public IntersectionScope(AbstractHelpScope[] scopes) {
        this.scopes = scopes;
    }

    @Override
    public boolean inScope(IToc toc) {
        int scope = 0;
        while (scope < this.scopes.length) {
            if (!this.scopes[scope].inScope(toc)) {
                return false;
            }
            ++scope;
        }
        return true;
    }

    @Override
    public boolean inScope(ITopic topic) {
        int scope = 0;
        while (scope < this.scopes.length) {
            if (!this.scopes[scope].inScope(topic)) {
                return false;
            }
            ++scope;
        }
        return true;
    }

    @Override
    public boolean inScope(IIndexEntry entry) {
        int scope = 0;
        while (scope < this.scopes.length) {
            if (!this.scopes[scope].inScope(entry)) {
                return false;
            }
            ++scope;
        }
        return true;
    }

    @Override
    public boolean inScope(IIndexSee see) {
        int scope = 0;
        while (scope < this.scopes.length) {
            if (!this.scopes[scope].inScope(see)) {
                return false;
            }
            ++scope;
        }
        return true;
    }

    @Override
    public String getName(Locale locale) {
        return null;
    }

    @Override
    public boolean isHierarchicalScope() {
        int scope = 0;
        while (scope < this.scopes.length) {
            if (!this.scopes[scope].isHierarchicalScope()) {
                return false;
            }
            ++scope;
        }
        return true;
    }

    public String toString() {
        Object str = "(";
        int s = 0;
        while (s < this.scopes.length) {
            str = (String)str + String.valueOf(this.scopes[s]);
            if (s < this.scopes.length - 1) {
                str = (String)str + " ^ ";
            }
            ++s;
        }
        return (String)str + ")";
    }
}

