/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.core.BinaryLambdaExpression;
import org.eclipse.jdt.internal.core.BinaryLambdaMethod;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.LambdaExpression;
import org.eclipse.jdt.internal.core.LambdaMethod;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.SourceMethodInfo;
import org.eclipse.jdt.internal.core.util.DeduplicationUtil;

public class LambdaFactory {
    public static LambdaExpression createLambdaExpression(JavaElement parent, org.eclipse.jdt.internal.compiler.ast.LambdaExpression lambdaExpression) {
        if (LambdaFactory.isBinaryMember(parent)) {
            return new BinaryLambdaExpression(parent, lambdaExpression);
        }
        return new LambdaExpression(parent, lambdaExpression);
    }

    public static LambdaExpression createLambdaExpression(JavaElement parent, String interphase, int sourceStart, int sourceEnd, int arrowPosition) {
        if (LambdaFactory.isBinaryMember(parent)) {
            return new BinaryLambdaExpression(parent, interphase, sourceStart, sourceEnd, arrowPosition);
        }
        return new LambdaExpression(parent, interphase, sourceStart, sourceEnd, arrowPosition);
    }

    public static LambdaMethod createLambdaMethod(JavaElement parent, org.eclipse.jdt.internal.compiler.ast.LambdaExpression lambdaExpression) {
        int length = lambdaExpression.descriptor.parameters.length;
        String[] parameterTypes = new String[length];
        int i = 0;
        while (i < length) {
            parameterTypes[i] = LambdaFactory.getTypeSignature(lambdaExpression.descriptor.parameters[i]);
            ++i;
        }
        String[] parameterNames = new String[length];
        int i2 = 0;
        while (i2 < length) {
            parameterNames[i2] = DeduplicationUtil.toString(lambdaExpression.arguments[i2].name);
            ++i2;
        }
        String returnType = LambdaFactory.getTypeSignature(lambdaExpression.descriptor.returnType);
        String selector = DeduplicationUtil.toString(lambdaExpression.descriptor.selector);
        String key = DeduplicationUtil.toString(lambdaExpression.descriptor.computeUniqueKey());
        LambdaMethod lambdaMethod = LambdaFactory.createLambdaMethod(parent, selector, key, lambdaExpression.sourceStart, lambdaExpression.sourceEnd, lambdaExpression.arrowPosition, parameterTypes, parameterNames, returnType);
        length = lambdaExpression.arguments.length;
        ILocalVariable[] parameters = new ILocalVariable[length];
        int i3 = 0;
        while (i3 < length) {
            Argument argument = lambdaExpression.arguments[i3];
            String signature = DeduplicationUtil.toString(lambdaExpression.descriptor.parameters[i3].signature());
            parameters[i3] = new LocalVariable(lambdaMethod, DeduplicationUtil.toString(argument.name), argument.declarationSourceStart, argument.declarationSourceEnd, argument.sourceStart, argument.sourceEnd, signature, null, argument.modifiers, true);
            ++i3;
        }
        lambdaMethod.elementInfo.arguments = parameters;
        return lambdaMethod;
    }

    public static LambdaMethod createLambdaMethod(JavaElement parent, String selector, String key, int sourceStart, int sourceEnd, int arrowPosition, String[] parameterTypes, String[] parameterNames, String returnType) {
        SourceMethodInfo info = null;
        boolean isBinary = parent instanceof BinaryLambdaExpression;
        info = new SourceMethodInfo();
        info.setSourceRangeStart(sourceStart);
        info.setSourceRangeEnd(sourceEnd);
        info.setFlags(0);
        info.setNameSourceStart(sourceStart);
        info.setNameSourceEnd(arrowPosition);
        int length = parameterNames.length;
        char[][] argumentNames = new char[length][];
        int i = 0;
        while (i < length) {
            argumentNames[i] = DeduplicationUtil.intern(parameterNames[i].toCharArray());
            ++i;
        }
        info.setArgumentNames(argumentNames);
        info.setReturnType(DeduplicationUtil.intern(Signature.toCharArray(returnType.toCharArray())));
        info.setExceptionTypeNames(CharOperation.NO_CHAR_CHAR);
        info.arguments = null;
        return isBinary ? new BinaryLambdaMethod(parent, selector, key, sourceStart, parameterTypes, parameterNames, returnType, info) : new LambdaMethod(parent, selector, key, sourceStart, parameterTypes, parameterNames, returnType, info);
    }

    private static String getTypeSignature(TypeBinding type) {
        char[] signature = type.genericTypeSignature();
        signature = CharOperation.replaceOnCopy((char[])signature, (char)'/', (char)'.');
        return DeduplicationUtil.toString(signature);
    }

    private static boolean isBinaryMember(JavaElement element) {
        return element instanceof BinaryMember;
    }
}

