/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model;

import com.google.common.base.Objects;
import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostProcess;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.CustomStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;

public abstract class HostProcessValue<@NonNull T extends Comparable<T>>
extends CustomStateValue {
    private static Comparator<HostProcessValue<?>> COMPARATOR = Comparator.comparing(h -> h.getHostProcess()).thenComparing(h -> h.getValue());
    private static final @NonNull String STRING_ID_SEP = "|";
    private final @NonNull HostProcess fHostProcess;
    private final T fValue;
    private final int fSerializedValueSize;

    public HostProcessValue(@NonNull HostProcess hostProcess, T value) {
        this.fHostProcess = hostProcess;
        this.fValue = value;
        this.fSerializedValueSize = this.fHostProcess.getSerializedValueSize();
    }

    public @NonNull HostProcess getHostProcess() {
        return this.fHostProcess;
    }

    public @NonNull Long getPid() {
        return this.fHostProcess.getPid();
    }

    protected T getValue() {
        return this.fValue;
    }

    protected abstract @NonNull String valueToString();

    public int compareTo(@NonNull ITmfStateValue o) {
        return COMPARATOR.compare(this, (HostProcessValue)o);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fHostProcess, this.fValue});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        HostProcessValue o = (HostProcessValue)((Object)obj);
        return o.fHostProcess.equals(this.fHostProcess) && o.fValue.equals(this.fValue);
    }

    public @NonNull String getStringId() {
        return String.format("%s%s%s", this.valueToString(), STRING_ID_SEP, this.getHostProcess().getStringId());
    }

    public @NonNull String toString() {
        return String.format("%s, pid=%d, hostId=[%s]", this.valueToString(), this.getPid(), this.getHostProcess().getHostId().toString());
    }

    public void serializeValue(@NonNull ISafeByteBufferWriter buffer) {
        this.fHostProcess.serializeValue(buffer);
    }

    public int getSerializedValueSize() {
        return this.fSerializedValueSize;
    }
}

