/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.connections.IRosConnectionsModel;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.connections.RosConnection;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport.RosMessageTransport;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport.RosMessagesTransportEventKey;
import org.eclipse.tracecompass.tmf.core.event.matching.IEventMatchingKey;
import org.eclipse.tracecompass.tmf.core.event.matching.IMatchProcessingUnit;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventDependency;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class RosMessagesTransportEventMatchingProcessing
implements IMatchProcessingUnit {
    private final @NonNull IRosConnectionsModel fConnectionsModel;
    private int fCount = 0;
    private final Collection<RosMessageTransport> fMatches = new ArrayList<RosMessageTransport>();

    public RosMessagesTransportEventMatchingProcessing(@NonNull IRosConnectionsModel connectionsModel) {
        this.fConnectionsModel = connectionsModel;
    }

    public Collection<RosMessageTransport> getMatches() {
        return this.fMatches;
    }

    public void init(@NonNull Collection<@NonNull ITmfTrace> fTraces) {
    }

    public void addMatch(@NonNull TmfEventDependency match) {
        Activator.getInstance().logError("Event key is needed to process a match!");
    }

    public void addMatch(@NonNull IEventMatchingKey eventKey, @NonNull TmfEventDependency match) {
        if (!(eventKey instanceof RosMessagesTransportEventKey)) {
            return;
        }
        RosMessagesTransportEventKey key = (RosMessagesTransportEventKey)eventKey;
        if (!RosMessagesTransportEventMatchingProcessing.isValidMessageMatch(key)) {
            return;
        }
        @Nullable RosConnection rosConnection = this.getRosConnection(key);
        if (rosConnection == null) {
            return;
        }
        this.fMatches.add(new RosMessageTransport(rosConnection, match.getSource().getTimestamp().toNanos(), match.getDestination().getTimestamp().toNanos(), key));
        ++this.fCount;
    }

    private static boolean isValidMessageMatch(@NonNull RosMessagesTransportEventKey key) {
        return (key.getFlags() & 2L) == 0L && (key.getFlags() & 1L) == 0L;
    }

    public void matchingEnded() {
    }

    public int countMatches() {
        return this.fCount;
    }

    private @Nullable RosConnection getRosConnection(RosMessagesTransportEventKey key) {
        return this.fConnectionsModel.getConnectionBetweenEndpoints(key.getNetworkConnectionInfo().getSourceEndpoint(), key.getNetworkConnectionInfo().getDestinationEndpoint());
    }
}

