/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.iterator;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.event.BinaryFTraceEvent;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.event.BinaryFTraceEventDefinition;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceCPUDataPage;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceEventFormat;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceHeaderInfo;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.iterator.BinaryFTraceIteratorHelper;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.iterator.BinaryFTraceResponse;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.parser.BinaryFTraceByteBuffer;

public class BinaryFTraceCPUPageIterator
implements Closeable {
    private @Nullable BinaryFTraceByteBuffer fBuffer;
    private final BinaryFTraceHeaderInfo fFileHeader;
    private final long fLimit;
    private final BinaryFTraceCPUDataPage fPage;
    private long fCurrentOffset;
    private long fCurrentTimeStamp;
    private int fCurrentTypeLen;
    private long fCurrentTimeDelta;
    private @Nullable BinaryFTraceEventDefinition fEventDef;
    private @NonNull BinaryFTraceIteratorHelper fDataParser;

    public BinaryFTraceCPUPageIterator(@NonNull BinaryFTraceCPUDataPage page, @NonNull BinaryFTraceHeaderInfo fileHeader) {
        this.fFileHeader = fileHeader;
        this.fPage = page;
        this.fLimit = page.getPageStartingOffset() + (long)page.getSize();
        this.fDataParser = new BinaryFTraceIteratorHelper(fileHeader);
        this.initializeIterator();
    }

    public long getCurrentTimeStamp() {
        return this.fCurrentTimeStamp;
    }

    @Override
    public void close() throws IOException {
        this.fBuffer = null;
    }

    public BinaryFTraceResponse readNextEvent() {
        try {
            this.fEventDef = null;
            this.readNextEventTimeStamp();
            if (this.fEventDef != null) {
                return BinaryFTraceResponse.OK;
            }
        }
        catch (Exception ex) {
            Activator.getInstance().logError("There is an error reading the next binary FTrace event.");
            return BinaryFTraceResponse.ERROR;
        }
        return BinaryFTraceResponse.FINISH;
    }

    private void readNextEventTimeStamp() {
        boolean readSuccess = this.readNextEventHeader();
        while (readSuccess && (this.fCurrentTypeLen == this.fFileHeader.getHeaderEventInfo().getTimeStampTypeLen() || this.fCurrentTypeLen == this.fFileHeader.getHeaderEventInfo().getTimeExtendedTypeLen())) {
            this.updateTimeStamp();
            readSuccess = this.readNextEventHeader();
        }
        if (readSuccess) {
            int payloadSize = this.getCurrentEventPayloadSize();
            this.fEventDef = new BinaryFTraceEventDefinition(this.fCurrentOffset, payloadSize);
            this.skip(payloadSize);
            int nextEventType = this.peekNextEventType();
            if (nextEventType == this.fFileHeader.getHeaderEventInfo().getTimeExtendedTypeLen()) {
                this.readNextEventHeader();
            }
            this.updateTimeStamp();
        }
    }

    private boolean readNextEventHeader() {
        if (!this.hasNext()) {
            return false;
        }
        BinaryFTraceByteBuffer buffer = this.fBuffer;
        if (buffer != null) {
            buffer.movePointerToOffset(this.fCurrentOffset);
            int eventTypeLengthAndTimeStamp = buffer.getNextInt();
            this.fCurrentTypeLen = this.fDataParser.getEventTypeLength(eventTypeLengthAndTimeStamp);
            this.fCurrentTimeDelta = this.fDataParser.getDeltaTime(eventTypeLengthAndTimeStamp);
            this.fCurrentOffset += 4L;
            return true;
        }
        return false;
    }

    private int peekNextEventType() {
        if (!this.hasNext()) {
            return -1;
        }
        BinaryFTraceByteBuffer buffer = this.fBuffer;
        if (buffer != null) {
            buffer.movePointerToOffset(this.fCurrentOffset);
            int nextEventTypeLen = buffer.getNextInt();
            return this.fDataParser.getEventTypeLength(nextEventTypeLen);
        }
        return -1;
    }

    private void updateTimeStamp() {
        if (this.fCurrentTypeLen <= this.fFileHeader.getHeaderEventInfo().getDataMaxTypeLen()) {
            this.fCurrentTimeStamp += this.fCurrentTimeDelta;
        } else {
            BinaryFTraceByteBuffer buffer = this.fBuffer;
            if (buffer != null) {
                long extend = buffer.getNextInt();
                extend <<= 27;
                extend += this.fCurrentTimeDelta;
                if (this.fCurrentTypeLen == this.fFileHeader.getHeaderEventInfo().getTimeExtendedTypeLen()) {
                    this.fCurrentTimeStamp += extend;
                } else if (this.fCurrentTypeLen == this.fFileHeader.getHeaderEventInfo().getTimeStampTypeLen()) {
                    this.fCurrentTimeStamp = extend;
                }
                this.fCurrentOffset += 4L;
            }
        }
    }

    private void skip(int bytesToSkip) {
        this.fCurrentOffset += (long)bytesToSkip;
    }

    private int getCurrentEventPayloadSize() {
        int payloadSize = 0;
        if (this.fCurrentTypeLen == this.fFileHeader.getHeaderEventInfo().getCustomLengthEventTypeLen()) {
            BinaryFTraceByteBuffer buffer = this.fBuffer;
            if (buffer != null) {
                payloadSize = buffer.getNextInt() - 4;
                this.fCurrentOffset += 4L;
            }
        } else if (this.fCurrentTypeLen <= this.fFileHeader.getHeaderEventInfo().getDataMaxTypeLen()) {
            payloadSize = this.fCurrentTypeLen * 4;
        }
        return payloadSize;
    }

    public BinaryFTraceCPUDataPage getPage() {
        return this.fPage;
    }

    public @Nullable BinaryFTraceEvent getCurrentEvent() {
        BinaryFTraceEventDefinition eventDef = this.fEventDef;
        if (eventDef != null) {
            BinaryFTraceByteBuffer tempBuffer = this.fFileHeader.getMappedBuffer();
            tempBuffer.movePointerToOffset(eventDef.getPayloadOffset());
            byte[] data = tempBuffer.getNextBytes(eventDef.getPayloadSize());
            BinaryFTraceEventFormat eventFormat = this.fDataParser.getEventFormat(data);
            if (eventFormat == null) {
                return null;
            }
            Map<Object, Object> properties = eventDef.getPayloadSize() > 0 ? this.fDataParser.parseEventData(eventFormat, data) : new HashMap();
            BinaryFTraceEvent event = new BinaryFTraceEvent(this.fCurrentTimeStamp, properties, eventFormat.getEventName(), this.fPage.getCpu());
            return event;
        }
        return null;
    }

    public boolean seek(long timeStampToSeekTo) {
        this.initializeIterator();
        BinaryFTraceResponse response = this.readNextEvent();
        while (response == BinaryFTraceResponse.OK && timeStampToSeekTo > this.fCurrentTimeStamp && this.hasNext()) {
            response = this.readNextEvent();
        }
        if (timeStampToSeekTo > this.fCurrentTimeStamp) {
            this.fEventDef = null;
            return false;
        }
        return true;
    }

    public boolean hasNext() {
        boolean ret = true;
        BinaryFTraceByteBuffer buffer = this.fBuffer;
        if (buffer == null) {
            ret = false;
        } else {
            if (this.fCurrentOffset + 4L >= this.fLimit) {
                ret = false;
            } else {
                int typeLengthAndTimeStamp = buffer.getNextInt();
                if (typeLengthAndTimeStamp == 0) {
                    if (this.fCurrentOffset + 8L >= this.fLimit) {
                        ret = false;
                    } else {
                        int customLength = buffer.getNextInt();
                        if (customLength == 0) {
                            ret = false;
                        }
                    }
                }
            }
            buffer.movePointerToOffset(this.fCurrentOffset);
        }
        return ret;
    }

    private void initializeIterator() {
        this.fCurrentOffset = this.fPage.getDataStartingOffset();
        this.fCurrentTimeStamp = this.fPage.getTimeStamp();
        this.fCurrentTypeLen = -1;
        this.fCurrentTimeDelta = -1L;
        this.fEventDef = null;
        if (this.fBuffer != null) {
            this.fBuffer.movePointerToOffset(this.fPage.getDataStartingOffset());
        } else {
            BinaryFTraceByteBuffer newBuffer = this.fFileHeader.getMappedBuffer();
            newBuffer.movePointerToOffset(this.fPage.getDataStartingOffset());
            this.fBuffer = newBuffer;
        }
    }
}

