/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteProcessService;
import org.eclipse.remote.core.RemoteServicesUtils;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.ILoadDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.TraceControlDialogFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.BaseControlViewHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionGroup;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.ILttngControlService;
import org.eclipse.ui.IWorkbenchPage;

public class LoadHandler
extends BaseControlViewHandler {
    private TraceSessionGroup fSessionGroup = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IRemoteConnection connection;
        TraceSessionGroup sessionGroup;
        this.fLock.lock();
        try {
            sessionGroup = this.fSessionGroup;
            if (sessionGroup == null) {
                return null;
            }
            connection = sessionGroup.getTargetNode().getRemoteSystemProxy().getRemoteConnection();
        }
        finally {
            this.fLock.unlock();
        }
        final ILoadDialog dialog = TraceControlDialogFactory.getInstance().getLoadDialog();
        dialog.initialize(connection);
        if (dialog.open() != 0) {
            return null;
        }
        Job job = new Job(Messages.TraceControl_LoadJob){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ArrayList<IFileStore> remoteResources;
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
                    IRemoteProcessService processService = (IRemoteProcessService)connection.getService(IRemoteProcessService.class);
                    IPath path = null;
                    if (processService != null) {
                        String cwd = processService.getWorkingDirectory();
                        path = RemoteServicesUtils.posixPath((String)cwd);
                        path = path.append(".lttng/sessions");
                    }
                    if (path == null) {
                        return Status.CANCEL_STATUS;
                    }
                    ILttngControlService service = sessionGroup.getControlService();
                    ArrayList<String> commands = new ArrayList<String>();
                    commands.add("mkdir -p " + path.toString());
                    service.runCommands((IProgressMonitor)subMonitor.newChild(1), commands);
                    IRemoteFileService fileService = (IRemoteFileService)connection.getService(IRemoteFileService.class);
                    if (fileService == null) {
                        return Status.CANCEL_STATUS;
                    }
                    List<IFileStore> localFiles = dialog.getLocalResources();
                    if (localFiles != null) {
                        remoteResources = new ArrayList();
                        SubMonitor childMonitor = subMonitor.newChild(1);
                        for (IFileStore local : localFiles) {
                            IPath remotePath = RemoteServicesUtils.posixPath((String)path.toString()).append(local.getName());
                            IFileStore remoteResource = fileService.getResource(remotePath.toString());
                            local.copy(remoteResource, 2, (IProgressMonitor)childMonitor);
                            remoteResources.add(remoteResource);
                        }
                    } else {
                        subMonitor.newChild(1);
                        remoteResources = dialog.getRemoteResources();
                    }
                    LoadHandler.loadRemoteProfile(sessionGroup, (IProgressMonitor)subMonitor.newChild(1), remoteResources, dialog.isForce());
                }
                catch (ExecutionException | CoreException e) {
                    return new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", Messages.TraceControl_LoadFailure, e);
                }
                catch (InterruptedException e) {
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        TraceSessionGroup sessionGroup = null;
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            Object element = ((StructuredSelection)selection).getFirstElement();
            sessionGroup = element instanceof TraceSessionGroup ? (TraceSessionGroup)element : null;
        }
        boolean isEnabled = sessionGroup != null;
        this.fLock.lock();
        try {
            this.fSessionGroup = null;
            if (isEnabled) {
                this.fSessionGroup = sessionGroup;
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }

    private static void loadRemoteProfile(TraceSessionGroup sessionGroup, IProgressMonitor monitor, List<IFileStore> files, boolean isForce) throws ExecutionException, InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)files.size());
        for (IFileStore file : files) {
            if (subMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            subMonitor.beginTask(NLS.bind((String)Messages.TraceControl_LoadTask, (Object)file.getName()), 1);
            sessionGroup.loadSession(file.toURI().getPath(), isForce, (IProgressMonitor)subMonitor);
            subMonitor.done();
        }
    }
}

