/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.kernel.core.io;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.incubator.internal.kernel.core.io.IoAnalysis;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.IODataPalette;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.AbstractStateSystemAnalysisDataProvider;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class IoAccessDataProvider
extends AbstractStateSystemAnalysisDataProvider
implements ITimeGraphDataProvider<TimeGraphEntryModel>,
IOutputStyleProvider {
    public static final String ID = "org.eclipse.tracecompass.incubator.kernel.core.io.access.dataprovider";
    public static final String SELECTED_TID_PARAM = "selected";
    public static final String CHECKED_TID_PARAM = "checked";
    private static final Logger LOGGER = TraceCompassLog.getLogger(IoAccessDataProvider.class);
    private static final String READ_STYLE = "Read";
    private static final String WRITE_STYLE = "Write";
    private static final Map<String, OutputElementStyle> STATE_MAP;
    private static final Map<String, OutputElementStyle> STYLE_MAP;
    private IoAnalysis fAnalysisModule;
    private final BiMap<Long, Pair<Integer, String>> fIdToFile = HashBiMap.create();
    private final AtomicLong fIdGenerator = new AtomicLong();
    private final BiMap<Long, Integer> fIdToTid = HashBiMap.create();

    static {
        STYLE_MAP = new HashMap<String, OutputElementStyle>();
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        List COLOR_LIST = IODataPalette.getColors();
        Pair colorPair = (Pair)COLOR_LIST.get(0);
        builder.put((Object)READ_STYLE, (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)READ_STYLE, (Object)"background-color", (Object)colorPair.getFirst())));
        builder.put((Object)WRITE_STYLE, (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)WRITE_STYLE, (Object)"background-color", (Object)colorPair.getSecond())));
        STATE_MAP = builder.build();
        STYLE_MAP.put(READ_STYLE, new OutputElementStyle(READ_STYLE));
        STYLE_MAP.put(WRITE_STYLE, new OutputElementStyle(WRITE_STYLE));
    }

    public IoAccessDataProvider(ITmfTrace trace, IoAnalysis analysisModule) {
        super(trace);
        this.fAnalysisModule = analysisModule;
    }

    public TmfModelResponse<List<ITimeGraphArrow>> fetchArrows(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public TmfModelResponse<TimeGraphModel> fetchRowModel(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        boolean complete;
        this.fAnalysisModule.waitForInitialization();
        ITmfStateSystem ss = this.fAnalysisModule.getStateSystem();
        if (ss == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.STATE_SYSTEM_FAILED);
        }
        long currentEnd = ss.getCurrentEndTime();
        List times = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
        List selectedItems = DataProviderParameterUtils.extractSelectedItems(fetchParameters);
        Object end = Iterables.getLast((Iterable)times);
        if (!(end instanceof Number)) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        boolean bl = complete = ss.waitUntilBuilt(0L) || ((Number)end).longValue() <= currentEnd;
        if (monitor != null && monitor.isCanceled()) {
            return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
        }
        try {
            Throwable throwable = null;
            Object var11_12 = null;
            try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "AbstractTimeGraphDataProvider#fetchRowModel", new Object[0]).setCategory(((Object)((Object)this)).getClass().getSimpleName()).build();){
                TimeGraphModel models = this.getRowModel(ss, fetchParameters, monitor, selectedItems);
                if (models == null) {
                    if (monitor != null && monitor.isCanceled()) {
                        return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                    }
                    return new TmfModelResponse(null, ITmfResponse.Status.FAILED, "Request failed");
                }
                return new TmfModelResponse((Object)models, complete ? ITmfResponse.Status.COMPLETED : ITmfResponse.Status.RUNNING, complete ? CommonStatusMessage.COMPLETED : CommonStatusMessage.RUNNING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException e) {
            e.printStackTrace();
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, String.valueOf(e.getMessage()));
        }
    }

    private @Nullable TimeGraphModel getRowModel(ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor, List<Long> selectedItems) throws StateSystemDisposedException {
        List times = DataProviderParameterUtils.extractTimeRequested(parameters);
        if (times == null || times.isEmpty()) {
            return new TimeGraphModel(Collections.emptyList());
        }
        HashMap<Integer, Long> quarkToId = new HashMap<Integer, Long>();
        for (Long selectedItem : selectedItems) {
            int quark;
            Pair filename = (Pair)this.fIdToFile.get((Object)selectedItem);
            if (filename == null || (quark = ss.optQuarkAbsolute(new String[]{"RES", (String)filename.getSecond(), String.valueOf(filename.getFirst()), "OPERATION"})) == -2) continue;
            quarkToId.put(quark, selectedItem);
        }
        if (quarkToId.isEmpty()) {
            return new TimeGraphModel(Collections.emptyList());
        }
        TreeMultimap intervals = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
        for (ITmfStateInterval interval : ss.query2D(quarkToId.keySet(), (Collection)times)) {
            intervals.put((Object)Objects.requireNonNull((Long)quarkToId.get(interval.getAttribute())), (Object)interval);
        }
        if (monitor != null && monitor.isCanceled()) {
            return new TimeGraphModel(Collections.emptyList());
        }
        ArrayList<TimeGraphRowModel> rows = new ArrayList<TimeGraphRowModel>();
        for (Map.Entry entryIntervals : intervals.asMap().entrySet()) {
            if (monitor != null && monitor.isCanceled()) {
                return new TimeGraphModel(Collections.emptyList());
            }
            ArrayList<TimeGraphState> states = new ArrayList<TimeGraphState>();
            for (ITmfStateInterval interval : (Collection)entryIntervals.getValue()) {
                long startTime = interval.getStartTime();
                long duration = interval.getEndTime() - startTime + 1L;
                states.add(new TimeGraphState(startTime, duration, null, IoAccessDataProvider.getStyleFor(interval)));
            }
            rows.add(new TimeGraphRowModel(((Long)entryIntervals.getKey()).longValue(), states));
        }
        return new TimeGraphModel(rows);
    }

    private static @Nullable OutputElementStyle getStyleFor(ITmfStateInterval interval) {
        Object value = interval.getValue();
        if (!(value instanceof String)) {
            return null;
        }
        String operation = (String)value;
        if (operation.equals("READ")) {
            return STYLE_MAP.get(READ_STYLE);
        }
        return STYLE_MAP.get(WRITE_STYLE);
    }

    public TmfModelResponse<Map<String, String>> fetchTooltip(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(Collections.emptyMap(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public TmfModelResponse<TmfTreeModel<TimeGraphEntryModel>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        this.fAnalysisModule.waitForInitialization();
        ITmfStateSystem ss = this.fAnalysisModule.getStateSystem();
        if (ss == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.STATE_SYSTEM_FAILED);
        }
        boolean complete = ss.waitUntilBuilt(0L);
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "AbstractTreeDataProvider#fetchTree", new Object[0]).setCategory(((Object)((Object)this)).getClass().getSimpleName()).build();){
                TmfTreeModel<TimeGraphEntryModel> tree = this.getTree(ss, fetchParameters, monitor);
                if (monitor != null && monitor.isCanceled()) {
                    return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                }
                return new TmfModelResponse(tree, complete ? ITmfResponse.Status.COMPLETED : ITmfResponse.Status.RUNNING, complete ? CommonStatusMessage.RUNNING : CommonStatusMessage.COMPLETED);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.STATE_SYSTEM_FAILED);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private TmfTreeModel<TimeGraphEntryModel> getTree(ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        Integer tid;
        HashMap<Integer, TidFiles> fds;
        HashMultimap currentOperations = HashMultimap.create();
        boolean gotData = IoAccessDataProvider.fillQueryIntervals(ss, parameters, monitor, (Multimap<Integer, ITmfStateInterval>)currentOperations, fds = new HashMap<Integer, TidFiles>());
        if (!gotData || monitor != null && monitor.isCanceled()) {
            return new TmfTreeModel(Collections.emptyList(), Collections.emptyList());
        }
        HashMultimap files = HashMultimap.create();
        for (Map.Entry entry : currentOperations.entries()) {
            String filename;
            ITmfStateInterval rwInterval = (ITmfStateInterval)entry.getValue();
            tid = (Integer)entry.getKey();
            Object fdObj = rwInterval.getValue();
            TidFiles tidFiles = (TidFiles)fds.get(tid);
            if (!(fdObj instanceof Long) || tidFiles == null || (filename = tidFiles.getFilename(rwInterval, String.valueOf(fdObj))) == null) continue;
            files.put((Object)((Integer)entry.getKey()), (Object)filename);
        }
        // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Map.Entry fileEntry : files.asMap().entrySet()) {
            tid = (Integer)fileEntry.getKey();
            long tidId = this.getTidId(tid);
            builder.add((Object)new TimeGraphEntryModel(tidId, -1L, String.valueOf(tid), ss.getStartTime(), ss.getCurrentEndTime()));
            for (String file : (Collection)fileEntry.getValue()) {
                long id = this.getId((Pair<Integer, String>)new Pair((Object)tid, (Object)file));
                builder.add((Object)new TimeGraphEntryModel(id, tidId, file, ss.getStartTime(), ss.getCurrentEndTime()));
            }
        }
        return new TmfTreeModel(Collections.emptyList(), (List)builder.build());
    }

    private static Collection<Integer> extractIntegerList(Map<String, Object> parameters, String selectedTidParam) {
        Collection collection;
        Object collectionObject = parameters.get(selectedTidParam);
        if (collectionObject instanceof Collection && (collection = (Collection)collectionObject).stream().allMatch(e -> e instanceof Integer)) {
            return collection;
        }
        return Collections.emptyList();
    }

    private static boolean fillQueryIntervals(ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor, Multimap<Integer, ITmfStateInterval> currentOperations, Map<Integer, TidFiles> fds) throws IndexOutOfBoundsException, TimeRangeException, StateSystemDisposedException {
        Collection<Integer> selectedTid = IoAccessDataProvider.extractIntegerList(parameters, SELECTED_TID_PARAM);
        if (selectedTid.isEmpty()) {
            return false;
        }
        List times = DataProviderParameterUtils.extractTimeRequested(parameters);
        if (times == null || times.isEmpty()) {
            return false;
        }
        long start = Long.MAX_VALUE;
        long end = 0L;
        for (Long time : times) {
            start = Math.min(start, time);
            end = Math.max(start, time);
        }
        start = Math.max(start, ss.getStartTime());
        end = Math.min(end, ss.getCurrentEndTime());
        HashSet<Integer> toQuery = new HashSet<Integer>();
        HashMap<Integer, Integer> operationQuarks = new HashMap<Integer, Integer>();
        HashMap<Integer, TidFiles> tblQuarks = new HashMap<Integer, TidFiles>();
        for (Integer tid : selectedTid) {
            ITmfStateInterval fdLink;
            int fdTblQuark = ss.optQuarkAbsolute(new String[]{"TID", String.valueOf(tid), "FDTBL"});
            if (fdTblQuark == -2 || (fdLink = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)fdTblQuark, (long)start, (long)end)) == null || (fdTblQuark = ss.optQuarkAbsolute(new String[]{"FDTBL", String.valueOf(fdLink.getValue())})) == -2) continue;
            List fdQuarks = ss.getSubAttributes(fdTblQuark, false);
            toQuery.addAll(ss.getSubAttributes(fdTblQuark, false));
            int readFd = ss.optQuarkAbsolute(new String[]{"TID", String.valueOf(tid), "READ", "FD"});
            IoAccessDataProvider.addIfExist(toQuery, operationQuarks, readFd, tid);
            int writeFd = ss.optQuarkAbsolute(new String[]{"TID", String.valueOf(tid), "WRITE", "FD"});
            IoAccessDataProvider.addIfExist(toQuery, operationQuarks, writeFd, tid);
            TidFiles tidFiles = (TidFiles)tblQuarks.get(fdTblQuark);
            if (tidFiles == null) {
                tidFiles = new TidFiles();
                tblQuarks.put(fdTblQuark, tidFiles);
                for (Integer quark : fdQuarks) {
                    tblQuarks.put(quark, tidFiles);
                }
            }
            fds.put(tid, tidFiles);
        }
        if (toQuery.isEmpty()) {
            return false;
        }
        for (ITmfStateInterval interval : ss.query2D(toQuery, start, end)) {
            if (monitor != null && monitor.isCanceled()) {
                return false;
            }
            if (interval.getValue() == null) continue;
            if (operationQuarks.containsKey(interval.getAttribute())) {
                currentOperations.put((Object)Objects.requireNonNull((Integer)operationQuarks.get(interval.getAttribute())), (Object)interval);
                continue;
            }
            TidFiles tidFiles = Objects.requireNonNull((TidFiles)tblQuarks.get(interval.getAttribute()));
            tidFiles.addInterval(ss, interval);
        }
        return true;
    }

    private static void addIfExist(Set<Integer> toQuery, Map<Integer, Integer> operationQuarks, int quark, Integer tid) {
        if (quark != -2) {
            toQuery.add(quark);
            operationQuarks.put(quark, tid);
        }
    }

    private long getId(Pair<Integer, String> file) {
        return (Long)this.fIdToFile.inverse().computeIfAbsent(file, q -> this.getEntryId());
    }

    private long getTidId(Integer tid) {
        return (Long)this.fIdToTid.inverse().computeIfAbsent((Object)tid, q -> this.getEntryId());
    }

    protected long getEntryId() {
        return this.fIdGenerator.getAndIncrement();
    }

    public TmfModelResponse<OutputStyleModel> fetchStyle(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse((Object)new OutputStyleModel(STATE_MAP), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public String getId() {
        return ID;
    }

    private static class TidFiles {
        Multimap<String, ITmfStateInterval> fIntervals = HashMultimap.create();

        public @Nullable String getFilename(ITmfStateInterval rwInterval, String fdStr) {
            Collection intervals = this.fIntervals.get((Object)fdStr);
            for (ITmfStateInterval interval : intervals) {
                if (interval.getStartTime() > rwInterval.getEndTime() || interval.getEndTime() < rwInterval.getStartTime()) continue;
                Object value = interval.getValue();
                return value instanceof String ? (String)value : null;
            }
            return null;
        }

        public void addInterval(ITmfStateSystem ss, ITmfStateInterval interval) {
            this.fIntervals.put((Object)ss.getAttributeName(interval.getAttribute()), (Object)interval);
        }
    }
}

