/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.scripting.ui.trace;

import java.io.FileNotFoundException;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.incubator.internal.scripting.core.trace.Messages;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;

public class TraceScriptingUI {
    @WrapToScript
    public ITmfTrace openTrace(String projectName, String traceName, @ScriptParameter(defaultValue="false") boolean isExperiment) throws FileNotFoundException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject rootProject = root.getProject(projectName);
        TmfProjectElement rootElement = TmfProjectRegistry.getProject((IProject)Objects.requireNonNull(rootProject));
        if (rootElement == null) {
            throw new FileNotFoundException(Messages.projectDoesNotExist);
        }
        String folderName = isExperiment ? "Experiments" : "Traces";
        ITmfProjectModelElement traceFolder = rootElement.getChild(folderName);
        String[] stringArray = traceName.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            String folderPath = traceFolder.getPath().toOSString();
            if ((traceFolder = traceFolder.getChild(name)) == null) {
                throw new FileNotFoundException("This folder could not be found: " + folderPath + '/' + name);
            }
            ++n2;
        }
        final ITmfProjectModelElement traceChild = traceFolder;
        if (!(traceChild instanceof TmfCommonProjectElement)) {
            throw new FileNotFoundException();
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TmfOpenTraceHelper.openFromElement((TmfCommonProjectElement)((TmfCommonProjectElement)traceChild));
            }
        });
        TmfCommonProjectElement projectElement = (TmfCommonProjectElement)traceChild;
        ITmfTrace trace = projectElement.getTrace();
        Integer tryCounter = 0;
        Integer numberOfTry = 20;
        while (trace == null && tryCounter < numberOfTry) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            trace = projectElement.getTrace();
            tryCounter = tryCounter + 1;
        }
        if (trace != null) {
            return trace;
        }
        throw new FileNotFoundException("The trace did not open correctly");
    }
}

