/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.protocol.unknown;

import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.pcap.core.packet.Packet;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.unknown.UnknownEndpoint;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.internal.pcap.core.util.ConversionHelper;

public class UnknownPacket
extends Packet {
    private final @Nullable Packet fChildPacket;
    private final ByteBuffer fPayload;
    private @Nullable UnknownEndpoint fSourceEndpoint = null;
    private @Nullable UnknownEndpoint fDestinationEndpoint = null;
    private @Nullable Map<String, String> fFields = null;

    public UnknownPacket(PcapFile file, @Nullable Packet parent, ByteBuffer packet) {
        super(file, parent, PcapProtocol.UNKNOWN);
        this.fPayload = packet;
        this.fChildPacket = this.findChildPacket();
    }

    @Override
    public @Nullable Packet getChildPacket() {
        return this.fChildPacket;
    }

    @Override
    public @Nullable ByteBuffer getPayload() {
        return this.fPayload;
    }

    @Override
    protected @Nullable Packet findChildPacket() {
        return null;
    }

    public String toString() {
        byte[] array = Arrays.copyOfRange(this.fPayload.array(), this.fPayload.arrayOffset(), this.fPayload.arrayOffset() + this.fPayload.limit());
        String string = "Payload: " + ConversionHelper.bytesToHex(array, true);
        Packet child = this.fChildPacket;
        if (child != null) {
            return String.valueOf(string) + child.toString();
        }
        return string;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public UnknownEndpoint getSourceEndpoint() {
        @Nullable UnknownEndpoint endpoint = this.fSourceEndpoint;
        if (endpoint == null) {
            endpoint = new UnknownEndpoint(this, true);
        }
        this.fSourceEndpoint = endpoint;
        return this.fSourceEndpoint;
    }

    @Override
    public UnknownEndpoint getDestinationEndpoint() {
        @Nullable UnknownEndpoint endpoint = this.fDestinationEndpoint;
        if (endpoint == null) {
            endpoint = new UnknownEndpoint(this, false);
        }
        this.fDestinationEndpoint = endpoint;
        return this.fDestinationEndpoint;
    }

    @Override
    public Map<String, String> getFields() {
        Map<String, String> map = this.fFields;
        if (map == null) {
            byte[] array = Arrays.copyOfRange(this.fPayload.array(), this.fPayload.arrayOffset(), this.fPayload.arrayOffset() + this.fPayload.limit());
            ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"Binary", (Object)ConversionHelper.bytesToHex(array, true));
            try {
                String s = new String(array, "UTF-8");
                builder.put((Object)"Character", (Object)s);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            this.fFields = builder.build();
            return this.fFields;
        }
        return map;
    }

    @Override
    public String getLocalSummaryString() {
        return "Len: " + this.fPayload.limit() + " bytes";
    }

    @Override
    protected String getSignificationString() {
        return "Data: " + this.fPayload.limit() + " bytes";
    }

    @Override
    public Packet getMostEcapsulatedPacket() {
        Packet packet = this.getParentPacket();
        if (packet == null) {
            return this;
        }
        return packet;
    }

    @Override
    public int hashCode() {
        int result = 31;
        Packet child = this.fChildPacket;
        if (child != null) {
            result += child.hashCode();
        }
        if (child == null) {
            result = 31 * result + UnknownPacket.payloadHashCode(this.fPayload);
        }
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnknownPacket other = (UnknownPacket)obj;
        if (!Objects.equals(this.fChildPacket, other.fChildPacket)) {
            return false;
        }
        return this.fChildPacket != null || UnknownPacket.payloadEquals(this.fPayload, other.fPayload);
    }
}

