/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.FloatDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.ISimpleDatatypeDeclaration;

@NonNullByDefault
public final class FloatDeclaration
extends Declaration
implements ISimpleDatatypeDeclaration {
    private final int fMantissa;
    private final int fExponent;
    private final boolean fIsByteOrderSet;
    private final ByteOrder fByteOrder;
    private final long fAlignement;

    public FloatDeclaration(int exponent, int mantissa, @Nullable ByteOrder byteOrder, long alignment) {
        this.fMantissa = mantissa;
        this.fExponent = exponent;
        this.fIsByteOrderSet = byteOrder != null;
        this.fByteOrder = byteOrder == null ? ByteOrder.nativeOrder() : byteOrder;
        this.fAlignement = Math.max(alignment, 1L);
    }

    public int getMantissa() {
        return this.fMantissa;
    }

    public int getExponent() {
        return this.fExponent;
    }

    @Override
    public boolean isByteOrderSet() {
        return this.fIsByteOrderSet;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.fByteOrder;
    }

    @Override
    public long getAlignment() {
        return this.fAlignement;
    }

    @Override
    public int getMaximumSize() {
        return this.fMantissa + this.fExponent + 1;
    }

    @Override
    public FloatDefinition createDefinition(@Nullable IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFException {
        ByteOrder byteOrder = input.getByteOrder();
        input.setByteOrder(this.fByteOrder);
        double value = this.read(input);
        input.setByteOrder(byteOrder);
        return new FloatDefinition(this, definitionScope, fieldName, value);
    }

    public String toString() {
        return "[declaration] float[" + Integer.toHexString(this.hashCode()) + "]";
    }

    private double read(BitBuffer input) throws CTFException {
        this.alignRead(input);
        int exp = this.getExponent();
        int mant = this.getMantissa();
        double value = Double.NaN;
        if (exp + mant == 32) {
            value = FloatDeclaration.readRawFloat32(input, mant, exp);
        } else if (exp + mant == 64) {
            value = FloatDeclaration.readRawFloat64(input, mant, exp);
        }
        return value;
    }

    private static double readRawFloat32(BitBuffer input, int manBits, int expBits) throws CTFException {
        long temp = input.get(32, false);
        return FloatDeclaration.createFloat(temp, manBits - 1, expBits);
    }

    private static double readRawFloat64(BitBuffer input, int manBits, int expBits) throws CTFException {
        long temp = input.get(64, false);
        return FloatDeclaration.createFloat(temp, manBits - 1, expBits);
    }

    private static double createFloat(long rawValue, int manBits, int expBits) {
        long manShift = 1L << manBits;
        long manMask = manShift - 1L;
        long expMask = (1L << expBits) - 1L;
        boolean isNegative = (rawValue & 1L << manBits + expBits) != 0L;
        int exp = (int)(rawValue >> manBits & expMask) + 1;
        long man = rawValue & manMask;
        int offsetExponent = exp - (1 << expBits - 1);
        double expPow = Math.pow(2.0, offsetExponent);
        double ret = (float)man * 1.0f;
        ret /= (double)manShift;
        ret += 1.0;
        return isNegative ? -ret : (ret *= expPow);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.fAlignement ^ this.fAlignement >>> 32);
        result = 31 * result + this.fByteOrder.toString().hashCode();
        result = 31 * result + this.fExponent;
        result = 31 * result + this.fMantissa;
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatDeclaration other = (FloatDeclaration)obj;
        if (this.fAlignement != other.fAlignement) {
            return false;
        }
        if (!this.fByteOrder.equals(other.fByteOrder)) {
            return false;
        }
        if (this.fExponent != other.fExponent) {
            return false;
        }
        return this.fMantissa == other.fMantissa;
    }

    @Override
    public boolean isBinaryEquivalent(@Nullable IDeclaration obj) {
        return this.equals(obj);
    }
}

