/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.model.TmfProjectModelHelper;
import org.eclipse.ui.PlatformUI;

public class TraceUtils {
    private TraceUtils() {
    }

    public static void displayErrorMsg(String boxTitle, String errorMsg) {
        TraceUtils.displayErrorMsg(boxTitle, errorMsg, null);
    }

    public static void displayErrorMsg(Throwable exception) {
        TraceUtils.displayErrorMsg(exception.getClass().getSimpleName(), exception.getMessage(), exception);
    }

    public static void displayWarningMsg(Throwable exception) {
        String warningMsg = exception.getMessage();
        Display.getDefault().asyncExec(() -> {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Activator.getDefault().logWarning(warningMsg, exception);
            MessageDialog.openWarning((Shell)shell, (String)exception.getClass().getSimpleName(), (String)warningMsg);
        });
    }

    public static void displayErrorMsg(String boxTitle, String errorMsg, Throwable exception) {
        Display.getDefault().asyncExec(() -> {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Activator.getDefault().logError(errorMsg, exception);
            MessageDialog.openError((Shell)shell, (String)boxTitle, (String)errorMsg);
        });
    }

    public static List<IProject> getOpenedTmfProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> tmfProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.isAccessible() && project.getNature("org.eclipse.linuxtools.tmf.project.nature") != null && !TmfProjectModelHelper.isShadowProject(project)) {
                    tmfProjects.add(project);
                }
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error getting opened tmf projects", e);
            }
            ++n2;
        }
        return tmfProjects;
    }

    public static void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            if (folder.getParent() instanceof IFolder) {
                TraceUtils.createFolder((IFolder)folder.getParent(), monitor);
            }
            folder.create(true, true, monitor);
        }
    }
}

