/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.string;

import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class EncodingParser
implements ICommonTreeParser {
    public static final EncodingParser INSTANCE = new EncodingParser();
    private static final String INVALID_VALUE_FOR_ENCODING = "Invalid value for encoding";

    private EncodingParser() {
    }

    public Encoding parse(ICTFMetadataNode tree, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        ICTFMetadataNode firstChild = tree.getChild(0);
        if (TsdlUtils.isUnaryString(firstChild)) {
            String strval = TsdlUtils.concatenateUnaryStrings(tree.getChildren());
            if (strval.equals("UTF8")) {
                return Encoding.UTF8;
            }
            if (strval.equals("ASCII")) {
                return Encoding.ASCII;
            }
            if (strval.equals("none")) {
                return Encoding.NONE;
            }
            throw new ParseException(INVALID_VALUE_FOR_ENCODING);
        }
        throw new ParseException(INVALID_VALUE_FOR_ENCODING);
    }
}

