/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.supports;

import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.languageconfiguration.internal.model.AutoClosingPair;
import org.eclipse.tm4e.languageconfiguration.internal.model.AutoClosingPairConditional;
import org.eclipse.tm4e.languageconfiguration.internal.model.CharacterPair;
import org.eclipse.tm4e.languageconfiguration.internal.model.LanguageConfiguration;

public final class CharacterPairSupport {
    public static final String DEFAULT_AUTOCLOSE_BEFORE_LANGUAGE_DEFINED = ";:.,=}])> \r\n\t";
    public static final String DEFAULT_AUTOCLOSE_BEFORE_WHITESPACE = " \r\n\t";
    public final List<AutoClosingPairConditional> autoClosingPairs;
    public final List<AutoClosingPair> surroundingPairs;
    public final String autoCloseBefore;

    public CharacterPairSupport(LanguageConfiguration config) {
        List<CharacterPair> brackets;
        List<AutoClosingPairConditional> autoClosingPairs = config.getAutoClosingPairs();
        this.autoClosingPairs = !autoClosingPairs.isEmpty() ? autoClosingPairs : (!(brackets = config.getBrackets()).isEmpty() ? brackets.stream().map(el -> new AutoClosingPairConditional(el.open, el.close, Collections.emptyList())).toList() : Collections.emptyList());
        String autoCloseBefore = config.getAutoCloseBefore();
        this.autoCloseBefore = autoCloseBefore != null ? autoCloseBefore : DEFAULT_AUTOCLOSE_BEFORE_LANGUAGE_DEFINED;
        List<AutoClosingPair> surroundingPairs = config.getSurroundingPairs();
        this.surroundingPairs = !surroundingPairs.isEmpty() ? surroundingPairs : this.autoClosingPairs;
    }

    public @Nullable AutoClosingPairConditional getAutoClosingPair(String text, int offset, String newCharacter) {
        if (newCharacter.isEmpty()) {
            return null;
        }
        for (AutoClosingPairConditional autoClosingPair : this.autoClosingPairs) {
            String offsetPrefix;
            String opening = autoClosingPair.open;
            if (!opening.endsWith(newCharacter) || opening.length() > 1 && !(offsetPrefix = text.substring(0, offset)).endsWith(opening.substring(0, opening.length() - 1))) continue;
            return autoClosingPair;
        }
        return null;
    }
}

