/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.files.local.model;

import java.util.ArrayList;
import org.eclipse.rse.internal.services.local.files.LocalHostFile;
import org.eclipse.rse.internal.services.local.files.LocalVirtualHostFile;
import org.eclipse.rse.internal.subsystems.files.local.model.LocalFile;
import org.eclipse.rse.internal.subsystems.files.local.model.LocalVirtualFile;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.AbstractRemoteFile;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IHostFileToRemoteFileAdapter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileContext;

public class LocalFileAdapter
implements IHostFileToRemoteFileAdapter {
    public AbstractRemoteFile[] convertToRemoteFiles(FileServiceSubSystem ss, IRemoteFileContext context, IRemoteFile parent, IHostFile[] nodes) {
        if (nodes == null) {
            return null;
        }
        ArrayList<LocalVirtualFile> results = new ArrayList<LocalVirtualFile>();
        int i = 0;
        while (i < nodes.length) {
            LocalFile lfile;
            LocalVirtualHostFile node;
            IHostFile child = nodes[i];
            if (child instanceof LocalVirtualHostFile) {
                node = (LocalVirtualHostFile)child;
                lfile = new LocalVirtualFile(ss, context, node);
            } else {
                node = (LocalHostFile)child;
                lfile = new LocalFile(ss, context, parent, (LocalHostFile)node);
            }
            results.add((LocalVirtualFile)lfile);
            ss.cacheRemoteFile((IRemoteFile)lfile);
            ++i;
        }
        return results.toArray(new LocalFile[results.size()]);
    }

    public AbstractRemoteFile convertToRemoteFile(FileServiceSubSystem ss, IRemoteFileContext context, IRemoteFile parent, IHostFile node) {
        LocalFile file = null;
        file = node instanceof LocalVirtualHostFile ? new LocalVirtualFile(ss, context, (LocalVirtualHostFile)node) : new LocalFile(ss, context, parent, (LocalHostFile)node);
        ss.cacheRemoteFile((IRemoteFile)file);
        return file;
    }
}

