/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.processes.core.subsystem.impl;

import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterContainer;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.subsystems.SubSystemConfiguration;
import org.eclipse.rse.internal.subsystems.processes.core.subsystem.SystemProcessesCoreResources;
import org.eclipse.rse.services.clientserver.processes.HostProcessFilterImpl;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcessSubSystemConfiguration;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorServerPortInput;

public abstract class RemoteProcessSubSystemConfiguration
extends SubSystemConfiguration
implements IRemoteProcessSubSystemConfiguration {
    public boolean supportsNestedFilters() {
        return false;
    }

    public boolean supportsServerLaunchProperties() {
        return true;
    }

    protected ISystemFilterPool createDefaultFilterPool(ISystemFilterPoolManager mgr) {
        ISystemFilterPool pool = null;
        try {
            pool = mgr.createSystemFilterPool(RemoteProcessSubSystemConfiguration.getDefaultFilterPoolName((String)mgr.getName(), (String)this.getId()), true);
            if (this.isUserPrivateProfile(mgr)) {
                HostProcessFilterImpl allProcessesFilterString = new HostProcessFilterImpl();
                String[] filterStrings = new String[]{allProcessesFilterString.toString()};
                ISystemFilter filter = mgr.createSystemFilter((ISystemFilterContainer)pool, SystemProcessesCoreResources.RESID_PROPERTY_PROCESS_DEFAULTFILTER_LABEL, filterStrings);
                filter.setNonChangable(true);
                filter.setSingleFilterStringOnly(true);
                HostProcessFilterImpl myProcessesFilterString = new HostProcessFilterImpl();
                myProcessesFilterString.setUsername("${user.id}");
                filterStrings = new String[]{myProcessesFilterString.toString()};
                filter = mgr.createSystemFilter((ISystemFilterContainer)pool, SystemProcessesCoreResources.RESID_PROPERTY_PROCESS_MYPROCESSESFILTER_LABEL, filterStrings);
                filter.setNonChangable(true);
                filter.setSingleFilterStringOnly(true);
            } else {
                HostProcessFilterImpl allProcessesFilterString = new HostProcessFilterImpl();
                String[] filterStrings = new String[]{allProcessesFilterString.toString()};
                ISystemFilter filter = mgr.createSystemFilter((ISystemFilterContainer)pool, SystemProcessesCoreResources.RESID_PROPERTY_PROCESS_DEFAULTFILTER_LABEL, filterStrings);
                filter.setNonChangable(true);
                filter.setSingleFilterStringOnly(true);
            }
        }
        catch (Exception exc) {
            SystemBasePlugin.logError((String)"Error creating default filter pool", (Throwable)exc);
        }
        return pool;
    }

    public ISystemValidator getPortValidator() {
        ValidatorServerPortInput portValidator = new ValidatorServerPortInput();
        return portValidator;
    }
}

