/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.files.dstore;

import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.rse.internal.services.dstore.files.DStoreHostFile;
import org.eclipse.rse.internal.subsystems.files.core.AbstractJavaLanguageUtility;
import org.eclipse.rse.internal.subsystems.files.dstore.DStoreFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.SystemBasePlugin;

public class DStoreJavaLanguageUtility
extends AbstractJavaLanguageUtility {
    public DStoreJavaLanguageUtility(IRemoteFileSubSystem subsystem, String language) {
        super(subsystem, language);
    }

    public String getQualifiedClassName(IRemoteFile remoteFile) {
        DStoreFile univFile = null;
        if (!(remoteFile instanceof DStoreFile)) {
            return null;
        }
        univFile = (DStoreFile)remoteFile;
        DataElement deObj = ((DStoreHostFile)univFile.getHostFile()).getDataElement();
        DataStore ds = deObj.getDataStore();
        DataElement queryCmd = ds.localDescriptorQuery(deObj.getDescriptor(), "C_QUERY_QUALIFIED_CLASSNAME");
        if (queryCmd != null) {
            DataElement status = ds.synchronizedCommand(queryCmd, deObj, true);
            DataElement className = ds.find(status, 0, "fullClassName", 1);
            if (className != null && !className.equals((Object)"null")) {
                return className.getName();
            }
            SystemBasePlugin.logWarning((String)("Qualified class name for " + remoteFile.getAbsolutePath() + " is null"));
        }
        return null;
    }
}

