/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.terminals.ui;

import java.util.ArrayList;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.terminals.ui.views.RSETerminalConnector;
import org.eclipse.rse.internal.terminals.ui.views.TerminalViewTab;
import org.eclipse.rse.services.terminals.ITerminalShell;
import org.eclipse.rse.subsystems.terminals.core.ITerminalServiceSubSystem;
import org.eclipse.rse.subsystems.terminals.core.elements.TerminalElement;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;

public class TerminalServiceHelper {
    public static ITerminalServiceSubSystem getTerminalSubSystem(IHost connection) {
        ISystemRegistry systemRegistry = RSECorePlugin.getTheSystemRegistry();
        ISubSystem[] subsystems = systemRegistry.getSubSystems(connection);
        int i = 0;
        while (i < subsystems.length) {
            if (subsystems[i] instanceof ITerminalServiceSubSystem) {
                ITerminalServiceSubSystem subSystem = (ITerminalServiceSubSystem)subsystems[i];
                return subSystem;
            }
            ++i;
        }
        return null;
    }

    public static ITerminalServiceSubSystem[] getTerminalSubSystems(IHost connection) {
        ArrayList<ITerminalServiceSubSystem> results = new ArrayList<ITerminalServiceSubSystem>();
        ISystemRegistry systemRegistry = RSECorePlugin.getTheSystemRegistry();
        ISubSystem[] subsystems = systemRegistry.getSubSystems(connection);
        int i = 0;
        while (i < subsystems.length) {
            if (subsystems[i] instanceof ITerminalServiceSubSystem) {
                ITerminalServiceSubSystem subSystem = (ITerminalServiceSubSystem)subsystems[i];
                results.add(subSystem);
            }
            ++i;
        }
        return results.toArray(new ITerminalServiceSubSystem[results.size()]);
    }

    public static TerminalElement createTerminalElement(CTabItem item, ITerminalServiceSubSystem terminalServiceSubSystem) {
        TerminalElement element = new TerminalElement(item.getText(), terminalServiceSubSystem);
        return element;
    }

    public static void removeTerminalElementFromHost(CTabItem item, IHost host) {
        ITerminalServiceSubSystem terminalServiceSubSystem = TerminalServiceHelper.getTerminalSubSystem(host);
        if (terminalServiceSubSystem != null) {
            TerminalElement element = terminalServiceSubSystem.getChild(item.getText());
            terminalServiceSubSystem.removeChild(element);
        }
    }

    public static void updateTerminalShellForTerminalElement(CTabItem item) {
        IHost host;
        ITerminalServiceSubSystem terminalServiceSubSystem;
        TerminalElement element;
        Object data = item.getData();
        if (data instanceof IHost && (element = (terminalServiceSubSystem = TerminalServiceHelper.getTerminalSubSystem(host = (IHost)data)).getChild(item.getText())) != null) {
            ITerminalShell terminalShell = TerminalServiceHelper.getTerminalShellFromTab(item);
            if (element.getTerminalShell() != terminalShell) {
                element.setTerminalShell(terminalShell);
            }
        }
    }

    private static ITerminalShell getTerminalShellFromTab(CTabItem item) {
        ITerminalShell terminalShell = null;
        ITerminalViewControl terminalViewControl = (ITerminalViewControl)item.getData(TerminalViewTab.DATA_KEY_CONTROL);
        ITerminalConnector terminalConnector = terminalViewControl.getTerminalConnector();
        if (terminalConnector instanceof RSETerminalConnector) {
            RSETerminalConnector rseTerminalConnector = (RSETerminalConnector)terminalConnector;
            terminalShell = rseTerminalConnector.getTerminalHostShell();
        }
        return terminalShell;
    }
}

