/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.security.wizards;

import java.security.cert.X509Certificate;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rse.internal.dstore.security.UniversalSecurityProperties;
import org.eclipse.rse.internal.dstore.security.preference.CertTableContentProvider;
import org.eclipse.rse.internal.dstore.security.preference.X509CertificateElement;
import org.eclipse.rse.internal.dstore.security.preference.X509CertificatePropertiesDialog;
import org.eclipse.rse.internal.dstore.security.util.GridUtil;
import org.eclipse.rse.internal.dstore.security.wizards.NewCertTableLabelProvider;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.wizards.AbstractSystemWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SystemImportCertWizardMainPage
extends AbstractSystemWizardPage
implements Listener {
    protected SystemMessage errorMessage;
    protected ISystemValidator nameValidator;
    protected ISystemMessageLine msgLine;
    private List _certificates;
    private Button _propertiesButton;
    private TableViewer _viewer;

    public SystemImportCertWizardMainPage(Wizard wizard, List certs) {
        super((IWizard)wizard, "NewCertificate", UniversalSecurityProperties.RESID_SECURITY_TRUST_WIZ_CERTIFICATE_TITLE, UniversalSecurityProperties.RESID_SECURITY_TRUST_WIZ_CERTIFICATE_DESC);
        this._certificates = certs;
    }

    public Control createContents(Composite parent) {
        Composite verbiage = new Composite(parent, 0);
        GridLayout vlayout = new GridLayout();
        GridData vdata = new GridData(1808);
        vlayout.numColumns = 1;
        verbiage.setLayout((Layout)vlayout);
        verbiage.setLayoutData((Object)vdata);
        SystemWidgetHelpers.createLabel((Composite)verbiage, (String)UniversalSecurityProperties.RESID_SECURITY_CERTIFICATE_INFORMATION);
        this.createTableViewer(verbiage);
        Composite b = new Composite(parent, 0);
        GridLayout blayout = new GridLayout();
        GridData bdata = new GridData(131);
        blayout.numColumns = 3;
        b.setLayout((Layout)blayout);
        b.setLayoutData((Object)bdata);
        this._propertiesButton = SystemWidgetHelpers.createPushButton((Composite)b, (String)UniversalSecurityProperties.RESID_SECURITY_PROPERTIES_LBL, (Listener)this);
        return this._propertiesButton;
    }

    private void createTableViewer(Composite parent) {
        this._viewer = new TableViewer(parent, 2056);
        Table table = this._viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = GridUtil.createFill();
        data.heightHint = 30;
        data.widthHint = 80;
        table.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        TableColumn toColumn = new TableColumn(table, 16384);
        toColumn.setText(UniversalSecurityProperties.RESID_SECURITY_PREF_ISSUED_TO);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(90));
        TableColumn frmColumn = new TableColumn(table, 16384);
        frmColumn.setText(UniversalSecurityProperties.RESID_SECURITY_PREF_ISSUED_FROM);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(90));
        TableColumn expColumn = new TableColumn(table, 131072);
        expColumn.setText(UniversalSecurityProperties.RESID_SECURITY_PREF_EXPIRES);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(180));
        table.setLayout((Layout)tableLayout);
        String[] properties = new String[]{"STRING", "STRING", "NUMBER"};
        this._viewer.setColumnProperties(properties);
        this._viewer.setContentProvider((IContentProvider)new CertTableContentProvider());
        this._viewer.setLabelProvider((IBaseLabelProvider)new NewCertTableLabelProvider());
        if (this._certificates != null) {
            int i = 0;
            while (i < this._certificates.size()) {
                this._viewer.add((Object)this.getElement(this._certificates.get(i)));
                ++i;
            }
        }
    }

    public void handleEvent(Event e) {
        if (e.widget == this._propertiesButton) {
            IStructuredSelection sel = (IStructuredSelection)this._viewer.getSelection();
            sel.getFirstElement();
            X509CertificatePropertiesDialog dlg = new X509CertificatePropertiesDialog(this.getShell(), (X509CertificateElement)sel.getFirstElement());
            dlg.open();
        }
    }

    public X509CertificateElement getElement(Object cert) {
        if (cert instanceof X509Certificate) {
            return new X509CertificateElement(null, UniversalSecurityProperties.RESID_SECURITY_TRUSTED_CERTIFICATE, (X509Certificate)cert);
        }
        return null;
    }

    protected Control getInitialFocusControl() {
        return this._propertiesButton;
    }

    protected void initializeInput() {
    }

    public boolean performFinish() {
        return true;
    }

    public boolean isPageComplete() {
        return true;
    }
}

