/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.synchronize.filesystem.subscriber;

import java.io.InputStream;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.internal.importexport.files.UniFilePlus;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.CachedResourceVariant;

public class FileSystemResourceVariant
extends CachedResourceVariant {
    private UniFilePlus ioFile;
    private byte[] bytes;

    public FileSystemResourceVariant(UniFilePlus file) {
        this.ioFile = file;
    }

    public FileSystemResourceVariant(UniFilePlus file, byte[] bytes) {
        this.ioFile = file;
        this.bytes = bytes;
    }

    protected void fetchContents(IProgressMonitor monitor) throws TeamException {
        this.setContents(this.getContents(), monitor);
    }

    protected String getCachePath() {
        return String.valueOf(this.getFilePath()) + " " + this.ioFile.lastModified();
    }

    private String getFilePath() {
        return this.ioFile.getCanonicalPath();
    }

    protected String getCacheId() {
        return "org.eclipse.rse.internal.synchronize";
    }

    public String getName() {
        return this.ioFile.getName();
    }

    public boolean isContainer() {
        return this.ioFile.isDirectory();
    }

    public String getContentIdentifier() {
        return new Date(this.ioFile.lastModified()).toString();
    }

    public byte[] asBytes() {
        if (this.bytes == null) {
            this.bytes = Long.toString(this.ioFile.lastModified()).getBytes();
        }
        return this.bytes;
    }

    public FileSystemResourceVariant[] members() {
        if (this.isContainer()) {
            UniFilePlus[] members = (UniFilePlus[])this.ioFile.listFiles();
            FileSystemResourceVariant[] result = new FileSystemResourceVariant[members.length];
            int i = 0;
            while (i < members.length) {
                result[i] = new FileSystemResourceVariant(members[i]);
                ++i;
            }
            return result;
        }
        return new FileSystemResourceVariant[0];
    }

    public InputStream getContents() throws TeamException {
        try {
            return this.ioFile.getInputStream();
        }
        catch (SystemMessageException e) {
            throw new TeamException("Failed to fetch contents for " + this.getFilePath(), (Throwable)e);
        }
    }

    public UniFilePlus getFile() {
        return this.ioFile;
    }

    public long lastModified() {
        return this.ioFile.lastModified();
    }

    public String toString() {
        return this.ioFile.getAbsolutePath();
    }

    public void synchRemoteFile() {
        this.ioFile.synchRemoteFile();
    }
}

