/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.processes.core.subsystem.impl;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.processes.HostProcessFilterImpl;
import org.eclipse.rse.services.clientserver.processes.IHostProcessFilter;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcess;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcessContext;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcessSubSystem;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcessSubSystemConfiguration;
import org.eclipse.rse.subsystems.processes.core.subsystem.impl.RemoteProcessContext;
import org.eclipse.rse.subsystems.processes.core.subsystem.impl.RemoteProcessImpl;
import org.eclipse.rse.ui.SystemBasePlugin;

public abstract class RemoteProcessSubSystemImpl
extends SubSystem
implements IRemoteProcessSubSystem,
ICommunicationsListener {
    public RemoteProcessSubSystemImpl(IHost host, IConnectorService connectorService) {
        super(host, connectorService);
    }

    public IRemoteProcessSubSystemConfiguration getParentRemoteProcessSubSystemConfiguration() {
        return (IRemoteProcessSubSystemConfiguration)super.getSubSystemConfiguration();
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public void communicationsStateChange(CommunicationsEvent e) {
        switch (e.getState()) {
            case 1: {
                break;
            }
            case 4: {
                this.getConnectorService().removeCommunicationsListener((ICommunicationsListener)this);
                break;
            }
            case 3: 
            case 5: {
                break;
            }
        }
    }

    public void initializeSubSystem(IProgressMonitor monitor) throws SystemMessageException {
        super.initializeSubSystem(monitor);
        Platform.getAdapterManager().loadAdapter((Object)new RemoteProcessImpl(null, null), "org.eclipse.rse.ui.view.ISystemViewElementAdapter");
        this.getConnectorService().addCommunicationsListener((ICommunicationsListener)this);
    }

    public void uninitializeSubSystem(IProgressMonitor monitor) {
        this.getConnectorService().removeCommunicationsListener((ICommunicationsListener)this);
        super.uninitializeSubSystem(monitor);
    }

    public IRemoteProcess getParentProcess(IRemoteProcess process) {
        return process.getParentRemoteProcess();
    }

    protected Object[] internalResolveFilterString(String filterString, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (!this.isConnected()) {
            return null;
        }
        HostProcessFilterImpl rpf = new HostProcessFilterImpl(filterString);
        RemoteProcessContext context = new RemoteProcessContext(this, null, (IHostProcessFilter)rpf);
        Object[] ps = null;
        try {
            ps = this.listAllProcesses((IHostProcessFilter)rpf, context, monitor);
        }
        catch (SystemMessageException e) {
            this.displayAsyncMsg(e);
        }
        return ps;
    }

    public IRemoteProcess[] listRoots(IRemoteProcessContext context, IProgressMonitor monitor) {
        IRemoteProcess[] roots = new IRemoteProcess[1];
        try {
            roots[0] = this.getRemoteProcessObject(1L);
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logError((String)"Exception resolving roots", (Throwable)e);
        }
        return roots;
    }

    public boolean isPassiveCommunicationsListener() {
        return true;
    }

    public Object getObjectWithAbsoluteName(String key, IProgressMonitor monitor) throws Exception {
        Object filterRef = super.getObjectWithAbsoluteName(key, monitor);
        if (filterRef != null) {
            return filterRef;
        }
        try {
            long pid = Long.parseLong(key);
            return this.getRemoteProcessObject(pid);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getObjectWithAbsoluteName(key, monitor);
        }
    }
}

