/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem;

import org.eclipse.rse.internal.subsystems.shells.core.ShellStrings;
import org.eclipse.rse.internal.subsystems.shells.servicesubsystem.OutputRefreshJob;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.services.shells.SimpleHostOutput;
import org.eclipse.rse.subsystems.shells.core.model.RemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.model.RemoteError;
import org.eclipse.rse.subsystems.shells.core.model.RemoteOutput;
import org.eclipse.rse.subsystems.shells.core.subsystems.ICandidateCommand;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IServiceCommandShell;

public class ServiceCommandShell
extends RemoteCommandShell
implements IServiceCommandShell {
    protected IHostShell _hostShell;
    private OutputRefreshJob _lastRefreshJob;

    public ServiceCommandShell(IRemoteCmdSubSystem cmdSS, IHostShell hostShell) {
        super(cmdSS);
        this._hostShell = hostShell;
        this.setType(ShellStrings.RESID_SHELLS_COMMAND_SHELL_LABEL);
    }

    public String getTitle() {
        return this.getId();
    }

    public boolean isActive() {
        return this._hostShell.isActive();
    }

    public IHostShell getHostShell() {
        return this._hostShell;
    }

    public void shellOutputChanged(IHostShellChangeEvent event) {
        IHostOutput[] lines = event.getLines();
        IRemoteOutput[] outputs = new IRemoteOutput[lines.length];
        int i = 0;
        while (i < lines.length) {
            RemoteOutput output = null;
            IHostOutput lineObj = lines[i];
            if (lineObj instanceof SimpleHostOutput) {
                SimpleHostOutput line = (SimpleHostOutput)lineObj;
                String type = event.isError() ? "stderr" : "stdout";
                output = event.isError() ? new RemoteError(this, type) : new RemoteOutput(this, type);
                String str = line.getString();
                output.setText(str);
                this.addOutput(output);
                outputs[i] = output;
            }
            ++i;
        }
        this.notifyOutputChanged(outputs, false);
    }

    protected void notifyOutputChanged(IRemoteOutput[] outputs, boolean cwdChanged) {
        if (this._lastRefreshJob == null || this._lastRefreshJob.isComplete()) {
            this._lastRefreshJob = new OutputRefreshJob(this, outputs, cwdChanged);
            this._lastRefreshJob.schedule();
        } else {
            this._lastRefreshJob.addOutputs(outputs);
            this._lastRefreshJob.schedule();
        }
    }

    public ICandidateCommand[] getCandidateCommands() {
        return null;
    }

    public void writeToShell(String cmd) {
        this._hostShell.writeToShell(cmd);
    }
}

