/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.subsystems;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.RSEPreferencesManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySetContainer;
import org.eclipse.rse.core.model.IRSEPersistableContainer;
import org.eclipse.rse.core.model.RSEModelObject;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IServerLauncher;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.RemoteServerLauncher;
import org.eclipse.rse.core.subsystems.ServerLaunchType;
import org.eclipse.rse.services.Mutex;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;

public abstract class AbstractConnectorService
extends RSEModelObject
implements IConnectorService {
    private Vector commListeners = new Vector(5);
    private ISubSystem _primarySubSystem = null;
    private List _registeredSubSystems = new ArrayList();
    private IHost _host;
    private String _description;
    private String _name;
    private int _port;
    private boolean _usingSSL;
    private final SafeRunner safeRunner = new SafeRunner();

    public AbstractConnectorService(String name, String description, IHost host, int port) {
        this._name = name;
        this._description = description;
        this._host = host;
        this._port = port;
    }

    public final boolean isServerLaunchTypeEnabled(ISubSystem subsystem, ServerLaunchType serverLaunchType) {
        IServerLauncher sl = this.getRemoteServerLauncher();
        if (sl instanceof RemoteServerLauncher) {
            RemoteServerLauncher isl = (RemoteServerLauncher)((Object)sl);
            return isl.isEnabledServerLaunchType(serverLaunchType);
        }
        return subsystem.getSubSystemConfiguration().supportsServerLaunchType(serverLaunchType);
    }

    public IServerLauncher getRemoteServerLauncher() {
        return null;
    }

    public boolean supportsRemoteServerLaunching() {
        return false;
    }

    public boolean supportsServerLaunchProperties() {
        return false;
    }

    public IServerLauncherProperties getRemoteServerLauncherProperties() {
        return null;
    }

    public void setRemoteServerLauncherProperties(IServerLauncherProperties newRemoteServerLauncher) {
    }

    public final boolean hasRemoteServerLauncherProperties() {
        return this.getRemoteServerLauncherProperties() != null;
    }

    public final void addCommunicationsListener(ICommunicationsListener listener) {
        if (!this.commListeners.contains(listener)) {
            this.commListeners.add(listener);
        }
    }

    public final void removeCommunicationsListener(ICommunicationsListener listener) {
        this.commListeners.remove(listener);
    }

    protected final void fireCommunicationsEvent(int eventType) {
        CommunicationsEvent e = new CommunicationsEvent(this, eventType);
        Object[] items = this.commListeners.toArray();
        int loop = 0;
        while (loop < items.length) {
            ((ICommunicationsListener)items[loop]).communicationsStateChange(e);
            ++loop;
        }
    }

    public final IHost getHost() {
        return this._host;
    }

    public final void setHost(IHost host) {
        this._host = host;
    }

    public final String getDescription() {
        return this._description;
    }

    public final String getName() {
        return this._name;
    }

    public final void setPort(int port) {
        if (port != this._port) {
            this._port = port;
            this.setDirty(true);
        }
    }

    public final int getPort() {
        return this._port;
    }

    public final ISubSystem getPrimarySubSystem() {
        if (this._primarySubSystem == null && this._registeredSubSystems.size() != 0) {
            ISubSystem ss = (ISubSystem)this._registeredSubSystems.get(0);
            this._primarySubSystem = ss.getPrimarySubSystem();
        }
        return this._primarySubSystem;
    }

    public final void registerSubSystem(ISubSystem ss) {
        if (!this._registeredSubSystems.contains(ss)) {
            this._registeredSubSystems.add(ss);
        }
    }

    public final void deregisterSubSystem(ISubSystem ss) {
        this._registeredSubSystems.remove(ss);
    }

    public final boolean commit() {
        return this.getHost().commit();
    }

    public final IRSEPersistableContainer getPersistableParent() {
        return this._host;
    }

    public IRSEPersistableContainer[] getPersistableChildren() {
        ArrayList<IPropertySetContainer> children = new ArrayList<IPropertySetContainer>(20);
        IServerLauncherProperties launcherProperties = this.getRemoteServerLauncherProperties();
        if (launcherProperties != null) {
            children.add(this.getRemoteServerLauncherProperties());
        }
        children.addAll(this._registeredSubSystems);
        children.addAll(Arrays.asList(this.getPropertySets()));
        IRSEPersistableContainer[] result = new IRSEPersistableContainer[children.size()];
        children.toArray(result);
        return result;
    }

    public final String getHostName() {
        return this.getHost().getHostName();
    }

    public String getVersionReleaseModification() {
        return "";
    }

    public final ISubSystem[] getSubSystems() {
        return this._registeredSubSystems.toArray(new ISubSystem[this._registeredSubSystems.size()]);
    }

    protected final void initializeSubSystems(IProgressMonitor monitor) throws SystemMessageException {
        int i = 0;
        while (i < this._registeredSubSystems.size()) {
            ISubSystem ss = (ISubSystem)this._registeredSubSystems.get(i);
            ss.initializeSubSystem(monitor);
            ++i;
        }
    }

    protected final void uninitializeSubSystems(IProgressMonitor monitor) {
        int i = 0;
        while (i < this._registeredSubSystems.size()) {
            ISubSystem ss = (ISubSystem)this._registeredSubSystems.get(i);
            ss.uninitializeSubSystem(monitor);
            ++i;
        }
    }

    protected final void notifyDisconnection() {
        if (!this.isConnected()) {
            this.fireCommunicationsEvent(4);
        }
    }

    protected final void notifyConnection() {
        if (this.isConnected()) {
            this.fireCommunicationsEvent(2);
        }
    }

    protected final void notifyError() {
        this.fireCommunicationsEvent(5);
    }

    public final boolean isUsingSSL() {
        return this._usingSSL;
    }

    public final void setIsUsingSSL(boolean flag) {
        if (this._usingSSL != flag) {
            this._usingSSL = flag;
            this.setDirty(true);
        }
    }

    public String getTempDirectory() {
        return "";
    }

    public String getHomeDirectory() {
        return "";
    }

    public void reset() {
    }

    protected int getConnectPort() {
        return this.getPort();
    }

    public final void connect(IProgressMonitor monitor) throws Exception {
        long timeout = 120000L;
        UnsafeRunnableWithProgress runnable = new UnsafeRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws Exception {
                AbstractConnectorService.this.preConnect();
                AbstractConnectorService.this.internalConnect(monitor);
                AbstractConnectorService.this.initializeSubSystems(monitor);
                AbstractConnectorService.this.postConnect();
            }
        };
        try {
            this.safeRunner.run(runnable, timeout, monitor);
        }
        catch (TimeoutException e) {
            String id = RSECorePlugin.getDefault().getBundle().getSymbolicName();
            String messageTemplate = "Connect operation timed out after {0} milliseconds. Operation canceled.";
            String message = NLS.bind((String)messageTemplate, (Object)new Long(e.getTimeout()));
            Status status = new Status(1, id, message);
            RSECorePlugin.getDefault().getLog().log((IStatus)status);
            throw new OperationCanceledException();
        }
    }

    public final void disconnect(IProgressMonitor monitor) throws Exception {
        long timeout = 120000L;
        UnsafeRunnableWithProgress runnable = new UnsafeRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws Exception {
                AbstractConnectorService.this.preDisconnect();
                AbstractConnectorService.this.internalDisconnect(monitor);
                AbstractConnectorService.this.uninitializeSubSystems(monitor);
                AbstractConnectorService.this.postDisconnect();
            }
        };
        try {
            this.safeRunner.run(runnable, timeout, monitor);
        }
        catch (TimeoutException e) {
            String id = RSECorePlugin.getDefault().getBundle().getSymbolicName();
            String messageTemplate = "Disconnect operation timed out after {0} milliseconds.";
            String message = NLS.bind((String)messageTemplate, (Object)new Long(e.getTimeout()));
            Status status = new Status(1, id, message);
            RSECorePlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    protected abstract void internalConnect(IProgressMonitor var1) throws Exception;

    protected abstract void internalDisconnect(IProgressMonitor var1) throws Exception;

    protected void postDisconnect() {
    }

    protected void preDisconnect() {
    }

    protected void preConnect() {
    }

    protected void postConnect() {
    }

    public final int setDenyPasswordSave(boolean deny) {
        IHost host = this.getHost();
        String hostAddress = host.getHostName();
        IRSESystemType systemType = host.getSystemType();
        int result = RSEPreferencesManager.setDenyPasswordSave(systemType, hostAddress, deny);
        return result;
    }

    public final boolean getDenyPasswordSave() {
        IHost host = this.getHost();
        String hostAddress = host.getHostName();
        IRSESystemType systemType = host.getSystemType();
        boolean result = RSEPreferencesManager.getDenyPasswordSave(systemType, hostAddress);
        return result;
    }

    public boolean hasActiveCommunicationListeners() {
        if (this.commListeners.size() > 0) {
            int i = 0;
            while (i < this.commListeners.size()) {
                ICommunicationsListener listener = (ICommunicationsListener)this.commListeners.get(i);
                if (!listener.isPassiveCommunicationsListener()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private class SafeRunner {
        private Mutex semaphore = new Mutex();
        private Thread semaphoreOwner = null;

        private SafeRunner() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void run(UnsafeRunnableWithProgress runnable, long timeout, IProgressMonitor monitor) throws Exception {
            if (this.semaphoreOwner != Thread.currentThread()) {
                if (!this.semaphore.waitForLock(monitor, timeout)) throw new TimeoutException(timeout);
                this.semaphoreOwner = Thread.currentThread();
                try {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    runnable.run(monitor);
                    return;
                }
                finally {
                    this.semaphore.release();
                    this.semaphoreOwner = null;
                }
            } else {
                runnable.run(monitor);
            }
        }
    }

    private class TimeoutException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private long timeoutValue;

        TimeoutException(long timeoutValue) {
            this.timeoutValue = timeoutValue;
        }

        long getTimeout() {
            return this.timeoutValue;
        }
    }

    private static interface UnsafeRunnableWithProgress {
        public void run(IProgressMonitor var1) throws Exception;
    }
}

