/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.persistence.IRSEPersistenceManager;

public abstract class RSEModelOperation {
    private static Map threads = new HashMap();

    public static void check() {
        if (RSEModelOperation.getDepth() == 0) {
            Logger logger = RSECorePlugin.getDefault().getLogger();
            logger.logInfo("not inside transaction");
        }
    }

    private static int getDepth() {
        Thread myThread = Thread.currentThread();
        if (threads.get(myThread) == null) {
            threads.put(myThread, new Integer(0));
        }
        int depth = (Integer)threads.get(myThread);
        return depth;
    }

    private static void beginTransaction() {
    }

    private static void endTransaction() {
        IRSEPersistenceManager persistenceManager = RSECorePlugin.getThePersistenceManager();
        persistenceManager.commitProfiles(5000L);
    }

    private static void enterLevel() {
        int depth = RSEModelOperation.getDepth();
        try {
            if (depth == 0) {
                RSEModelOperation.beginTransaction();
            }
        }
        finally {
            Thread myThread = Thread.currentThread();
            threads.put(myThread, new Integer(depth + 1));
        }
    }

    private static void leaveLevel() {
        int depth = RSEModelOperation.getDepth();
        try {
            if (depth == 1) {
                RSEModelOperation.endTransaction();
            }
        }
        finally {
            Thread myThread = Thread.currentThread();
            threads.put(myThread, new Integer(depth - 1));
        }
    }

    public abstract void execute();

    public void run() {
        RSEModelOperation.enterLevel();
        try {
            this.execute();
        }
        finally {
            RSEModelOperation.leaveLevel();
        }
    }
}

