/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.filters.actions;

import java.util.Vector;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterContainer;
import org.eclipse.rse.core.filters.ISystemFilterContainerReference;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterPoolSelectionValidator;
import org.eclipse.rse.core.filters.ISystemFilterPoolWrapperInformation;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseWizardAction;
import org.eclipse.rse.ui.filters.SystemFilterStringEditPane;
import org.eclipse.rse.ui.filters.actions.ISystemNewFilterActionConfigurator;
import org.eclipse.rse.ui.filters.dialogs.SystemNewFilterWizard;
import org.eclipse.swt.widgets.Shell;

public class SystemNewFilterAction
extends SystemBaseWizardAction {
    protected ISystemFilterPool parentPool;
    protected ISystemFilterPool[] poolsToSelectFrom;
    protected ISystemFilterPoolWrapperInformation poolWrapperInformation;
    protected boolean nested = false;
    protected boolean showFilterStrings = true;
    protected boolean showNamePrompt = true;
    protected boolean showInfoPage = true;
    protected boolean fromRSE = false;
    protected String[] defaultFilterStrings;
    protected String type = null;
    protected String verbiage = null;
    protected String page1Description;
    protected String namePageHelp;
    protected ISystemFilterPoolSelectionValidator filterPoolSelectionValidator;
    protected ISystemNewFilterActionConfigurator callbackConfigurator;
    protected boolean callbackConfiguratorCalled = true;
    protected Object callbackData = null;
    protected SystemFilterStringEditPane editPane;

    public SystemNewFilterAction(Shell shell, ISystemFilterPool parentPool, String label, String tooltip, ImageDescriptor image) {
        this(shell, parentPool, label, tooltip, image, false);
    }

    public SystemNewFilterAction(Shell shell, ISystemFilterPool parentPool, String label, String tooltip, ImageDescriptor image, boolean nested) {
        super(label, tooltip, image, shell);
        this.setContextMenuGroup("group.new");
        this.parentPool = parentPool;
        this.nested = nested;
        this.setAvailableOffline(true);
    }

    public SystemNewFilterAction(Shell shell, ISystemFilterPool parentPool) {
        this(shell, parentPool, SystemResources.ACTION_NEWFILTER_LABEL, SystemResources.ACTION_NEWFILTER_TOOLTIP, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.newfilter_wizIcon"), false);
    }

    public void setCallBackConfigurator(ISystemNewFilterActionConfigurator caller, Object data) {
        this.callbackConfigurator = caller;
        this.callbackData = data;
        this.callbackConfiguratorCalled = false;
    }

    public void setHelpContextId(String id) {
        this.setHelp(id);
    }

    public void setParentFilterPool(ISystemFilterPool parentPool) {
        this.parentPool = parentPool;
    }

    public void setAllowFilterPoolSelection(ISystemFilterPool[] poolsToSelectFrom) {
        this.poolsToSelectFrom = poolsToSelectFrom;
    }

    public void setAllowFilterPoolSelection(ISystemFilterPoolWrapperInformation poolsToSelectFrom) {
        this.poolWrapperInformation = poolsToSelectFrom;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setShowFilterStrings(boolean show) {
        this.showFilterStrings = show;
    }

    public void setDefaultFilterStrings(String[] defaultFilterStrings) {
        this.defaultFilterStrings = defaultFilterStrings;
    }

    public void setShowNamePrompt(boolean show) {
        this.showNamePrompt = show;
    }

    public void setShowInfoPage(boolean show) {
        this.showInfoPage = show;
    }

    public void setVerbiage(String verbiage) {
        this.verbiage = verbiage;
    }

    public void setPage1Description(String description) {
        this.page1Description = description;
    }

    public void setFromRSE(boolean rse) {
        this.fromRSE = true;
    }

    public void setFilterPoolSelectionValidator(ISystemFilterPoolSelectionValidator validator) {
        this.filterPoolSelectionValidator = validator;
    }

    public void setFilterStringEditPane(SystemFilterStringEditPane editPane) {
        this.editPane = editPane;
    }

    public void setNamePageHelp(String helpId) {
        this.namePageHelp = helpId;
    }

    protected void configureNewFilterWizard(SystemNewFilterWizard wizard) {
    }

    protected void configureNewFilter(ISystemFilter newFilter) {
    }

    protected IWizard createWizard() {
        if (this.callbackConfigurator != null && !this.callbackConfiguratorCalled) {
            this.callbackConfigurator.configureNewFilterAction(((ISubSystem)this.callbackData).getSubSystemConfiguration(), this, this.callbackData);
            this.callbackConfiguratorCalled = true;
        }
        SystemNewFilterWizard wizard = this.createNewFilterWizard(this.parentPool);
        if (this.poolsToSelectFrom != null) {
            wizard.setAllowFilterPoolSelection(this.poolsToSelectFrom);
        } else if (this.poolWrapperInformation != null) {
            wizard.setAllowFilterPoolSelection(this.poolWrapperInformation);
        }
        if (this.type != null) {
            wizard.setType(this.type);
        }
        if (this.defaultFilterStrings != null) {
            wizard.setDefaultFilterStrings(this.defaultFilterStrings);
        }
        if (this.namePageHelp != null) {
            wizard.setNamePageHelp(this.namePageHelp);
        }
        wizard.setShowFilterStrings(this.showFilterStrings);
        wizard.setShowNamePrompt(this.showNamePrompt);
        wizard.setShowInfoPage(this.showInfoPage);
        wizard.setFromRSE(this.fromRSE);
        if (this.verbiage != null) {
            wizard.setVerbiage(this.verbiage);
        }
        if (this.page1Description != null) {
            wizard.setPage1Description(this.page1Description);
        }
        if (this.filterPoolSelectionValidator != null) {
            wizard.setFilterPoolSelectionValidator(this.filterPoolSelectionValidator);
        }
        if (this.editPane != null) {
            wizard.setFilterStringEditPane(this.editPane);
        }
        ISystemFilterPoolReferenceManagerProvider provider = this.getSystemFilterPoolReferenceManagerProvider();
        wizard.setSystemFilterPoolReferenceManagerProvider(provider);
        this.configureNewFilterWizard(wizard);
        return wizard;
    }

    protected SystemNewFilterWizard createNewFilterWizard(ISystemFilterPool parentPool) {
        return new SystemNewFilterWizard(parentPool);
    }

    protected void postProcessWizard(IWizard wizard) {
        SystemNewFilterWizard newFilterWizard = (SystemNewFilterWizard)wizard;
        ISystemFilter newFilter = newFilterWizard.getSystemFilter();
        if (newFilter != null) {
            this.configureNewFilter(newFilter);
        }
    }

    public boolean checkObjectType(Object selectedObject) {
        return selectedObject instanceof ISystemFilterContainer || selectedObject instanceof ISystemFilterContainerReference || selectedObject instanceof ISystemFilterPoolReferenceManagerProvider;
    }

    public ISystemFilterPoolReferenceManagerProvider getSystemFilterPoolReferenceManagerProvider() {
        Object firstSelection = this.getFirstSelection();
        if (firstSelection != null) {
            if (firstSelection instanceof ISystemFilterReference) {
                return ((ISystemFilterReference)firstSelection).getProvider();
            }
            if (firstSelection instanceof ISystemFilterPoolReference) {
                return ((ISystemFilterPoolReference)firstSelection).getProvider();
            }
            if (firstSelection instanceof ISystemFilterPoolReferenceManagerProvider) {
                return (ISystemFilterPoolReferenceManagerProvider)firstSelection;
            }
            return null;
        }
        return null;
    }

    public ISystemFilter getNewFilter() {
        Object output = this.getValue();
        if (output instanceof ISystemFilter) {
            return (ISystemFilter)this.getValue();
        }
        return null;
    }

    public String[] getFilterStrings() {
        Object output = this.getValue();
        if (output == null) {
            return null;
        }
        if (output instanceof Vector) {
            Vector v = (Vector)output;
            String[] strings = new String[v.size()];
            int idx = 0;
            while (idx < strings.length) {
                strings[idx] = (String)v.elementAt(idx);
                ++idx;
            }
            return strings;
        }
        if (output instanceof ISystemFilter) {
            return ((ISystemFilter)output).getFilterStrings();
        }
        return null;
    }

    public String getFilterString() {
        String[] strings = this.getFilterStrings();
        if (strings != null && strings.length > 0) {
            return strings[0];
        }
        return null;
    }
}

