/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.useractions.UserActionsIcon;
import org.eclipse.rse.internal.useractions.ui.ISystemSubstitutor;
import org.eclipse.rse.internal.useractions.ui.SystemCmdSubstVarList;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDAEditPaneHoster;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDTreeView;
import org.eclipse.rse.internal.useractions.ui.uda.SystemPromptUDADialog;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResolvedTypes;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionEditPane;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionElement;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionManager;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAsBaseAction;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDBaseManager;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeEditPane;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeElement;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeManager;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.shells.ui.RemoteCommandHelpers;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.SystemTableViewProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;

public abstract class SystemUDActionSubsystem
implements ISystemSubstitutor {
    public static final int DOMAIN_NONE = -1;
    protected ISubSystem _subsystem;
    protected ISubSystemConfiguration subsystemFactory;
    protected SystemUDActionManager udActionManager;
    protected SystemUDTypeManager udTypeManager;
    protected SystemUDAResolvedTypes udaResolvedTypes;
    protected SystemUDActionElement currentAction;
    protected boolean testAction;
    protected String osType = "default";
    static /* synthetic */ Class class$0;

    protected abstract boolean doActionsMigration(ISystemProfile var1, String var2);

    protected abstract boolean doTypesMigration(ISystemProfile var1, String var2);

    protected String getNewNodeActionLabel() {
        return SystemUDAResources.ACTION_CASCADING_NEW_LABEL;
    }

    protected String getNewNodeTypeLabel() {
        return SystemUDAResources.ACTION_CASCADING_NEW_LABEL;
    }

    public SystemUDActionManager getUDActionManager() {
        if (this.udActionManager == null) {
            this.udActionManager = new SystemUDActionManager(this);
        }
        return this.udActionManager;
    }

    public SystemUDTypeManager getUDTypeManager() {
        if (this.udTypeManager == null && this.supportsTypes()) {
            this.udTypeManager = new SystemUDTypeManager(this);
        }
        return this.udTypeManager;
    }

    public abstract SystemCmdSubstVarList getActionSubstVarList(int var1);

    public SystemCmdSubstVarList getActionSubstVarList(SystemUDActionElement action) {
        int actionDomainType = action.getDomain();
        return this.getActionSubstVarList(actionDomainType);
    }

    public ISubSystem getSubsystem() {
        return this._subsystem;
    }

    public void setSubsystem(ISubSystem ss) {
        this._subsystem = ss;
        if (ss != null) {
            this.setSubSystemFactory(ss.getSubSystemConfiguration());
        }
    }

    public ISubSystemConfiguration getSubSystemFactory() {
        return this.subsystemFactory;
    }

    public void setSubSystemFactory(ISubSystemConfiguration ssf) {
        this.subsystemFactory = ssf;
    }

    public boolean supportsTypes() {
        return true;
    }

    public boolean supportsTypes(int domain) {
        return this.supportsTypes();
    }

    public boolean supportsDomains() {
        return false;
    }

    public int getSingleDomain(SystemUDBaseManager docManager) {
        return -1;
    }

    public SystemUDActionEditPane getCustomUDActionEditPane(ISubSystem ss, ISubSystemConfiguration ssFactory, ISystemProfile profile, ISystemUDAEditPaneHoster parent, ISystemUDTreeView tv) {
        return new SystemUDActionEditPane(this, parent, tv);
    }

    protected final SystemUDActionEditPane getCustomUDActionEditPane(ISubSystem ss, ISystemUDAEditPaneHoster parent, ISystemUDTreeView tv) {
        return this.getCustomUDActionEditPane(ss, null, null, parent, tv);
    }

    protected final SystemUDActionEditPane getCustomUDActionEditPane(ISubSystemConfiguration ssFactory, ISystemProfile profile, ISystemUDAEditPaneHoster parent, ISystemUDTreeView tv) {
        return this.getCustomUDActionEditPane(null, ssFactory, profile, parent, tv);
    }

    public SystemUDTypeEditPane getCustomUDTypeEditPane(ISystemUDAEditPaneHoster parent, ISystemUDTreeView tv) {
        return new SystemUDTypeEditPane(this, parent, tv);
    }

    public abstract SystemUDTypeElement[] primeDefaultTypes(SystemUDTypeManager var1);

    public abstract SystemUDActionElement[] primeDefaultActions(SystemUDActionManager var1, ISystemProfile var2);

    public boolean restoreDefaultAction(SystemUDActionElement element, int domain, String actionName) {
        return false;
    }

    public boolean restoreDefaultType(SystemUDTypeElement element, int domain, String typeName) {
        return false;
    }

    public String getTestActionName() {
        return "ibm test action";
    }

    public String getTestFileName() {
        return "TESTUSERACTION.TXT";
    }

    public String getTestFilePath() {
        return "c:\\Test_RSE_User_Actions";
    }

    protected void printTestActionInvokeOnceInformation(Shell shell, PrintWriter writer) {
    }

    public void run(Shell shell, SystemUDActionElement action, IStructuredSelection selection, ISystemResourceChangeListener viewer) {
        PrintWriter testWriter;
        File testFile;
        boolean actionRunEvenOnce;
        block33: {
            this.processingSelection(true);
            Iterator elements = selection.iterator();
            this.currentAction = action;
            IRemoteCmdSubSystem cmdSubSystem = null;
            boolean runOnce = action.getCollect();
            actionRunEvenOnce = false;
            boolean cancelled = false;
            String command = action.getCommand();
            this.testAction = action.getName().toLowerCase().startsWith(this.getTestActionName());
            testFile = null;
            testWriter = null;
            if (this.testAction) {
                this.currentAction = action;
                try {
                    String testFileName;
                    File testDir;
                    String testFileDir = action.getComment();
                    if (testFileDir == null || testFileDir.trim().length() == 0) {
                        testFileDir = this.getTestFilePath();
                    }
                    if (!(testDir = new File(testFileDir)).exists()) {
                        testDir.mkdir();
                    }
                    if ((testFileName = command) == null || testFileName.trim().length() == 0) {
                        testFileName = this.getTestFileName();
                    }
                    testFile = new File(testDir, testFileName);
                    String message = "In test action mode. Output file is: {0}";
                    message = MessageFormat.format(message, testFile.getAbsolutePath());
                    SystemBasePlugin.logInfo((String)message);
                    testWriter = new PrintWriter(new FileOutputStream(testFile));
                    this.getActionSubstVarList(action.getDomain()).printDisplayStrings(testWriter);
                }
                catch (Exception exc) {
                    if (testFile != null) {
                        String message = "Error creating test file {0} for user actions:";
                        message = MessageFormat.format(message, testFile.getAbsolutePath());
                        SystemBasePlugin.logError((String)message, (Throwable)exc);
                    }
                    return;
                }
            }
            try {
                if (!this.checkDirtyEditors(selection)) break block33;
                if (!runOnce) {
                    Object selectedObject = null;
                    while (!cancelled && elements.hasNext()) {
                        selectedObject = elements.next();
                        if (cmdSubSystem == null) {
                            cmdSubSystem = SystemUDActionSubsystem.getCommandSubSystem(selectedObject);
                        }
                        if (this.testAction) {
                            SystemCmdSubstVarList supportedVariables = this.getActionSubstVarList(action.getDomain());
                            String[] substitutedVariables = supportedVariables.doAllSubstitutions(selectedObject, this);
                            if (testWriter == null) continue;
                            testWriter.println("Selected Object: " + SystemUDActionSubsystem.getRemoteAdapter(selectedObject).getAbsoluteName(selectedObject));
                            int idx = 0;
                            while (idx < substitutedVariables.length) {
                                testWriter.println("....." + substitutedVariables[idx]);
                                ++idx;
                            }
                            continue;
                        }
                        String cmd = this.doCommandSubstitutions(action, command, selectedObject);
                        if (action.getPrompt() && (cmd = this.promptCommand(shell, cmd)) == null) {
                            cancelled = true;
                        }
                        if (!cancelled) {
                            boolean bl = cancelled = !this.runCommand(shell, action, cmd, cmdSubSystem, selectedObject, (Viewer)viewer);
                        }
                        if (cancelled || actionRunEvenOnce) continue;
                        actionRunEvenOnce = true;
                    }
                    break block33;
                }
                StringBuffer collectedNames = new StringBuffer();
                Object firstSelectedObject = this.collectNames(shell, elements, collectedNames);
                if (firstSelectedObject == null) {
                    return;
                }
                String nameVar = this.getAllNamesSubstitutionVariable();
                String cmd = command;
                if (nameVar != null) {
                    int nameVarIdx;
                    if (this.testAction) {
                        cmd = nameVar;
                    }
                    if ((nameVarIdx = cmd.indexOf(nameVar)) >= 0) {
                        cmd = String.valueOf(cmd.substring(0, nameVarIdx)) + collectedNames.toString() + cmd.substring(nameVarIdx + nameVar.length());
                    }
                }
                if (this.testAction && testWriter != null) {
                    SystemCmdSubstVarList supportedVariables = this.getActionSubstVarList(action.getDomain());
                    String[] substitutedVariables = supportedVariables.doAllSubstitutions(firstSelectedObject, this);
                    testWriter.println("First Selected Object: " + SystemUDActionSubsystem.getRemoteAdapter(firstSelectedObject).getAbsoluteName(firstSelectedObject));
                    if (nameVar != null) {
                        testWriter.println("....." + nameVar + " = " + cmd);
                    }
                    int idx = 0;
                    while (idx < substitutedVariables.length) {
                        testWriter.println("....." + substitutedVariables[idx]);
                        ++idx;
                    }
                    this.printTestActionInvokeOnceInformation(shell, testWriter);
                } else {
                    cmd = this.doCommandSubstitutions(action, cmd, firstSelectedObject);
                    if (action.getPrompt() && (cmd = this.promptCommand(shell, cmd)) == null) {
                        cancelled = true;
                    }
                    if (!cancelled) {
                        cmdSubSystem = SystemUDActionSubsystem.getCommandSubSystem(firstSelectedObject);
                        boolean bl = cancelled = !this.runCommand(shell, action, cmd, cmdSubSystem, firstSelectedObject, (Viewer)viewer);
                    }
                    if (!cancelled) {
                        actionRunEvenOnce = true;
                    }
                }
            }
            catch (Exception exc) {
                SystemMessageDialog.displayExceptionMessage((Shell)shell, (Throwable)exc);
                System.out.println("Error running user action " + command + ": " + exc.getMessage());
                return;
            }
        }
        if (actionRunEvenOnce && action.getRefresh()) {
            ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
            if (viewer != null) {
                sr.fireEvent(viewer, (ISystemResourceChangeEvent)new SystemResourceChangeEvent(selection.toArray(), 85, null));
            } else {
                sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(selection.toArray(), 85, null));
            }
        }
        if (testWriter != null && testFile != null) {
            testWriter.flush();
            testWriter.close();
            SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEO1000");
            msg.makeSubstitution((Object)("Test file " + testFile.getName() + " generated successfully"), (Object)("The file was generated in directory " + testFile.getParent()));
            SystemMessageDialog dlg = new SystemMessageDialog(shell, msg);
            dlg.openWithDetails();
        }
        this.processingSelection(false);
    }

    protected boolean runCommand(Shell shell, SystemUDActionElement action, String cmdString, IRemoteCmdSubSystem cmdSubSystem, Object context, Viewer viewer) {
        boolean ok = false;
        if (cmdSubSystem != null) {
            ok = true;
            try {
                cmdSubSystem.runCommand(cmdString, context, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)"RunUserAction", (Throwable)e);
                SystemMessageDialog.displayExceptionMessage((Shell)shell, (Throwable)e);
                ok = false;
            }
        }
        return ok;
    }

    protected String doCommandSubstitutions(SystemUDActionElement action, String cmd, Object selectedObject) {
        this.currentAction = action;
        SystemCmdSubstVarList supportedVariables = this.getActionSubstVarList(action);
        return supportedVariables.doSubstitutions(cmd, selectedObject, this);
    }

    protected Object collectNames(Shell shell, Iterator elements, StringBuffer collectedNames) {
        return this.collectNamesDefaultMethod(shell, elements, collectedNames);
    }

    protected Object collectNamesDefaultMethod(Shell shell, Iterator elements, StringBuffer collectedNames) {
        Object firstSelectedObject = null;
        while (elements.hasNext()) {
            Object selectedObject = elements.next();
            if (firstSelectedObject == null) {
                firstSelectedObject = selectedObject;
            } else {
                collectedNames.append(" ");
            }
            collectedNames.append(this.getNameDelimiter());
            collectedNames.append(SystemUDActionSubsystem.getRemoteAdapter(selectedObject).getAbsoluteName(selectedObject));
            collectedNames.append(this.getNameDelimiter());
        }
        return firstSelectedObject;
    }

    protected String getAllNamesSubstitutionVariable() {
        return "${resource_name}";
    }

    protected char getNameDelimiter() {
        return '\"';
    }

    protected String promptCommand(Shell shell, String command) {
        return this.promptCommandDefault(shell, command);
    }

    protected String promptCommandDefault(Shell shell, String command) {
        SystemPromptUDADialog dialog = new SystemPromptUDADialog(shell, command);
        dialog.open();
        if (!dialog.wasCancelled()) {
            return dialog.getCommand();
        }
        return null;
    }

    protected static IRemoteCmdSubSystem getCommandSubSystem(Object selectedObject) {
        return RemoteCommandHelpers.getCmdSubSystem((IHost)SystemUDActionSubsystem.getRemoteAdapter(selectedObject).getSubSystem(selectedObject).getHost());
    }

    protected static IRemoteFileSubSystem getFileSubSystem(Object selectedObject) {
        IRemoteFileSubSystem[] rfsss = RemoteFileUtility.getFileSubSystems((IHost)SystemUDActionSubsystem.getCommandSubSystem(selectedObject).getHost());
        if (rfsss != null && rfsss.length > 0) {
            return rfsss[0];
        }
        return null;
    }

    protected static ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        if (!(o instanceof IAdaptable)) {
            IAdapterManager iAdapterManager = Platform.getAdapterManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ISystemRemoteElementAdapter)iAdapterManager.getAdapter(o, (Class)clazz);
        }
        IAdaptable iAdaptable = (IAdaptable)o;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ISystemRemoteElementAdapter)iAdaptable.getAdapter((Class)clazz);
    }

    public String getSubstitutionValue(String subvar, Object context) {
        return this.getCommonSubstitutionValues(subvar, context);
    }

    public String getCommonSubstitutionValues(String subvar, Object context) {
        if (subvar.equals("${action_name}")) {
            return this.currentAction.toString();
        }
        if (subvar.equals("${connection_name}")) {
            return SystemUDActionSubsystem.getCommandSubSystem(context).getHost().getAliasName();
        }
        if (subvar.equals("${user_id}")) {
            return SystemUDActionSubsystem.getCommandSubSystem(context).getConnectorService().getUserId();
        }
        if (subvar.equals("${system_tempdir}")) {
            return SystemUDActionSubsystem.getCommandSubSystem(context).getConnectorService().getTempDirectory();
        }
        if (subvar.equals("${system_homedir}")) {
            return SystemUDActionSubsystem.getCommandSubSystem(context).getConnectorService().getHomeDirectory();
        }
        if (subvar.equals("${system_pathsep}")) {
            IRemoteFileSubSystem rfss = SystemUDActionSubsystem.getFileSubSystem(context);
            if (rfss != null) {
                return rfss.getParentRemoteFileSubSystemConfiguration().getPathSeparator();
            }
            return "system_pathsep not available";
        }
        if (subvar.equals("${system_filesep}")) {
            IRemoteFileSubSystem rfss = SystemUDActionSubsystem.getFileSubSystem(context);
            if (rfss != null) {
                return rfss.getParentRemoteFileSubSystemConfiguration().getSeparator();
            }
            return "system_filesep not available";
        }
        if (subvar.equals("${system_hostname}")) {
            return SystemUDActionSubsystem.getCommandSubSystem(context).getHost().getHostName();
        }
        if (subvar.equals("${local_hostname}")) {
            return RSECorePlugin.getLocalMachineName();
        }
        if (subvar.equals("${local_ip}")) {
            return RSECorePlugin.getLocalMachineIPAddress();
        }
        if (subvar.equals("${resource_name}")) {
            return SystemUDActionSubsystem.getRemoteAdapter(context).getName(context);
        }
        if (subvar.equals("${resource_path}")) {
            return SystemUDActionSubsystem.getRemoteAdapter(context).getAbsoluteName(context);
        }
        return this.internalGetSubstitutionValue(this.currentAction, subvar, context);
    }

    public abstract String internalGetSubstitutionValue(SystemUDActionElement var1, String var2, Object var3);

    public boolean hasUnsupportedSubstitutionVars(Object action, int domain) {
        return false;
    }

    public boolean eligibleUserActionsForSelection(IStructuredSelection selection, ISystemProfile profile) {
        return true;
    }

    public Action[] addUserActions(IMenuManager menu, IStructuredSelection selection, ISystemProfile profile, Shell shell) {
        SystemUDActionManager actMgr = this.getUDActionManager();
        ISystemProfile[] profiles = null;
        profiles = profile == null ? this.getActiveSystemProfiles() : new ISystemProfile[]{profile};
        int domain = -1;
        if (this.supportsDomains() && (domain = this.getDomainFromSelection(selection)) == -1) {
            return new Action[0];
        }
        boolean multiSelection = selection.size() != 1;
        ArrayList<SystemUDAsBaseAction> actionList = new ArrayList<SystemUDAsBaseAction>();
        int idx = 0;
        while (idx < profiles.length) {
            profile = profiles[idx];
            SystemUDActionElement[] actionElements = actMgr.getActions(null, profile, domain);
            int i = 0;
            while (i < actionElements.length) {
                SystemUDActionElement actionElement = actionElements[i];
                if (!(!actionElement.getShow() || multiSelection && actionElement.getSingleSelection() || this.supportsDomains() && domain != actionElement.getDomain() || this.supportsTypes() && !this.meetsSelection(actionElement, selection, domain))) {
                    SystemUDAsBaseAction uda = new SystemUDAsBaseAction(actionElement, shell, this);
                    uda.setSelection((ISelection)selection);
                    uda.setShell(shell);
                    uda.setEnabled(!this.getWorkingOfflineMode());
                    actionList.add(uda);
                    if (menu != null) {
                        menu.add((IAction)uda);
                    }
                }
                ++i;
            }
            ++idx;
        }
        Action[] list = actionList.toArray(new Action[0]);
        return list;
    }

    public boolean getWorkingOfflineMode() {
        return false;
    }

    protected abstract int getDomainFromSelection(IStructuredSelection var1);

    protected boolean meetsSelection(SystemUDActionElement action, IStructuredSelection selection, int domainType) {
        String[] unresolvedActionTypes = action.getFileTypes();
        if (unresolvedActionTypes == null || unresolvedActionTypes.length == 0) {
            return true;
        }
        if (unresolvedActionTypes[0].equals("ALL")) {
            return true;
        }
        String[] actionTypes = this.resolveTypes(unresolvedActionTypes, domainType);
        Iterator elements = selection.iterator();
        Object element = null;
        while (elements.hasNext()) {
            element = elements.next();
            boolean foundMatch = false;
            int j = 0;
            while (!foundMatch && j < actionTypes.length) {
                if (this.isMatch(actionTypes[j], element, domainType)) {
                    foundMatch = true;
                    break;
                }
                ++j;
            }
            if (foundMatch) continue;
            return false;
        }
        return true;
    }

    protected String[] resolveTypes(String[] p_types, int domainType) {
        Vector<String> types = new Vector<String>();
        int i = 0;
        while (i < p_types.length) {
            String fileTypes = this.getFileTypesForTypeName(p_types[i], domainType);
            if (fileTypes != null) {
                StringTokenizer st = new StringTokenizer(fileTypes, this.getTypesDelimiter());
                int n = st.countTokens();
                int j = 0;
                while (j < n) {
                    String token = st.nextToken().trim();
                    if (types.indexOf(token) < 0) {
                        types.addElement(token);
                    }
                    ++j;
                }
            }
            ++i;
        }
        String[] allTypes = new String[types.size()];
        int idx = 0;
        while (idx < allTypes.length) {
            allTypes[idx] = (String)types.elementAt(idx);
            ++idx;
        }
        return allTypes;
    }

    private String getFileTypesForTypeName(String name, int domainType) {
        if (this.udaResolvedTypes == null) {
            this.udaResolvedTypes = this.getResolvedTypesHelper();
        }
        return this.udaResolvedTypes.getFileTypesForTypeName(name, domainType, this.getUDTypeManager());
    }

    protected abstract boolean isMatch(Object var1, Object var2, int var3);

    protected String getTypesDelimiter() {
        return " ";
    }

    public void resetResolvedTypes() {
        this.udaResolvedTypes = null;
    }

    public SystemUDAResolvedTypes getResolvedTypesHelper() {
        return new SystemUDAResolvedTypes();
    }

    public int getMaximumDomain() {
        return -1;
    }

    public String mapDomainName(int domainInteger) {
        if (domainInteger >= 0 && domainInteger <= this.getMaximumDomain()) {
            return this.getDomainNames()[domainInteger];
        }
        return null;
    }

    public int mapDomainName(String domainName) {
        String[] domainNames = this.getDomainNames();
        int match = -1;
        if (domainNames != null && domainNames.length > 0) {
            int idx = 0;
            while (match == -1 && idx < domainNames.length) {
                if (domainNames[idx].equals(domainName)) {
                    match = idx;
                }
                ++idx;
            }
        }
        return match;
    }

    public String mapDomainXlatedName(int domainInteger) {
        if (domainInteger >= 0 && domainInteger <= this.getMaximumDomain()) {
            return this.getXlatedDomainNames()[domainInteger];
        }
        return null;
    }

    public String mapDomainXlatedNewName(int domainInteger) {
        if (domainInteger >= 0 && domainInteger <= this.getMaximumDomain()) {
            return this.getXlatedDomainNewNames()[domainInteger];
        }
        return null;
    }

    public String mapDomainXlatedNewTypeName(int domainInteger) {
        if (domainInteger >= 0 && domainInteger <= this.getMaximumDomain()) {
            return this.getXlatedDomainNewTypeNames()[domainInteger];
        }
        return null;
    }

    public String[] getDomainNames() {
        return null;
    }

    public String[] getXlatedDomainNames() {
        return null;
    }

    public String[] getXlatedDomainNewNames() {
        return null;
    }

    public String[] getXlatedDomainNewTypeNames() {
        return null;
    }

    public Image getDomainImage(int domain) {
        return null;
    }

    public Image getDomainNewImage(int domain) {
        return UserActionsIcon.USERACTION_NEW.getImage();
    }

    public Image getDomainNewTypeImage(int domain) {
        return UserActionsIcon.USERTYPE_NEW.getImage();
    }

    protected ISystemProfile[] getActiveSystemProfiles() {
        return RSECorePlugin.getTheSystemRegistry().getActiveSystemProfiles();
    }

    protected List getDirtyEditors(IStructuredSelection sel) {
        ArrayList<ISystemEditableRemoteObject> dirtyEditors = new ArrayList<ISystemEditableRemoteObject>();
        List selection = sel.toList();
        int i = 0;
        while (i < selection.size()) {
            ISystemEditableRemoteObject editable;
            Object selected = selection.get(i);
            if (selected instanceof IAdaptable && (editable = this.getEditableFor((IAdaptable)selected)) != null) {
                try {
                    if (editable.checkOpenInEditor() == 0) {
                        editable.openEditor();
                        if (editable.isDirty()) {
                            dirtyEditors.add(editable);
                        }
                    }
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        return dirtyEditors;
    }

    protected ISystemEditableRemoteObject getEditableFor(IAdaptable selected) {
        ISystemRemoteElementAdapter adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ISystemRemoteElementAdapter)selected.getAdapter((Class)clazz)).canEdit((Object)selected)) {
            ISystemEditableRemoteObject editable = adapter.getEditableRemoteObject((Object)selected);
            try {
                editable.setLocalResourceProperties();
            }
            catch (Exception exception) {}
            return editable;
        }
        return null;
    }

    protected boolean checkDirtyEditors(IStructuredSelection selection) {
        List dirtyEditors = this.getDirtyEditors(selection);
        if (dirtyEditors.size() > 0) {
            AdaptableList input = new AdaptableList();
            int i = 0;
            while (i < dirtyEditors.size()) {
                ISystemEditableRemoteObject rmtObj = (ISystemEditableRemoteObject)dirtyEditors.get(i);
                input.add(rmtObj.getRemoteObject());
                ++i;
            }
            WorkbenchContentProvider cprovider = new WorkbenchContentProvider();
            SystemTableViewProvider lprovider = new SystemTableViewProvider();
            ListSelectionDialog dlg = new ListSelectionDialog(SystemBasePlugin.getActiveWorkbenchShell(), (Object)input, (IStructuredContentProvider)cprovider, (ILabelProvider)lprovider, SystemUDAResources.EditorManager_saveResourcesMessage);
            dlg.setInitialSelections(input.getChildren());
            dlg.setTitle(SystemUDAResources.EditorManager_saveResourcesTitle);
            int result = dlg.open();
            if (result == 1) {
                return false;
            }
            Object[] filesToSave = dlg.getResult();
            int s = 0;
            while (s < filesToSave.length) {
                IAdaptable rmtObj = (IAdaptable)filesToSave[s];
                ISystemEditableRemoteObject editable = this.getEditableFor(rmtObj);
                editable.doImmediateSaveAndUpload();
                ++s;
            }
        }
        return true;
    }

    protected void processingSelection(boolean processingSelection) {
    }

    public String getOSType() {
        return this.osType;
    }
}

