/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.local;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tm.internal.terminal.local.ILocalTerminalSettings;
import org.eclipse.tm.internal.terminal.local.LocalTerminalLaunchLabelProvider;
import org.eclipse.tm.internal.terminal.local.LocalTerminalLaunchListProvider;
import org.eclipse.tm.internal.terminal.local.LocalTerminalMessages;
import org.eclipse.tm.internal.terminal.local.LocalTerminalUtilities;
import org.eclipse.tm.internal.terminal.local.launch.LocalTerminalLaunchUtilities;
import org.eclipse.tm.internal.terminal.local.ui.DependentHeightComposite;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LocalTerminalSettingsPage
implements ISettingsPage,
ISelectionChangedListener,
SelectionListener {
    private ILocalTerminalSettings settings;
    private TableViewer viewer;
    private Button buttonEdit;
    private Button buttonNew;
    private Button buttonDelete;

    public LocalTerminalSettingsPage(ILocalTerminalSettings settings) {
        this.settings = settings;
    }

    public void createControl(Composite parent) {
        ILaunchConfiguration defaultConfiguration = LocalTerminalLaunchUtilities.createDefaultLaunchConfiguration();
        Composite enclosing = parent.getParent();
        Layout enclosingLayout = enclosing.getLayout();
        int extra = 0;
        if (enclosingLayout instanceof GridLayout) {
            extra = -2 * ((GridLayout)enclosingLayout).marginHeight - 2;
        }
        DependentHeightComposite composite = new DependentHeightComposite(parent, 0, enclosing, extra);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData(new GridData(1808));
        Label label = new Label((Composite)composite, 0);
        label.setText(LocalTerminalMessages.launchConfiguration);
        label.setLayoutData((Object)new GridData());
        Composite tableAndButtons = new Composite((Composite)composite, 0);
        tableAndButtons.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        tableAndButtons.setLayout((Layout)layout);
        Table table = new Table(tableAndButtons, 2048);
        this.viewer = new TableViewer(table);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LocalTerminalLaunchLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new LocalTerminalLaunchListProvider());
        this.viewer.setInput(new Object());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 0, 3));
        this.buttonNew = this.pushButton(tableAndButtons, LocalTerminalMessages.labelNew, false);
        this.buttonEdit = this.pushButton(tableAndButtons, LocalTerminalMessages.labelEdit, false);
        this.buttonEdit.setEnabled(this.settings.getLaunchConfigurationName() != null);
        this.buttonDelete = this.pushButton(tableAndButtons, LocalTerminalMessages.labelDelete, true);
        this.buttonDelete.setEnabled(this.settings.getLaunchConfigurationName() != null);
        this.loadSettings();
        if (defaultConfiguration != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)defaultConfiguration), true);
        }
    }

    public void loadSettings() {
        ILaunchConfiguration configuration;
        String configurationName = this.settings.getLaunchConfigurationName();
        try {
            configuration = LocalTerminalUtilities.findLaunchConfiguration(configurationName);
        }
        catch (CoreException coreException) {
            configuration = null;
        }
        if (this.settings.getLaunchConfigurationName() != null && configuration != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)configuration), true);
        }
    }

    public void saveSettings() {
        IStructuredSelection selection;
        Object element;
        if (this.viewer != null && !this.viewer.getSelection().isEmpty() && (element = (selection = (IStructuredSelection)this.viewer.getSelection()).getFirstElement()) instanceof ILaunchConfiguration) {
            String launchConfiguration = ((ILaunchConfiguration)element).getName();
            this.settings.setLaunchConfigurationName(launchConfiguration);
        }
    }

    public boolean validateSettings() {
        return this.viewer != null && !this.viewer.getSelection().isEmpty();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.buttonEdit.setEnabled(!event.getSelection().isEmpty());
        this.buttonDelete.setEnabled(!event.getSelection().isEmpty());
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        ILaunchConfiguration configuration = null;
        Widget widget = event.widget;
        if (widget == null) {
            return;
        }
        if (widget.equals(this.buttonNew)) {
            try {
                ILaunchConfigurationWorkingCopy newLaunch = LocalTerminalLaunchUtilities.createNewLaunchConfigurationWorkingCopy();
                configuration = newLaunch.doSave();
            }
            catch (CoreException couldNotCreateNewLaunchConfiguration) {
                Logger.logException((Exception)((Object)couldNotCreateNewLaunchConfiguration));
            }
        }
        if (widget.equals(this.buttonEdit) || configuration != null) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (configuration == null) {
                configuration = (ILaunchConfiguration)selection.getFirstElement();
            }
            ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)configuration, (String)"run");
            String groupID = group.getIdentifier();
            DebugUITools.openLaunchConfigurationDialog((Shell)LocalTerminalSettingsPage.getShell(), (ILaunchConfiguration)configuration, (String)groupID, null);
            this.viewer.refresh();
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)configuration), true);
        }
        if (widget.equals(this.buttonDelete)) {
            String title = LocalTerminalMessages.questionTitleDeleteLaunchConfiguration;
            String question = LocalTerminalMessages.questionDeleteLaunchConfiguration;
            if (MessageDialog.openQuestion((Shell)LocalTerminalSettingsPage.getShell(), (String)title, (String)question)) {
                IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
                configuration = (ILaunchConfiguration)selection.getFirstElement();
                try {
                    configuration.delete();
                }
                catch (CoreException exception) {
                    ErrorDialog.openError((Shell)LocalTerminalSettingsPage.getShell(), null, null, (IStatus)exception.getStatus());
                }
                this.viewer.refresh();
            }
        }
    }

    static Shell getShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
        if (activeWindow != null) {
            return activeWindow.getShell();
        }
        IWorkbenchWindow[] allWindows = workbench.getWorkbenchWindows();
        return allWindows.length > 0 ? allWindows[0].getShell() : null;
    }

    private Button pushButton(Composite parent, String label, boolean grabVertical) {
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData layoutData = new GridData(258);
        layoutData.grabExcessVerticalSpace = grabVertical;
        button.setLayoutData((Object)layoutData);
        button.addSelectionListener((SelectionListener)this);
        return button;
    }
}

