/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.persistence.RSEEnvelope;
import org.eclipse.rse.persistence.IRSEPersistenceManager;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;
import org.eclipse.rse.tests.core.RSECoreTestCase;

public class ExportImportTest
extends RSECoreTestCase {
    ISystemProfile sourceProfile = null;
    ISystemRegistry registry = null;
    IRSEPersistenceManager manager = null;
    ISubSystemConfiguration configuration = null;
    static /* synthetic */ Class class$0;

    public ExportImportTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.manager = RSECorePlugin.getThePersistenceManager();
        this.registry = RSECorePlugin.getTheSystemRegistry();
        ISystemProfileManager profileManager = this.registry.getSystemProfileManager();
        this.sourceProfile = profileManager.createSystemProfile("profile1", true);
        IRSESystemType systemType = RSECorePlugin.getTheCoreRegistry().getSystemTypeById("org.eclipse.rse.systemtype.unix");
        IHost host1 = this.registry.createHost(this.sourceProfile.getName(), systemType, "host1", "localhost", "host1", true);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISubSystem[] subsystems = this.registry.getSubsystems(host1, (Class)clazz);
        ISubSystem host1FileSubsystem = subsystems[0];
        String[] filterStrings = new String[]{"*.txt"};
        ISystemFilterPool host1FilterPool = host1FileSubsystem.getUniqueOwningSystemFilterPool(true);
        ISystemFilter hostFilter1 = host1FilterPool.createSystemFilter("hostFilter1", filterStrings);
        hostFilter1.setType("hostFilter1Type");
        filterStrings = new String[]{"*.c"};
        host1FilterPool.createSystemFilter("hostFilter2", filterStrings);
        this.configuration = host1FileSubsystem.getSubSystemConfiguration();
        ISystemFilterPoolManager filterPoolManager = this.configuration.getFilterPoolManager(this.sourceProfile, true);
        ISystemFilterPool sharedFilterPool = filterPoolManager.createSystemFilterPool("sharedFilterPool", true);
        filterStrings = new String[]{"*.java", "*.txt", "*.c"};
        ISystemFilter sharedFilter = sharedFilterPool.createSystemFilter("sharedFilter", filterStrings);
        sharedFilter.setType("sharedFilterType");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testFilterPool1() {
        if (this.isTestDisabled()) {
            return;
        }
        try {
            IRSEPersistenceProvider persistenceProvider = this.manager.getPersistenceProvider("org.eclipse.rse.persistence.PropertyFileProvider");
            ISystemFilterPoolManager fpm = this.configuration.getFilterPoolManager(this.sourceProfile);
            ISystemFilterPool fp = fpm.getSystemFilterPool("sharedFilterPool");
            RSEEnvelope envelope = new RSEEnvelope();
            envelope.add(fp);
            NullProgressMonitor monitor = new NullProgressMonitor();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            envelope.put((OutputStream)out, persistenceProvider, (IProgressMonitor)monitor);
            ISystemProfile targetProfile = this.registry.createSystemProfile("profileFilterPool1", true);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            monitor = new NullProgressMonitor();
            envelope.get((InputStream)in, (IProgressMonitor)monitor);
            envelope.mergeWith(targetProfile);
            ExportImportTest.assertEquals((int)0, (int)this.registry.getHostCount(targetProfile));
            fpm = this.configuration.getFilterPoolManager(targetProfile);
            ExportImportTest.assertNotNull((Object)fpm);
            ISystemFilterPool[] pools = fpm.getSystemFilterPools();
            ExportImportTest.assertEquals((int)1, (int)pools.length);
            fp = pools[0];
            ExportImportTest.assertNotNull((Object)fp);
            ExportImportTest.assertEquals((String)"sharedFilterPool", (String)fp.getName());
            ISystemFilter[] filters = fp.getFilters();
            ExportImportTest.assertEquals((int)1, (int)filters.length);
            ISystemFilter filter = filters[0];
            ExportImportTest.assertEquals((String)"sharedFilter", (String)filter.getName());
            ExportImportTest.assertEquals((String)"sharedFilterType", (String)filter.getType());
            String[] strings = filter.getFilterStrings();
            ExportImportTest.assertEquals((int)3, (int)strings.length);
            ExportImportTest.assertEquals((String)"*.java", (String)strings[0]);
            ExportImportTest.assertEquals((String)"*.txt", (String)strings[1]);
            ExportImportTest.assertEquals((String)"*.c", (String)strings[2]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testHost1() {
        if (this.isTestDisabled()) {
            return;
        }
        try {
            IRSEPersistenceProvider persistenceProvider = this.manager.getPersistenceProvider("org.eclipse.rse.persistence.PropertyFileProvider");
            ISystemProfile targetProfile = this.registry.createSystemProfile("profile2", true);
            IHost host1 = this.registry.getHost(this.sourceProfile, "host1");
            RSEEnvelope envelope = new RSEEnvelope();
            envelope.add(host1);
            NullProgressMonitor monitor = new NullProgressMonitor();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            envelope.put((OutputStream)out, persistenceProvider, (IProgressMonitor)monitor);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            monitor = new NullProgressMonitor();
            envelope.get((InputStream)in, (IProgressMonitor)monitor);
            envelope.mergeWith(targetProfile);
            IHost[] hosts = targetProfile.getHosts();
            ExportImportTest.assertEquals((int)1, (int)hosts.length);
            IHost host = hosts[0];
            ExportImportTest.assertEquals((String)"host1", (String)host.getAliasName());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISubSystem[] subsystems = this.registry.getSubsystems(host, (Class)clazz);
            ExportImportTest.assertEquals((int)1, (int)subsystems.length);
            ISubSystem subsystem = subsystems[0];
            ISystemFilterPool fp = subsystem.getUniqueOwningSystemFilterPool(false);
            ExportImportTest.assertNotNull((Object)fp);
            ISystemFilter[] filters = fp.getFilters();
            ExportImportTest.assertEquals((int)2, (int)filters.length);
            ISystemFilter filter = filters[0];
            ExportImportTest.assertEquals((String)"hostFilter1", (String)filter.getName());
            String[] strings = filter.getFilterStrings();
            ExportImportTest.assertEquals((int)1, (int)strings.length);
            ExportImportTest.assertEquals((String)"*.txt", (String)strings[0]);
            filter = filters[1];
            ExportImportTest.assertEquals((String)"hostFilter2", (String)filter.getName());
            strings = filter.getFilterStrings();
            ExportImportTest.assertEquals((int)1, (int)strings.length);
            ExportImportTest.assertEquals((String)"*.c", (String)strings[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testPropertySet() {
        if (this.isTestDisabled()) {
            return;
        }
    }
}

