/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.view;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.tm.internal.terminal.control.CommandInputFieldWithHistory;
import org.eclipse.tm.internal.terminal.control.ICommandInputField;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.view.ITerminalViewConnection;
import org.eclipse.tm.internal.terminal.view.SettingStorePrefixDecorator;
import org.eclipse.tm.internal.terminal.view.TerminalViewPlugin;
import org.eclipse.tm.internal.terminal.view.ViewMessages;

class TerminalViewConnection
implements ITerminalViewConnection {
    private static final String STORE_SUMMARY = "Summary";
    private static final String STORE_PART_NAME = "PartName";
    private static final String STORE_CONNECTION_TYPE = "ConnectionType";
    private static final String STORE_HAS_COMMAND_INPUT_FIELD = "HasCommandInputField";
    private static final String STORE_COMMAND_INPUT_FIELD_HISTORY = "CommandInputFieldHistory";
    private final ITerminalViewControl fCtlTerminal;
    private String fTitle;
    private String fSummary;
    private String fHistory;
    private CommandInputFieldWithHistory fCommandInputField;
    private String fPartName;

    public TerminalViewConnection(ITerminalViewControl ctl) {
        this.fCtlTerminal = ctl;
        this.fCtlTerminal.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 2) {
                    TerminalViewConnection.this.fCtlTerminal.paste();
                }
            }
        });
    }

    public String getFullSummary() {
        if (this.fTitle == null) {
            return this.makeSummary();
        }
        return this.fTitle;
    }

    public ImageDescriptor getImageDescriptor() {
        return TerminalViewPlugin.getDefault().getImageRegistry().getDescriptor("TerminalView");
    }

    public ITerminalViewControl getCtlTerminal() {
        return this.fCtlTerminal;
    }

    private ISettingsStore getStore(ISettingsStore store, ITerminalConnector connector) {
        return new SettingStorePrefixDecorator(store, String.valueOf(connector.getId()) + ".");
    }

    public void loadState(ISettingsStore store) {
        this.fPartName = store.get(STORE_PART_NAME);
        this.fSummary = store.get(STORE_SUMMARY);
        this.fHistory = store.get(STORE_COMMAND_INPUT_FIELD_HISTORY);
        ITerminalConnector[] connectors = this.fCtlTerminal.getConnectors();
        String connectionType = store.get(STORE_CONNECTION_TYPE);
        int i = 0;
        while (i < connectors.length) {
            connectors[i].load(this.getStore(store, connectors[i]));
            if (connectors[i].getId().equals(connectionType)) {
                this.fCtlTerminal.setConnector(connectors[i]);
            }
            ++i;
        }
        if ("true".equals(store.get(STORE_HAS_COMMAND_INPUT_FIELD))) {
            this.setCommandInputField(true);
        }
    }

    public void saveState(ISettingsStore store) {
        store.put(STORE_PART_NAME, this.fPartName);
        store.put(STORE_SUMMARY, this.fSummary);
        store.put(STORE_COMMAND_INPUT_FIELD_HISTORY, this.fHistory);
        if (this.fCommandInputField != null) {
            store.put(STORE_COMMAND_INPUT_FIELD_HISTORY, this.fCommandInputField.getHistory());
        } else {
            store.put(STORE_COMMAND_INPUT_FIELD_HISTORY, this.fHistory);
        }
        store.put(STORE_HAS_COMMAND_INPUT_FIELD, this.hasCommandInputField() ? "true" : "false");
        ITerminalConnector[] connectors = this.fCtlTerminal.getConnectors();
        int i = 0;
        while (i < connectors.length) {
            connectors[i].save(this.getStore(store, connectors[i]));
            ++i;
        }
        if (this.fCtlTerminal.getTerminalConnector() != null) {
            store.put(STORE_CONNECTION_TYPE, this.fCtlTerminal.getTerminalConnector().getId());
        }
    }

    public boolean hasCommandInputField() {
        return this.fCommandInputField != null;
    }

    public void setCommandInputField(boolean on) {
        if (this.fCommandInputField != null) {
            this.fHistory = this.fCommandInputField.getHistory();
            this.fCommandInputField = null;
        }
        if (on) {
            this.fCommandInputField = new CommandInputFieldWithHistory(100);
            this.fCommandInputField.setHistory(this.fHistory);
        }
        this.fCtlTerminal.setCommandInputField((ICommandInputField)this.fCommandInputField);
    }

    public void setState(TerminalState state) {
        this.fTitle = null;
    }

    public void setTerminalTitle(String title) {
        this.fTitle = title;
    }

    private String getStateDisplayName(TerminalState state) {
        if (state == TerminalState.CONNECTED) {
            return ViewMessages.STATE_CONNECTED;
        }
        if (state == TerminalState.CONNECTING) {
            return ViewMessages.STATE_CONNECTING;
        }
        if (state == TerminalState.CLOSED) {
            return ViewMessages.STATE_CLOSED;
        }
        throw new IllegalStateException(state.toString());
    }

    private String makeSummary() {
        String strTitle = "";
        if (this.fCtlTerminal.getTerminalConnector() == null) {
            strTitle = ViewMessages.NO_CONNECTION_SELECTED;
        } else {
            String name;
            String strConnected = this.getStateDisplayName(this.fCtlTerminal.getState());
            String summary = this.getSettingsSummary();
            if (summary.length() > 0) {
                summary = String.valueOf(summary) + " - ";
            }
            if ((name = this.fCtlTerminal.getTerminalConnector().getName()).length() > 0) {
                name = String.valueOf(name) + ": ";
            }
            strTitle = String.valueOf(name) + "(" + summary + strConnected + ")";
        }
        return strTitle;
    }

    private String getSettingsSummary() {
        if (this.fCtlTerminal.getTerminalConnector().isInitialized()) {
            this.fSummary = this.fCtlTerminal.getSettingsSummary();
        }
        if (this.fSummary == null) {
            return "";
        }
        return this.fSummary;
    }

    public void setSummary(String summary) {
        this.fSummary = summary;
    }

    public String getPartName() {
        return this.fPartName == null ? ViewMessages.PROP_TITLE : this.fPartName;
    }

    public void setPartName(String name) {
        this.fPartName = name;
    }
}

