/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.p2.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cbi.p2repo.p2.InstallableUnit;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionedId;

public class IUUtils {
    private static final Pattern proxyFragmentPattern = Pattern.compile("^.*/@installableUnits\\[id='([^']*)',version='([^']*)'\\]$");

    public static String encodeFilterValue(String value) {
        boolean encoded = false;
        int inlen = value.length();
        int outlen = inlen << 1;
        char[] output = new char[outlen];
        value.getChars(0, inlen, output, inlen);
        int cursor = 0;
        int i = inlen;
        while (i < outlen) {
            char c = output[i];
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '\\': {
                    output[cursor] = 92;
                    ++cursor;
                    encoded = true;
                }
            }
            output[cursor] = c;
            ++cursor;
            ++i;
        }
        return encoded ? new String(output, 0, cursor) : value;
    }

    public static VersionedId getVersionedName(InstallableUnit iu) {
        if (((EObject)iu).eIsProxy()) {
            return IUUtils.getVersionedNameFromProxy(iu);
        }
        return new VersionedId(iu.getId(), iu.getVersion());
    }

    public static VersionedId getVersionedNameFromProxy(InstallableUnit iu) {
        return IUUtils.getVersionedNameFromProxy((InternalEObject)iu);
    }

    public static VersionedId getVersionedNameFromProxy(InternalEObject iu) {
        URI uri = iu.eProxyURI();
        if (uri == null) {
            return null;
        }
        String frag = uri.fragment();
        if (frag == null) {
            return null;
        }
        Matcher m = proxyFragmentPattern.matcher(frag);
        try {
            return m.matches() ? new VersionedId(URLDecoder.decode(m.group(1), "UTF-8"), m.group(2)) : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String stringifyVersion(Version version) {
        String result = version.getOriginal();
        if (result == null) {
            result = version.toString();
        }
        return result;
    }
}

