/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.util;

import java.util.Collection;
import java.util.Iterator;

public class FilteringCollection<E>
implements Collection<E> {
    protected Collection<E> delegate;

    protected FilteringCollection() {
    }

    public FilteringCollection(Collection<E> delegate) {
        this.setDelegate(delegate);
    }

    @Override
    public boolean add(E e) {
        return this.delegate.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = false;
        for (E e : c) {
            if (!this.delegate.add(e) || result) continue;
            result = true;
        }
        return result;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    public FilteringCollection<E> setDelegate(Collection<E> delegate) {
        if (this.delegate != null) {
            throw new IllegalStateException();
        }
        if (delegate == null) {
            throw new NullPointerException();
        }
        this.delegate = delegate;
        return this;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }
}

