/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.cbi.p2repo.aggregator.Contribution;
import org.eclipse.cbi.p2repo.aggregator.MappedRepository;
import org.eclipse.cbi.p2repo.aggregator.MappedUnit;
import org.eclipse.cbi.p2repo.aggregator.provider.AggregatorEditPlugin;
import org.eclipse.cbi.p2repo.aggregator.util.ItemUtils;
import org.eclipse.cbi.p2repo.p2.MetadataRepository;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.DragAndDropFeedback;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class AddIUsToContributionCommand
extends AbstractCommand
implements DragAndDropFeedback {
    private Contribution contribution;
    private List<MetadataRepository> selectedMDRs;
    private List<IInstallableUnit> selectedIUs;
    private List<MappedRepository> addedMappedRepos = new ArrayList<MappedRepository>();
    private List<MappedUnit> addedMappedUnits = new ArrayList<MappedUnit>();

    public AddIUsToContributionCommand(Contribution contribution, List<MetadataRepository> selectedMDRs, List<IInstallableUnit> selectedIUs) {
        super(String.valueOf(AggregatorEditPlugin.INSTANCE.getString("_UI_Map_to_command_prefix")) + " " + (contribution.getLabel() == null || contribution.getLabel().length() == 0 ? String.valueOf(AggregatorEditPlugin.INSTANCE.getString("_UI_Contribution_type")) + " ''" : String.valueOf(AggregatorEditPlugin.INSTANCE.getString("_UI_Contribution_type")) + " " + contribution.getLabel()));
        this.contribution = contribution;
        this.selectedMDRs = selectedMDRs;
        this.selectedIUs = selectedIUs;
    }

    public void execute() {
        this.addedMappedRepos.clear();
        this.addedMappedUnits.clear();
        for (MetadataRepository mdr : this.selectedMDRs) {
            MappedRepository newMappedRepo = ItemUtils.addMDR(this.contribution, mdr);
            if (newMappedRepo == null) continue;
            this.addedMappedRepos.add(newMappedRepo);
        }
        for (IInstallableUnit iu : this.selectedIUs) {
            MappedUnit newMU;
            MappedRepository newMappedRepo;
            if (!(((EObject)iu).eContainer() instanceof MetadataRepository)) {
                return;
            }
            MetadataRepository mdr = (MetadataRepository)((EObject)iu).eContainer();
            MappedRepository mappedRepo = ItemUtils.findMappedRepository(this.contribution, mdr);
            if (mappedRepo == null && (newMappedRepo = ItemUtils.addMDR(this.contribution, mdr)) != null) {
                this.addedMappedRepos.add(newMappedRepo);
                mappedRepo = newMappedRepo;
            }
            if ((newMU = ItemUtils.addIU(mappedRepo, iu)) == null) continue;
            this.addedMappedUnits.add(newMU);
        }
    }

    public int getFeedback() {
        return 1;
    }

    public int getOperation() {
        return 4;
    }

    protected boolean prepare() {
        boolean result;
        boolean bl = result = this.contribution != null && this.contribution.isBranchEnabled() && (this.selectedMDRs != null && this.selectedMDRs.size() > 0 || this.selectedIUs != null && this.selectedIUs.size() > 0);
        if (result) {
            for (IInstallableUnit iu : this.selectedIUs) {
                if (!(((EObject)iu).eContainer() instanceof MetadataRepository)) {
                    return false;
                }
                MetadataRepository mdr = (MetadataRepository)((EObject)iu).eContainer();
                MappedRepository mappedRepo = ItemUtils.findMappedRepository(this.contribution, mdr);
                if (mappedRepo == null || ItemUtils.findMappedUnit(mappedRepo, iu) == null && ItemUtils.findMapRule(mappedRepo, iu) == null) continue;
                return false;
            }
        }
        return result;
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        for (MappedUnit unit : this.addedMappedUnits) {
            MappedRepository repo = (MappedRepository)((EObject)unit).eContainer();
            repo.removeUnit(unit);
        }
        this.contribution.getRepositories().removeAll(this.addedMappedRepos);
    }

    public boolean validate(Object owner, float location, int operations, int operation, Collection<?> collection) {
        return true;
    }
}

