/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.filesystem;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class JDTLSFilesystemActivator
implements BundleActivator {
    private static BundleContext context;
    private static final String JAVA_LS_PLUGIN_ID = "org.eclipse.jdt.ls.core";
    private static final String JAVA_RESOURCE_FILTERS = "java.project.resourceFilters";
    private static final String JAVA_RESOURCE_FILTERS_DEFAULT = "node_modules::\\.git";
    private List<Pattern> resourcePatterns;
    private String resourceFilters;
    private static JDTLSFilesystemActivator instance;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        instance = this;
        this.configureResourceFilters();
    }

    private void configureResourceFilters() {
        IEclipsePreferences eclipsePreferences = InstanceScope.INSTANCE.getNode(JAVA_LS_PLUGIN_ID);
        if (eclipsePreferences != null) {
            this.resourceFilters = eclipsePreferences.get(JAVA_RESOURCE_FILTERS, JAVA_RESOURCE_FILTERS_DEFAULT);
            eclipsePreferences.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

                public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                    Object object = event.getNewValue();
                    if (object instanceof String) {
                        String newValue = (String)object;
                        if (Objects.equals(JDTLSFilesystemActivator.JAVA_RESOURCE_FILTERS, event.getKey()) && !Objects.equals(JDTLSFilesystemActivator.this.resourceFilters, event.getNewValue())) {
                            JDTLSFilesystemActivator.this.resourceFilters = newValue;
                            JDTLSFilesystemActivator.this.setResourcePatterns();
                        }
                    }
                }
            });
        } else {
            this.resourceFilters = JAVA_RESOURCE_FILTERS_DEFAULT;
        }
        this.setResourcePatterns();
    }

    protected void setResourcePatterns() {
        this.resourcePatterns = new ArrayList<Pattern>();
        String[] stringArray = this.resourceFilters.split("::");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            Pattern pattern = Pattern.compile(element);
            this.resourcePatterns.add(pattern);
            ++n2;
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }

    public static List<Pattern> getResourcePatterns() {
        if (instance != null) {
            return JDTLSFilesystemActivator.instance.resourcePatterns;
        }
        return null;
    }
}

