/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.template.java;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.internal.ui.text.template.contentassist.MultiVariable;
import org.eclipse.jdt.ls.core.internal.corext.template.java.VariablePosition;

public class MultiVariableGuess {
    private final Map<MultiVariable, Set<MultiVariable>> fDependencies = new HashMap<MultiVariable, Set<MultiVariable>>();
    private final Map<MultiVariable, MultiVariable> fBackwardDeps = new HashMap<MultiVariable, MultiVariable>();
    private final Map<MultiVariable, VariablePosition> fPositions = new HashMap<MultiVariable, VariablePosition>();

    public void addDependent(VariablePosition position) {
        this.fPositions.put(position.getVariable(), position);
    }

    public void addDependency(MultiVariable main, MultiVariable dependent) {
        if (this.fBackwardDeps.containsKey(dependent)) {
            throw new IllegalArgumentException("dependent can only have a single main variable");
        }
        MultiVariable parent = main;
        while (parent != null) {
            if ((parent = this.fBackwardDeps.get(parent)) != dependent) continue;
            throw new IllegalArgumentException("cycle detected");
        }
        Set<MultiVariable> dependents = this.fDependencies.get(main);
        if (dependents == null) {
            dependents = new HashSet<MultiVariable>();
            this.fDependencies.put(main, dependents);
        }
        this.fBackwardDeps.put(dependent, main);
        dependents.add(dependent);
    }
}

