/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdtls.ext.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.microsoft.jdtls.ext.core.ExtUtils;
import com.microsoft.jdtls.ext.core.JdtlsExtActivator;
import com.microsoft.jdtls.ext.core.PackageParams;
import com.microsoft.jdtls.ext.core.model.NodeKind;
import com.microsoft.jdtls.ext.core.model.PackageNode;
import com.microsoft.jdtls.ext.core.model.PackageRootNode;
import com.microsoft.jdtls.ext.core.model.Trie;
import com.microsoft.jdtls.ext.core.model.TrieNode;
import com.microsoft.jdtls.ext.core.parser.JavaResourceVisitor;
import com.microsoft.jdtls.ext.core.parser.ResourceSet;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarEntryDirectory;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.core.JarEntryResource;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.lsp4j.jsonrpc.json.adapters.CollectionTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EnumTypeAdapter;

public class PackageCommand {
    private static final Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new CollectionTypeAdapter.Factory()).registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapter.Factory()).create();
    private static final Map<NodeKind, BiFunction<PackageParams, IProgressMonitor, List<PackageNode>>> commands = new EnumMap<NodeKind, BiFunction<PackageParams, IProgressMonitor, List<PackageNode>>>(NodeKind.class);

    static {
        commands.put(NodeKind.PROJECT, PackageCommand::getProjectChildren);
        commands.put(NodeKind.CONTAINER, PackageCommand::getContainerChildren);
        commands.put(NodeKind.PACKAGEROOT, PackageCommand::getPackageRootChildren);
        commands.put(NodeKind.PACKAGE, PackageCommand::getPackageChildren);
        commands.put(NodeKind.FOLDER, PackageCommand::getFolderChildren);
    }

    public static List<PackageNode> getChildren(List<Object> arguments, IProgressMonitor pm) throws CoreException {
        if (arguments == null || arguments.size() < 1) {
            throw new IllegalArgumentException("Should have at least one argument for getChildren");
        }
        PackageParams params = (PackageParams)gson.fromJson(gson.toJson(arguments.get(0)), PackageParams.class);
        BiFunction<PackageParams, IProgressMonitor, List<PackageNode>> loader = commands.get((Object)params.getKind());
        if (loader == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdtls.ext.core", String.format("Unknown classpath item type: %s", new Object[]{params.getKind()})));
        }
        List<PackageNode> result = loader.apply(params, pm);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<PackageNode> resolvePath(List<Object> arguments, IProgressMonitor pm) throws CoreException {
        IClassFile typeRoot;
        if (arguments == null || arguments.size() < 1) {
            throw new IllegalArgumentException("Should have one argument for resolvePath");
        }
        String typeRootUri = (String)arguments.get(0);
        ArrayList<PackageNode> result = new ArrayList<PackageNode>();
        URI uri = JDTUtils.toURI((String)typeRootUri);
        Object object = typeRoot = "jdt".equals(uri.getScheme()) ? JDTUtils.resolveClassFile((URI)uri) : JDTUtils.resolveCompilationUnit((URI)uri);
        if (typeRoot != null && typeRoot.findPrimaryType() != null) {
            PackageRootNode pkgRootNode;
            result.add(PackageNode.createNodeForProject((IJavaElement)typeRoot));
            IPackageFragment packageFragment = (IPackageFragment)typeRoot.getAncestor(4);
            if (!packageFragment.exists()) {
                return Collections.emptyList();
            }
            IPackageFragmentRoot pkgRoot = (IPackageFragmentRoot)packageFragment.getAncestor(3);
            boolean isClassFile = typeRoot instanceof IClassFile;
            if (isClassFile) {
                result.add(PackageNode.createNodeForVirtualContainer(pkgRoot));
            }
            if (StringUtils.isNotBlank((CharSequence)(pkgRootNode = PackageNode.createNodeForPackageFragmentRoot(pkgRoot)).getName())) {
                result.add(pkgRootNode);
            }
            if (!packageFragment.isDefaultPackage()) {
                result.add(PackageNode.createNodeForPackageFragment(packageFragment));
            }
            result.add(PackageNode.createNodeForPrimaryType(typeRoot.findPrimaryType()));
            return result;
        } else if (ExtUtils.isJarResourceUri(uri)) {
            IJarEntryResource resource = ExtUtils.getJarEntryResource(uri);
            IPackageFragmentRoot pkgRoot = resource.getPackageFragmentRoot();
            result.add(PackageNode.createNodeForProject((IJavaElement)pkgRoot));
            result.add(PackageNode.createNodeForVirtualContainer(resource.getPackageFragmentRoot()));
            result.add(PackageNode.createNodeForPackageFragmentRoot(pkgRoot));
            if (resource.getParent() instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)resource.getParent();
                if (!packageFragment.isDefaultPackage()) {
                    result.add(PackageNode.createNodeForPackageFragment(packageFragment));
                }
            } else {
                int currentSize = result.size();
                Object currentNode = resource.getParent();
                while (currentNode instanceof JarEntryDirectory) {
                    JarEntryDirectory jarEntryDirectory = (JarEntryDirectory)currentNode;
                    PackageNode jarNode = PackageCommand.getJarEntryResource((JarEntryResource)jarEntryDirectory);
                    if (jarNode != null) {
                        result.add(currentSize, jarNode);
                    }
                    currentNode = jarEntryDirectory.getParent();
                }
            }
            PackageNode item = new PackageNode(resource.getName(), resource.getFullPath().toPortableString(), NodeKind.FILE);
            item.setUri(ExtUtils.toUri(resource));
            result.add(item);
            return result;
        } else {
            IResource resource = JDTUtils.findResource((URI)uri, arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).findFilesForLocationURI(arg_0));
            if (resource != null) {
                IContainer parent = resource.getParent();
                IJavaElement parentJavaElement = JavaCore.create((IResource)parent);
                if (!(parent instanceof IFolder) || !(parentJavaElement instanceof IPackageFragment)) return PackageCommand.getParentAncestorNodes(resource);
                IPackageFragment packageFragment = (IPackageFragment)parentJavaElement;
                result.add(PackageNode.createNodeForProject((IJavaElement)packageFragment));
                IPackageFragmentRoot pkgRoot = (IPackageFragmentRoot)packageFragment.getAncestor(3);
                PackageRootNode pkgRootNode = PackageNode.createNodeForPackageFragmentRoot(pkgRoot);
                if (StringUtils.isNotBlank((CharSequence)pkgRootNode.getName())) {
                    result.add(pkgRootNode);
                }
                if (!packageFragment.isDefaultPackage()) {
                    result.add(PackageNode.createNodeForPackageFragment(packageFragment));
                }
                PackageNode item = new PackageNode(resource.getName(), resource.getFullPath().toPortableString(), NodeKind.FILE);
                item.setUri(JDTUtils.getFileURI((IResource)resource));
                result.add(item);
                return result;
            } else {
                IContainer container = JDTUtils.findFolder((String)typeRootUri);
                IJavaElement element = JavaCore.create((IResource)container);
                result.add(PackageNode.createNodeForProject(element));
            }
        }
        return result;
    }

    private static List<PackageNode> getParentAncestorNodes(IResource element) throws JavaModelException {
        LinkedList<PackageNode> nodeList = new LinkedList<PackageNode>();
        while (element != null && !(element instanceof IWorkspaceRoot)) {
            IJavaElement javaElement = JavaCore.create((IResource)element);
            if (javaElement instanceof IJavaProject) {
                nodeList.add(0, PackageNode.createNodeForProject(javaElement));
            } else {
                PackageNode entry;
                if (javaElement instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot pkgRoot = (IPackageFragmentRoot)javaElement;
                    nodeList.add(0, new PackageRootNode(pkgRoot, element.getProjectRelativePath().toPortableString(), NodeKind.PACKAGEROOT));
                    nodeList.add(0, PackageNode.createNodeForProject(javaElement));
                    return nodeList;
                }
                if (javaElement instanceof IPackageFragment) {
                    IPackageFragment packageFragment = (IPackageFragment)javaElement;
                    if (packageFragment.containsJavaResources() || packageFragment.getNonJavaResources().length > 0) {
                        nodeList.add(0, PackageNode.createNodeForPackageFragment(packageFragment));
                    }
                } else if (javaElement == null && (entry = PackageNode.createNodeForResource(element)) != null) {
                    nodeList.add(0, entry);
                }
            }
            element = element.getParent();
        }
        return nodeList;
    }

    private static List<PackageNode> getProjectChildren(PackageParams query, IProgressMonitor pm) {
        IProject project = PackageCommand.getProject(query.getProjectUri());
        if (project == null) {
            JdtlsExtActivator.logError("Failed to find project at: " + query.getProjectUri());
        }
        LinkedList<Object> children = new LinkedList<Object>();
        boolean hasReferencedLibraries = false;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            if (ProjectUtils.isJavaProject((IProject)project) && javaProject != null) {
                IClasspathEntry[] references;
                PackageCommand.refreshLocal((IResource)javaProject.getProject(), pm);
                IClasspathEntry[] iClasspathEntryArray = references = javaProject.getRawClasspath();
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    int entryKind = entry.getEntryKind();
                    if (entryKind == 3) {
                        Collections.addAll(children, javaProject.findPackageFragmentRoots(entry));
                    } else if (entryKind == 5) {
                        children.add(entry);
                    } else if (entry.getEntryKind() == 1 || entry.getEntryKind() == 4) {
                        hasReferencedLibraries = true;
                    }
                    ++n2;
                }
                Collections.addAll(children, javaProject.getNonJavaResources());
            } else {
                IResource[] members;
                Set projectPaths = Arrays.stream(ProjectUtils.getAllProjects()).map(IResource::getLocation).collect(Collectors.toSet());
                IResource[] iResourceArray = members = project.members();
                int n = members.length;
                int n3 = 0;
                while (n3 < n) {
                    IResource member = iResourceArray[n3];
                    if (!projectPaths.contains(member.getLocation())) {
                        children.add(member);
                    }
                    ++n3;
                }
            }
        }
        catch (CoreException e) {
            JdtlsExtActivator.logException("Problem load project library ", e);
        }
        ResourceSet resourceSet = new ResourceSet(children);
        JavaResourceVisitor visitor = new JavaResourceVisitor(javaProject);
        resourceSet.accept(visitor);
        List<PackageNode> result = visitor.getNodes();
        if (!ProjectUtils.isVisibleProject((IProject)project) || hasReferencedLibraries) {
            result.add(PackageNode.REFERENCED_LIBRARIES_CONTAINER);
        }
        return result;
    }

    private static List<PackageNode> getContainerChildren(PackageParams query, IProgressMonitor pm) {
        IJavaProject javaProject = PackageCommand.getJavaProject(query.getProjectUri());
        if (javaProject == null) {
            return Collections.emptyList();
        }
        LinkedList<Object> children = new LinkedList<Object>();
        try {
            IClasspathEntry[] references = javaProject.getRawClasspath();
            if (query.getPath().equals("REFERENCED_LIBRARIES_PATH")) {
                children.addAll(Arrays.stream(references).filter(entry -> entry.getEntryKind() == 1 || entry.getEntryKind() == 4).collect(Collectors.toList()));
            } else {
                IPackageFragmentRoot[] packageFragmentRoots = PackageCommand.findPackageFragmentRoots(javaProject, query);
                if (packageFragmentRoots == null) {
                    return Collections.emptyList();
                }
                IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRoots;
                int n = packageFragmentRoots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot fragmentRoot = iPackageFragmentRootArray[n2];
                    children.add(fragmentRoot);
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            JdtlsExtActivator.logException("Problem load project JAR entries ", e);
        }
        ResourceSet resourceSet = new ResourceSet(children);
        JavaResourceVisitor visitor = new JavaResourceVisitor(javaProject);
        resourceSet.accept(visitor);
        return visitor.getNodes();
    }

    private static IPackageFragmentRoot[] findPackageFragmentRoots(IJavaProject javaProject, PackageParams query) {
        try {
            IClasspathEntry[] references = javaProject.getRawClasspath();
            IClasspathEntry containerEntry = null;
            IClasspathEntry[] iClasspathEntryArray = references;
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry reference = iClasspathEntryArray[n2];
                if (reference.getPath().equals((Object)Path.fromPortableString((String)query.getPath()))) {
                    containerEntry = reference;
                    break;
                }
                ++n2;
            }
            if (containerEntry != null) {
                return javaProject.findPackageFragmentRoots(containerEntry);
            }
        }
        catch (CoreException e) {
            JdtlsExtActivator.log(e);
        }
        return null;
    }

    private static List<PackageNode> getPackageRootChildren(PackageParams query, IProgressMonitor pm) {
        try {
            IPackageFragmentRoot packageRoot = PackageCommand.getPackageFragmentRootFromQuery(query);
            if (packageRoot == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdtls.ext.core", String.format("No package root found for %s", query.getPath())));
            }
            List<Object> result = PackageCommand.getPackageFragmentRootContent(packageRoot, query.isHierarchicalView(), pm);
            ResourceSet resourceSet = new ResourceSet(result, query.isHierarchicalView());
            JavaResourceVisitor visitor = new JavaResourceVisitor(packageRoot.getJavaProject());
            resourceSet.accept(visitor);
            return visitor.getNodes();
        }
        catch (CoreException e) {
            JdtlsExtActivator.logException("Problem load project package ", e);
            return Collections.emptyList();
        }
    }

    private static IPackageFragmentRoot getPackageFragmentRootFromQuery(PackageParams query) {
        IJavaProject javaProject;
        IPackageFragmentRoot packageRoot = (IPackageFragmentRoot)JavaCore.create((String)query.getHandlerIdentifier());
        if (packageRoot != null) {
            return packageRoot;
        }
        if (query.getProjectUri() != null && query.getRootPath() != null && (javaProject = PackageCommand.getJavaProject(query.getProjectUri())) != null) {
            try {
                return javaProject.findPackageFragmentRoot(Path.fromPortableString((String)query.getRootPath()));
            }
            catch (JavaModelException e) {
                JdtlsExtActivator.log((CoreException)((Object)e));
            }
        }
        return null;
    }

    private static List<PackageNode> getPackageChildren(PackageParams query, IProgressMonitor pm) {
        IPackageFragment packageFragment = (IPackageFragment)JavaCore.create((String)query.getHandlerIdentifier());
        List<Object> children = PackageCommand.getChildrenForPackage(packageFragment, pm);
        ResourceSet resourceSet = new ResourceSet(children);
        JavaResourceVisitor visitor = new JavaResourceVisitor(packageFragment.getJavaProject());
        resourceSet.accept(visitor);
        return visitor.getNodes();
    }

    public static List<Object> getChildrenForPackage(IPackageFragment packageFragment, IProgressMonitor pm) {
        if (packageFragment == null) {
            return Collections.emptyList();
        }
        PackageCommand.refreshLocal(packageFragment.getResource(), pm);
        LinkedList<Object> children = new LinkedList<Object>();
        try {
            IJavaElement[] iJavaElementArray = packageFragment.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement element = iJavaElementArray[n2];
                if (!(!(element instanceof ITypeRoot) || element instanceof IClassFile && element.getElementName().contains("$"))) {
                    IType primaryType = ((ITypeRoot)element).findPrimaryType();
                    if (primaryType != null) {
                        children.add(primaryType);
                    } else {
                        children.add(element);
                    }
                }
                ++n2;
            }
            Collections.addAll(children, packageFragment.getNonJavaResources());
        }
        catch (JavaModelException e) {
            JdtlsExtActivator.log((CoreException)((Object)e));
        }
        return children;
    }

    private static List<PackageNode> getFolderChildren(PackageParams query, IProgressMonitor pm) {
        LinkedList<Object> children = new LinkedList<Object>();
        IJavaProject javaProject = null;
        try {
            IFolder folder;
            IPackageFragmentRoot packageRoot = PackageCommand.getPackageFragmentRootFromQuery(query);
            if (packageRoot != null) {
                if (packageRoot.getKind() == 2) {
                    Object[] resources;
                    Object[] objectArray = resources = packageRoot.getNonJavaResources();
                    int n = resources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object resource = objectArray[n2];
                        if (pm.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        if (resource instanceof JarEntryDirectory) {
                            JarEntryDirectory directory = (JarEntryDirectory)resource;
                            Object[] directoryChildren = PackageCommand.findJarDirectoryChildren(directory, query.getPath());
                            if (children != null) {
                                children.addAll(Arrays.asList(directoryChildren));
                            }
                        }
                        ++n2;
                    }
                } else {
                    javaProject = packageRoot.getJavaProject();
                    folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(Path.fromPortableString((String)query.getPath()));
                    if (folder.exists()) {
                        boolean isJavaElement = JavaCore.create((IFolder)folder) != null;
                        children.addAll(Arrays.stream(folder.members()).filter(f -> isJavaElement ? f instanceof IFile : true).collect(Collectors.toList()));
                    }
                }
            } else {
                folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(Path.fromPortableString((String)query.getPath()));
                if (folder.exists()) {
                    PackageCommand.refreshLocal((IResource)folder, pm);
                    children.addAll(Arrays.asList(folder.members()));
                    javaProject = JavaCore.create((IProject)folder.getProject());
                }
            }
            ResourceSet resourceSet = new ResourceSet(children);
            JavaResourceVisitor visitor = new JavaResourceVisitor(javaProject);
            resourceSet.accept(visitor);
            return visitor.getNodes();
        }
        catch (CoreException e) {
            JdtlsExtActivator.logException("Problem load project classfile list ", e);
            return Collections.emptyList();
        }
    }

    public static List<Object> getPackageFragmentRootContent(IPackageFragmentRoot root, boolean isHierarchicalView, IProgressMonitor pm) throws CoreException {
        ArrayList<Object> result = new ArrayList<Object>();
        PackageCommand.refreshLocal(root.getResource(), pm);
        if (isHierarchicalView) {
            HashMap<String, IJavaElement> map = new HashMap<String, IJavaElement>();
            IJavaElement[] iJavaElementArray = root.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                map.put(child.getElementName(), child);
                ++n2;
            }
            Trie trie = new Trie(map);
            for (TrieNode node : trie.getAllNodes()) {
                IPackageFragment fragment;
                if (node.value == null || !(fragment = (IPackageFragment)node.value).hasChildren() && fragment.getNonJavaResources().length <= 0 && fragment.hasSubpackages() && node.children.size() <= 1) continue;
                result.add(fragment);
            }
        } else {
            IJavaElement[] iJavaElementArray = root.getChildren();
            int n = iJavaElementArray.length;
            int n3 = 0;
            while (n3 < n) {
                IJavaElement child = iJavaElementArray[n3];
                IPackageFragment fragment = (IPackageFragment)child;
                if (fragment.hasChildren() || fragment.getNonJavaResources().length > 0 || !fragment.hasSubpackages()) {
                    result.add(fragment);
                }
                ++n3;
            }
        }
        Object[] nonJavaResources = root.getNonJavaResources();
        Collections.addAll(result, nonJavaResources);
        return result;
    }

    private static PackageNode getJarEntryResource(JarEntryResource resource) {
        if (resource instanceof JarEntryDirectory) {
            return new PackageNode(resource.getName(), resource.getFullPath().toPortableString(), NodeKind.FOLDER);
        }
        if (resource instanceof JarEntryFile) {
            PackageNode entry = new PackageNode(resource.getName(), resource.getFullPath().toPortableString(), NodeKind.FILE);
            entry.setUri(ExtUtils.toUri((IJarEntryResource)resource));
            return entry;
        }
        return null;
    }

    private static Object[] findJarDirectoryChildren(JarEntryDirectory directory, String path) {
        String directoryPath = directory.getFullPath().toPortableString();
        if (directoryPath.equals(path)) {
            return directory.getChildren();
        }
        if (path.startsWith(directoryPath)) {
            IJarEntryResource[] iJarEntryResourceArray = directory.getChildren();
            int n = iJarEntryResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] result;
                IJarEntryResource resource = iJarEntryResourceArray[n2];
                String childrenPath = resource.getFullPath().toPortableString();
                if (childrenPath.equals(path)) {
                    return resource.getChildren();
                }
                if (path.startsWith(childrenPath) && resource instanceof JarEntryDirectory && (result = PackageCommand.findJarDirectoryChildren((JarEntryDirectory)resource, path)) != null) {
                    return result;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IProject getProject(String projectUri) {
        URI uri;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer[] containers = root.findContainersForLocationURI(uri = JDTUtils.toURI((String)projectUri));
        Optional<IContainer> maybeProject = Arrays.stream(containers).filter(container -> container instanceof IProject).findFirst();
        if (maybeProject.isPresent()) {
            return (IProject)maybeProject.get();
        }
        if (containers.length == 0) {
            throw new IllegalArgumentException(String.format("Did not find container for URI  %s", projectUri));
        }
        return containers[0].getProject();
    }

    public static IJavaProject getJavaProject(String projectUri) {
        IProject project = PackageCommand.getProject(projectUri);
        return JavaCore.create((IProject)project);
    }

    private static void refreshLocal(IResource resource, IProgressMonitor monitor) {
        if (resource == null || !resource.exists()) {
            return;
        }
        try {
            resource.refreshLocal(1, monitor);
        }
        catch (CoreException e) {
            JdtlsExtActivator.log(e);
        }
    }
}

