/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.text.edits.TextEditGroup;

public class UnwrapNewArrayOperation
extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
    private final ArrayCreation node;
    private final Expression call;

    public UnwrapNewArrayOperation(ArrayCreation node, Expression call) {
        this.node = node;
        this.call = call;
    }

    @Override
    public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        List expressionsInArray = this.node != null && this.node.getInitializer() != null && this.node.getInitializer().expressions() != null ? this.node.getInitializer().expressions() : Collections.EMPTY_LIST;
        boolean[] isTagged = new boolean[expressionsInArray.size()];
        ICompilationUnit cu = cuRewrite.getCu();
        boolean tagged = false;
        int i = 0;
        while (i < expressionsInArray.size()) {
            Expression operand = (Expression)expressionsInArray.get(i);
            NLSLine nlsLine = NLSUtil.scanCurrentLine(cu, operand.getStartPosition());
            if (nlsLine != null) {
                NLSElement[] nLSElementArray = nlsLine.getElements();
                int n = nLSElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NLSElement element = nLSElementArray[n2];
                    if (element.getPosition().getOffset() == operand.getStartPosition() && element.hasTag()) {
                        tagged = true;
                        isTagged[i] = true;
                    }
                    ++n2;
                }
            }
            ++i;
        }
        TextEditGroup group = this.createTextEditGroup(FixMessages.UnusedCodeFix_RemoveUnnecessaryArrayCreation_description, cuRewrite);
        if (!tagged) {
            ListRewrite listRewrite;
            if (this.call instanceof ClassInstanceCreation) {
                listRewrite = rewrite.getListRewrite((ASTNode)this.call, ClassInstanceCreation.ARGUMENTS_PROPERTY);
            } else if (this.call instanceof MethodInvocation) {
                listRewrite = rewrite.getListRewrite((ASTNode)this.call, MethodInvocation.ARGUMENTS_PROPERTY);
            } else if (this.call instanceof SuperMethodInvocation) {
                listRewrite = rewrite.getListRewrite((ASTNode)this.call, SuperMethodInvocation.ARGUMENTS_PROPERTY);
            } else {
                return;
            }
            if (this.node.getInitializer() != null && this.node.getInitializer().expressions() != null) {
                int i2 = 1;
                while (i2 < expressionsInArray.size()) {
                    listRewrite.insertLast((ASTNode)ASTNodes.createMoveTarget(rewrite, (Expression)expressionsInArray.get(i2)), group);
                    ++i2;
                }
                if (expressionsInArray.isEmpty()) {
                    listRewrite.remove((ASTNode)this.node, group);
                } else {
                    listRewrite.replace((ASTNode)this.node, (ASTNode)ASTNodes.createMoveTarget(rewrite, (Expression)expressionsInArray.get(0)), group);
                }
            } else {
                listRewrite.remove((ASTNode)this.node, group);
            }
        } else {
            StringBuilder buf = new StringBuilder();
            CompilationUnit comp = (CompilationUnit)this.call.getRoot();
            int nodeStart = comp.getExtendedStartPosition((ASTNode)this.call);
            int nodeEnd = comp.getExtendedStartPosition((ASTNode)this.call) + comp.getExtendedLength((ASTNode)this.call);
            int arrayStart = this.node.getStartPosition();
            List expressionList = this.node.getInitializer().expressions();
            int arrayExpressionStart = ((Expression)expressionList.get(0)).getStartPosition();
            Expression lastExpression = (Expression)expressionList.get(expressionList.size() - 1);
            int arrayExpressionEnd = lastExpression.getStartPosition() + lastExpression.getLength();
            int arrayInitializerEnd = this.node.getInitializer().getStartPosition() + this.node.getInitializer().getLength();
            buf.append(cu.getBuffer().getText(nodeStart, arrayStart - nodeStart));
            buf.append(cu.getBuffer().getText(arrayExpressionStart, arrayExpressionEnd - arrayExpressionStart));
            buf.append(cu.getBuffer().getText(arrayInitializerEnd, nodeEnd - arrayInitializerEnd));
            ASTNode replacementNode = null;
            if (this.call instanceof ClassInstanceCreation) {
                replacementNode = rewrite.createStringPlaceholder(buf.toString(), 14);
            } else if (this.call instanceof MethodInvocation) {
                replacementNode = rewrite.createStringPlaceholder(buf.toString(), 32);
            } else if (this.call instanceof SuperMethodInvocation) {
                replacementNode = rewrite.createStringPlaceholder(buf.toString(), 48);
            } else {
                return;
            }
            rewrite.replace((ASTNode)this.call, replacementNode, group);
        }
    }
}

