/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.UsageDataStore;
import com.microsoft.java.debug.core.protocol.JsonUtils;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.plugin.internal.Compile;
import com.microsoft.java.debug.plugin.internal.DebugSettingUtils;
import com.microsoft.java.debug.plugin.internal.IDebugServer;
import com.microsoft.java.debug.plugin.internal.InlineValueHandler;
import com.microsoft.java.debug.plugin.internal.JavaClassFilter;
import com.microsoft.java.debug.plugin.internal.JavaDebugServer;
import com.microsoft.java.debug.plugin.internal.JdtUtils;
import com.microsoft.java.debug.plugin.internal.LaunchCommandHandler;
import com.microsoft.java.debug.plugin.internal.PlatformSettings;
import com.microsoft.java.debug.plugin.internal.ProjectSettingsChecker;
import com.microsoft.java.debug.plugin.internal.ResolveClasspathsHandler;
import com.microsoft.java.debug.plugin.internal.ResolveElementHandler;
import com.microsoft.java.debug.plugin.internal.ResolveJavaExecutableHandler;
import com.microsoft.java.debug.plugin.internal.ResolveMainClassHandler;
import com.microsoft.java.debug.plugin.internal.ResolveMainMethodHandler;
import com.microsoft.java.debug.plugin.internal.ResolveSourceMappingHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ls.core.internal.IDelegateCommandHandler;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;

public class JavaDebugDelegateCommandHandler
implements IDelegateCommandHandler {
    public static final String FETCH_USER_DATA = "vscode.java.fetchUsageData";
    public static final String DEBUG_STARTSESSION = "vscode.java.startDebugSession";
    public static final String RESOLVE_CLASSPATH = "vscode.java.resolveClasspath";
    public static final String RESOLVE_MAINCLASS = "vscode.java.resolveMainClass";
    public static final String BUILD_WORKSPACE = "vscode.java.buildWorkspace";
    public static final String UPDATE_DEBUG_SETTINGS = "vscode.java.updateDebugSettings";
    public static final String VALIDATE_LAUNCHCONFIG = "vscode.java.validateLaunchConfig";
    public static final String RESOLVE_MAINMETHOD = "vscode.java.resolveMainMethod";
    public static final String INFER_LAUNCH_COMMAND_LENGTH = "vscode.java.inferLaunchCommandLength";
    public static final String CHECK_PROJECT_SETTINGS = "vscode.java.checkProjectSettings";
    public static final String RESOLVE_ELEMENT_AT_SELECTION = "vscode.java.resolveElementAtSelection";
    public static final String RESOLVE_BUILD_FILES = "vscode.java.resolveBuildFiles";
    public static final String IS_ON_CLASSPATH = "vscode.java.isOnClasspath";
    public static final String RESOLVE_JAVA_EXECUTABLE = "vscode.java.resolveJavaExecutable";
    public static final String FETCH_PLATFORM_SETTINGS = "vscode.java.fetchPlatformSettings";
    public static final String RESOLVE_CLASSFILTERS = "vscode.java.resolveClassFilters";
    public static final String RESOLVE_SOURCEURI = "vscode.java.resolveSourceUri";
    public static final String RESOLVE_INLINEVARIABLES = "vscode.java.resolveInlineVariables";

    public Object executeCommand(String commandId, List<Object> arguments, IProgressMonitor progress) throws Exception {
        switch (commandId) {
            case "vscode.java.startDebugSession": {
                IDebugServer debugServer = JavaDebugServer.getInstance();
                debugServer.start();
                return debugServer.getPort();
            }
            case "vscode.java.resolveClasspath": {
                ResolveClasspathsHandler handler = new ResolveClasspathsHandler();
                return handler.resolveClasspaths(arguments);
            }
            case "vscode.java.resolveMainClass": {
                ResolveMainClassHandler resolveMainClassHandler = new ResolveMainClassHandler();
                return resolveMainClassHandler.resolveMainClass(arguments);
            }
            case "vscode.java.buildWorkspace": {
                Compile.CompileParams params = null;
                if (arguments != null && !arguments.isEmpty()) {
                    params = (Compile.CompileParams)JsonUtils.fromJson((String)((String)arguments.get(0)), Compile.CompileParams.class);
                }
                return Compile.compile(params, progress);
            }
            case "vscode.java.fetchUsageData": {
                return UsageDataStore.getInstance().fetchAll();
            }
            case "vscode.java.updateDebugSettings": {
                return DebugSettingUtils.configDebugSettings(arguments);
            }
            case "vscode.java.validateLaunchConfig": {
                return new ResolveMainClassHandler().validateLaunchConfig(arguments);
            }
            case "vscode.java.resolveMainMethod": {
                return ResolveMainMethodHandler.resolveMainMethods(arguments, progress);
            }
            case "vscode.java.inferLaunchCommandLength": {
                return LaunchCommandHandler.getLaunchCommandLength((Requests.LaunchArguments)JsonUtils.fromJson((String)((String)arguments.get(0)), Requests.LaunchArguments.class));
            }
            case "vscode.java.checkProjectSettings": {
                return ProjectSettingsChecker.check((ProjectSettingsChecker.ProjectSettingsCheckerParams)JsonUtils.fromJson((String)((String)arguments.get(0)), ProjectSettingsChecker.ProjectSettingsCheckerParams.class));
            }
            case "vscode.java.resolveElementAtSelection": {
                return ResolveElementHandler.resolveElementAtSelection(arguments, progress);
            }
            case "vscode.java.resolveBuildFiles": {
                return this.getBuildFiles();
            }
            case "vscode.java.isOnClasspath": {
                return this.isOnClasspath(arguments);
            }
            case "vscode.java.resolveJavaExecutable": {
                return ResolveJavaExecutableHandler.resolveJavaExecutable(arguments);
            }
            case "vscode.java.fetchPlatformSettings": {
                return PlatformSettings.getPlatformSettings();
            }
            case "vscode.java.resolveClassFilters": {
                return JavaClassFilter.resolveClassFilters(arguments);
            }
            case "vscode.java.resolveSourceUri": {
                return ResolveSourceMappingHandler.resolveSourceUri(arguments);
            }
            case "vscode.java.resolveInlineVariables": {
                return InlineValueHandler.resolveInlineVariables((InlineValueHandler.InlineParams)JsonUtils.fromJson((String)((String)arguments.get(0)), InlineValueHandler.InlineParams.class), progress);
            }
        }
        throw new UnsupportedOperationException(String.format("Java debug plugin doesn't support the command '%s'.", commandId));
    }

    private List<String> getBuildFiles() {
        ArrayList<String> result = new ArrayList<String>();
        List<IJavaProject> javaProjects = JdtUtils.listJavaProjects(ResourcesPlugin.getWorkspace().getRoot());
        for (IJavaProject javaProject : javaProjects) {
            IFile buildFile = null;
            if (ProjectUtils.isMavenProject((IProject)javaProject.getProject())) {
                buildFile = javaProject.getProject().getFile("pom.xml");
            } else if (ProjectUtils.isGradleProject((IProject)javaProject.getProject())) {
                buildFile = javaProject.getProject().getFile("build.gradle");
            }
            if (buildFile == null || !buildFile.exists() || buildFile.getLocationURI() == null) continue;
            result.add(ResourceUtils.fixURI((URI)buildFile.getLocationURI()));
        }
        return result;
    }

    private boolean isOnClasspath(List<Object> arguments) throws DebugException {
        if (arguments.size() < 1) {
            throw new DebugException("No file uri is specified.");
        }
        String uri = (String)arguments.get(0);
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit((String)uri);
        if (unit == null || unit.getResource() == null || !unit.getResource().exists()) {
            throw new DebugException("The compilation unit " + uri + " doesn't exist.");
        }
        IJavaProject javaProject = unit.getJavaProject();
        return javaProject == null || javaProject.isOnClasspath((IJavaElement)unit);
    }
}

