/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.project;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.embedder.MavenProperties;
import org.eclipse.m2e.core.project.IProjectConfiguration;

public class ResolverConfiguration
implements Serializable,
IProjectConfiguration {
    private static final long serialVersionUID = 1258510761534886581L;
    private boolean resolveWorkspaceProjects = true;
    private String selectedProfiles = "";
    private String lifecycleMappingId;
    private Properties properties;
    private Map<String, String> userProperties;
    private File multiModuleProjectDirectory;
    private List<String> activeProfiles;
    private List<String> inactiveProfiles;
    private List<String> userActiveProfiles;
    private List<String> userInactiveProfiles;

    public ResolverConfiguration() {
    }

    public ResolverConfiguration(IProject project) {
        this.setMultiModuleProjectDirectory(MavenProperties.computeMultiModuleProjectDirectory((IResource)project));
    }

    public ResolverConfiguration(IProjectConfiguration resolverConfiguration) {
        this.setLifecycleMappingId(resolverConfiguration.getLifecycleMappingId());
        this.setMultiModuleProjectDirectory(resolverConfiguration.getMultiModuleProjectDirectory());
        Properties properties2 = new Properties();
        properties2.putAll(resolverConfiguration.getConfigurationProperties());
        this.setProperties(properties2);
        this.setResolveWorkspaceProjects(resolverConfiguration.isResolveWorkspaceProjects());
        this.setSelectedProfiles(resolverConfiguration.getSelectedProfiles());
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Map<String, String> getConfigurationProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        Set<String> names = this.properties.stringPropertyNames();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : names) {
            map.put(key, this.properties.getProperty(key));
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Map<String, String> getUserProperties() {
        if (this.userProperties == null) {
            return Collections.emptyMap();
        }
        return this.userProperties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Deprecated(forRemoval=true)
    public boolean shouldResolveWorkspaceProjects() {
        return this.isResolveWorkspaceProjects();
    }

    @Override
    public boolean isResolveWorkspaceProjects() {
        return this.resolveWorkspaceProjects;
    }

    @Override
    public String getSelectedProfiles() {
        return this.selectedProfiles;
    }

    public void setResolveWorkspaceProjects(boolean resolveWorkspaceProjects) {
        this.resolveWorkspaceProjects = resolveWorkspaceProjects;
    }

    public void setSelectedProfiles(String profiles) {
        this.selectedProfiles = profiles;
        this.activeProfiles = ResolverConfiguration.parseProfiles(profiles, true);
        this.inactiveProfiles = ResolverConfiguration.parseProfiles(profiles, false);
    }

    @Override
    public String getLifecycleMappingId() {
        return this.lifecycleMappingId;
    }

    public void setLifecycleMappingId(String lifecycleMappingId) {
        this.lifecycleMappingId = lifecycleMappingId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IProjectConfiguration var2_3) {
            return IProjectConfiguration.contentsEquals(this, (IProjectConfiguration)other);
        }
        return false;
    }

    public int hashCode() {
        return IProjectConfiguration.contentsHashCode(this);
    }

    @Override
    public File getMultiModuleProjectDirectory() {
        return this.multiModuleProjectDirectory;
    }

    public void setMultiModuleProjectDirectory(File multiModuleProjectDirectory) {
        if (!Objects.equals(this.multiModuleProjectDirectory, multiModuleProjectDirectory)) {
            this.multiModuleProjectDirectory = multiModuleProjectDirectory;
            try {
                Optional<MavenProperties> mavenProps = MavenProperties.getMavenArgs(multiModuleProjectDirectory);
                LinkedHashMap props = new LinkedHashMap();
                this.userActiveProfiles = new ArrayList<String>();
                this.userInactiveProfiles = new ArrayList<String>();
                mavenProps.ifPresent(args -> {
                    args.getCliProperties(props::put);
                    args.getProfiles(this.userActiveProfiles::add, this.userInactiveProfiles::add);
                });
                this.userProperties = Collections.unmodifiableMap(props);
            }
            catch (IOException ex) {
                MavenPluginActivator.getDefault().getLog().error("can't read maven args from " + multiModuleProjectDirectory, (Throwable)ex);
            }
        }
    }

    @Override
    public List<String> getActiveProfileList() {
        if (this.activeProfiles == null) {
            if (this.userActiveProfiles != null) {
                return List.copyOf(this.userActiveProfiles);
            }
            return List.of();
        }
        if (this.userActiveProfiles != null) {
            return Stream.concat(this.userActiveProfiles.stream(), this.activeProfiles.stream()).distinct().toList();
        }
        return List.copyOf(this.activeProfiles);
    }

    @Override
    public List<String> getInactiveProfileList() {
        if (this.inactiveProfiles == null) {
            if (this.userInactiveProfiles != null) {
                return List.copyOf(this.userInactiveProfiles);
            }
            return List.of();
        }
        if (this.userInactiveProfiles != null) {
            return Stream.concat(this.userInactiveProfiles.stream(), this.inactiveProfiles.stream()).distinct().toList();
        }
        return List.copyOf(this.inactiveProfiles);
    }

    private static List<String> parseProfiles(String profilesAsText, boolean status) {
        ArrayList<String> profiles;
        if (profilesAsText != null && profilesAsText.trim().length() > 0) {
            String[] profilesArray = profilesAsText.split("[,\\s\\|]");
            profiles = new ArrayList(profilesArray.length);
            String[] stringArray = profilesArray;
            int n = profilesArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isActive;
                String profile = stringArray[n2];
                boolean bl = isActive = !profile.startsWith("!");
                if (status == isActive) {
                    profile = isActive ? profile : profile.substring(1);
                    profiles.add(profile);
                }
                ++n2;
            }
        } else {
            profiles = new ArrayList<String>(0);
        }
        return profiles;
    }
}

