/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.shared.utils.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.internal.index.IndexedArtifact;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.project.conversion.AbstractProjectConversionParticipant;
import org.eclipse.m2e.jdt.internal.JavaSettingsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaProjectConversionParticipant
extends AbstractProjectConversionParticipant {
    private static final Logger log = LoggerFactory.getLogger(JavaProjectConversionParticipant.class);
    private static final String DEFAULT_JAVA_SOURCE = "src/main/java";
    private static final String DEFAULT_RESOURCES = "src/main/resources";
    private static final String DEFAULT_JAVA_TEST_SOURCE = "src/test/java";
    private static final String DEFAULT_TEST_RESOURCES = "src/test/resources";
    private static final String DEFAULT_JAVA_VERSION = "1.8";
    private static final String COMPILER_GROUP_ID = "org.apache.maven.plugins";
    private static final String COMPILER_ARTIFACT_ID = "maven-compiler-plugin";
    private static final String DEFAULT_COMPILER_VERSION = "3.13.0";
    private static final String TARGET_KEY = "target";
    private static final String SOURCE_KEY = "source";
    private static final String RELEASE_KEY = "release";
    private static final String COMPILER_ARGS_KEY = "compilerArgs";
    private static final String CONFIGURATION_KEY = "configuration";
    private static final float VERSION_9 = 9.0f;

    public boolean accept(IProject project) throws CoreException {
        boolean accepts = project != null && project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature");
        return accepts;
    }

    public void convert(IProject project, Model model, IProgressMonitor monitor) throws CoreException {
        if (!this.accept(project)) {
            return;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return;
        }
        log.debug("Applying Java conversion to " + project.getName());
        this.configureBuildSourceDirectories(model, javaProject);
        Map options = javaProject.getOptions(true);
        String source = (String)options.get("org.eclipse.jdt.core.compiler.source");
        String target = (String)options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
        boolean emptySource = StringUtils.isEmpty((String)source);
        boolean emptyTarget = StringUtils.isEmpty((String)target);
        if (emptySource && emptyTarget) {
            return;
        }
        if (emptySource) {
            source = target;
        } else if (emptyTarget) {
            target = source;
        }
        if (DEFAULT_JAVA_VERSION.equals(source) && DEFAULT_JAVA_VERSION.equals(target)) {
            return;
        }
        boolean useProperties = false;
        if (useProperties) {
            this.configureProperties(model, source, target);
        } else {
            this.configureCompilerPlugin(model, source, target, JavaSettingsUtils.hasPreviewFeatures(javaProject));
        }
    }

    private void configureProperties(Model model, String source, String target) {
        Properties properties = model.getProperties();
        if (properties == null) {
            properties = new Properties();
            model.setProperties(properties);
        }
        if (this.canUseReleaseProperty(source, target)) {
            properties.setProperty("maven.compiler.release", source);
        } else {
            properties.setProperty("maven.compiler.source", source);
            properties.setProperty("maven.compiler.target", target);
        }
    }

    private void configureCompilerPlugin(Model model, String source, String target, boolean usesPreviewFeatures) {
        Build build = this.getOrCreateBuild(model);
        model.setBuild(build);
        Plugin compiler = this.getOrCreateCompilerPlugin(build);
        Xpp3Dom configuration = (Xpp3Dom)compiler.getConfiguration();
        if (configuration == null) {
            configuration = new Xpp3Dom(CONFIGURATION_KEY);
            compiler.setConfiguration((Object)configuration);
        }
        if (this.canUseReleaseProperty(source, target)) {
            Xpp3Dom releaseDom = configuration.getChild(RELEASE_KEY);
            if (releaseDom == null) {
                releaseDom = new Xpp3Dom(RELEASE_KEY);
                configuration.addChild(releaseDom);
            }
            releaseDom.setValue(source);
        } else {
            Xpp3Dom sourceDom = configuration.getChild(SOURCE_KEY);
            if (sourceDom == null) {
                sourceDom = new Xpp3Dom(SOURCE_KEY);
                configuration.addChild(sourceDom);
            }
            sourceDom.setValue(source);
            Xpp3Dom targetDom = configuration.getChild(TARGET_KEY);
            if (targetDom == null) {
                targetDom = new Xpp3Dom(TARGET_KEY);
                configuration.addChild(targetDom);
            }
            targetDom.setValue(target);
        }
        if (usesPreviewFeatures) {
            Xpp3Dom compilerArgsDom = configuration.getChild(COMPILER_ARGS_KEY);
            if (compilerArgsDom == null) {
                compilerArgsDom = new Xpp3Dom(COMPILER_ARGS_KEY);
                configuration.addChild(compilerArgsDom);
            }
            String argKey = "arg";
            boolean addFlag = true;
            if (compilerArgsDom.getChildCount() > 0) {
                argKey = compilerArgsDom.getChild(0).getName();
                boolean bl = addFlag = !Arrays.stream(compilerArgsDom.getChildren()).filter(c -> "--enable-preview".equals(c.getValue())).findAny().isPresent();
            }
            if (addFlag) {
                Xpp3Dom previewFlagDom = new Xpp3Dom(argKey);
                previewFlagDom.setValue("--enable-preview");
                compilerArgsDom.addChild(previewFlagDom);
            }
        }
        compiler.setConfiguration((Object)configuration);
    }

    private boolean canUseReleaseProperty(String source, String target) {
        return source.equals(target) && this.asFloat(source) >= 9.0f;
    }

    private float asFloat(String source) {
        try {
            return Float.parseFloat(source);
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    private Plugin getOrCreateCompilerPlugin(Build build) {
        build.flushPluginMap();
        Plugin compiler = (Plugin)build.getPluginsAsMap().get("org.apache.maven.plugins:maven-compiler-plugin");
        if (compiler == null) {
            compiler = (Plugin)build.getPluginsAsMap().get(COMPILER_ARTIFACT_ID);
        }
        if (compiler == null) {
            compiler = new Plugin();
            compiler.setGroupId(COMPILER_GROUP_ID);
            compiler.setArtifactId(COMPILER_ARTIFACT_ID);
            compiler.setVersion(this.getCompilerVersion());
            build.addPlugin(compiler);
        }
        return compiler;
    }

    private void configureBuildSourceDirectories(Model model, IJavaProject javaProject) throws CoreException {
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        LinkedHashSet<String> sources = new LinkedHashSet<String>();
        LinkedHashSet<String> potentialTestSources = new LinkedHashSet<String>();
        LinkedHashSet<String> potentialResourceDirectories = new LinkedHashSet<String>();
        LinkedHashSet<String> potentialTestResourceDirectories = new LinkedHashSet<String>();
        IPath projectPath = javaProject.getPath();
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && !(path = entry.getPath().makeRelativeTo(projectPath)).isAbsolute()) {
                String portablePath = path.toPortableString();
                boolean isPotentialTestSource = this.isPotentialTestSource(path);
                boolean isResource = false;
                if (isPotentialTestSource) {
                    if (DEFAULT_TEST_RESOURCES.equals(portablePath)) {
                        isResource = potentialTestResourceDirectories.add(portablePath);
                    } else {
                        potentialTestSources.add(portablePath);
                    }
                } else if (DEFAULT_RESOURCES.equals(portablePath)) {
                    isResource = potentialResourceDirectories.add(portablePath);
                } else {
                    sources.add(portablePath);
                }
                if (!isResource) {
                    boolean hasNonJavaResources = false;
                    IFolder folder = javaProject.getProject().getFolder(path);
                    if (folder.isAccessible()) {
                        NonJavaResourceVisitor nonJavaResourceVisitor = new NonJavaResourceVisitor();
                        try {
                            folder.accept((IResourceVisitor)nonJavaResourceVisitor);
                        }
                        catch (NonJavaResourceFoundException ex) {
                            hasNonJavaResources = true;
                        }
                        catch (CoreException ex) {
                            if (ex.getCause() instanceof NonJavaResourceFoundException) {
                                hasNonJavaResources = true;
                            }
                            log.error("An error occured while analysing {} : {}", (Object)folder, (Object)ex.getMessage());
                        }
                    }
                    if (hasNonJavaResources) {
                        if (isPotentialTestSource) {
                            potentialTestResourceDirectories.add(portablePath);
                        } else {
                            potentialResourceDirectories.add(portablePath);
                        }
                    }
                }
            }
            ++n2;
        }
        Build build = this.getOrCreateBuild(model);
        if (!sources.isEmpty()) {
            String sourceDirectory;
            if (sources.size() > 1) {
                log.warn("{} has multiple source entries, this is not supported yet", (Object)model.getArtifactId());
            }
            if (!DEFAULT_JAVA_SOURCE.equals(sourceDirectory = (String)sources.iterator().next())) {
                build.setSourceDirectory(sourceDirectory);
            }
            for (String resourceDirectory : potentialResourceDirectories) {
                if (DEFAULT_RESOURCES.equals(resourceDirectory) && potentialResourceDirectories.size() <= 1) continue;
                build.addResource(this.createResource(resourceDirectory));
            }
        }
        if (!potentialTestSources.isEmpty()) {
            String testSourceDirectory;
            if (potentialTestSources.size() > 1) {
                log.warn("{} has multiple test source entries, this is not supported yet", (Object)model.getArtifactId());
            }
            if (!DEFAULT_JAVA_TEST_SOURCE.equals(testSourceDirectory = (String)potentialTestSources.iterator().next())) {
                build.setTestSourceDirectory(testSourceDirectory);
            }
            for (String resourceDirectory : potentialTestResourceDirectories) {
                if (DEFAULT_TEST_RESOURCES.equals(resourceDirectory) && potentialTestResourceDirectories.size() <= 1) continue;
                build.addTestResource(this.createResource(resourceDirectory));
            }
        }
        if (build.getSourceDirectory() != null || build.getTestSourceDirectory() != null || !build.getResources().isEmpty() || !build.getTestResources().isEmpty()) {
            model.setBuild(build);
        }
    }

    private Resource createResource(String resourceDirectory) {
        Resource r = new Resource();
        r.setDirectory(resourceDirectory);
        r.addExclude("**/*.java");
        return r;
    }

    private boolean isPotentialTestSource(IPath path) {
        String[] stringArray = path.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            String folderName = segment.toLowerCase();
            if (folderName.matches(".*tests?")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Build getOrCreateBuild(Model model) {
        Build build = model.getBuild();
        if (build == null) {
            build = new Build();
        }
        return build;
    }

    private String getCompilerVersion() {
        String version = System.getProperty("org.eclipse.m2e.jdt.conversion.compiler.version");
        if (version != null) {
            return version;
        }
        return this.getMostRecentPluginVersion(COMPILER_GROUP_ID, COMPILER_ARTIFACT_ID, DEFAULT_COMPILER_VERSION);
    }

    private String getMostRecentPluginVersion(String groupId, String artifactId, String referenceVersion) {
        Assert.isNotNull((Object)groupId, (String)"groupId can not be null");
        Assert.isNotNull((Object)artifactId, (String)"artifactId can not be null");
        String version = referenceVersion;
        String partialKey = artifactId + " : " + groupId;
        Map values = Map.of();
        if (!values.isEmpty()) {
            TreeSet<ComparableVersion> versions = new TreeSet<ComparableVersion>();
            ComparableVersion referenceComparableVersion = referenceVersion == null ? null : new ComparableVersion(referenceVersion);
            for (Map.Entry e : values.entrySet()) {
                if (!((String)e.getKey()).endsWith(partialKey)) continue;
                for (IndexedArtifactFile f : ((IndexedArtifact)e.getValue()).getFiles()) {
                    if (!groupId.equals(f.group) || !artifactId.equals(f.artifact) || f.version.contains("SNAPSHOT")) continue;
                    ComparableVersion v = new ComparableVersion(f.version);
                    if (referenceComparableVersion != null && v.compareTo(referenceComparableVersion) <= 0) continue;
                    versions.add(v);
                }
                if (versions.isEmpty()) continue;
                ArrayList<String> sorted = new ArrayList<String>(versions.size());
                for (ComparableVersion v : versions) {
                    sorted.add(v.toString());
                }
                Collections.reverse(sorted);
                version = (String)sorted.iterator().next();
            }
        }
        return version;
    }

    private static class NonJavaResourceFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class NonJavaResourceVisitor
    implements IResourceVisitor {
        private static final List<String> IGNORED_EXTENSIONS = Arrays.asList(".svn");

        public boolean visit(IResource resource) throws CoreException {
            IFile file;
            String resourceName = resource.getProjectRelativePath().lastSegment();
            if (resource.isHidden() || this.isIgnored(resourceName)) {
                return false;
            }
            if (resource instanceof IFile && !"java".equals((file = (IFile)resource).getFileExtension())) {
                throw new NonJavaResourceFoundException();
            }
            return true;
        }

        private boolean isIgnored(String resourceName) {
            for (String extension : IGNORED_EXTENSIONS) {
                if (!resourceName.endsWith(extension)) continue;
                return true;
            }
            return false;
        }
    }
}

