/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.core.adapter.ProtocolServer;
import com.microsoft.java.debug.plugin.internal.IDebugServer;
import com.microsoft.java.debug.plugin.internal.JdtProviderContextFactory;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaDebugServer
implements IDebugServer {
    private static final Logger logger = Logger.getLogger("java-debug");
    private static JavaDebugServer singletonInstance;
    private ServerSocket serverSocket = null;
    private boolean isStarted = false;
    private ExecutorService executor = null;

    private JavaDebugServer() {
        try {
            this.serverSocket = new ServerSocket(0, 1);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, String.format("Failed to create Java Debug Server: %s", e.toString()), e);
        }
    }

    public static synchronized IDebugServer getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new JavaDebugServer();
        }
        return singletonInstance;
    }

    @Override
    public synchronized int getPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return -1;
    }

    @Override
    public synchronized void start() {
        if (this.serverSocket != null && !this.isStarted) {
            this.isStarted = true;
            this.executor = new ThreadPoolExecutor(0, 100, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            Socket connection = JavaDebugServer.this.serverSocket.accept();
                            JavaDebugServer.this.executor.submit(JavaDebugServer.this.createConnectionTask(connection));
                        }
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, String.format("Setup socket connection exception: %s", e.toString()), e);
                        JavaDebugServer.this.closeServerSocket();
                        JavaDebugServer.this.shutdownConnectionPool(false);
                        return;
                    }
                }
            }, "Java Debug Server").start();
        }
    }

    @Override
    public synchronized void stop() {
        this.closeServerSocket();
        this.shutdownConnectionPool(true);
    }

    private synchronized void closeServerSocket() {
        if (this.serverSocket != null) {
            try {
                logger.info("Close debugserver socket port " + this.serverSocket.getLocalPort());
                this.serverSocket.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, String.format("Close ServerSocket exception: %s", e.toString()), e);
            }
        }
        this.serverSocket = null;
    }

    private synchronized void shutdownConnectionPool(boolean now) {
        if (this.executor != null) {
            if (now) {
                this.executor.shutdownNow();
            } else {
                this.executor.shutdown();
            }
        }
    }

    private Runnable createConnectionTask(final Socket connection) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        ProtocolServer protocolServer = new ProtocolServer(connection.getInputStream(), connection.getOutputStream(), JdtProviderContextFactory.createProviderContext());
                        protocolServer.run();
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, String.format("Socket connection exception: %s", e.toString()), e);
                        logger.info("Debug connection closed");
                    }
                }
                finally {
                    logger.info("Debug connection closed");
                }
            }
        };
    }
}

