/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ExportsDirective;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.OpensDirective;
import org.eclipse.jdt.core.dom.RequiresDirective;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.LocatorResponse;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.ModuleLocator;
import org.eclipse.jdt.internal.core.search.matching.ModulePattern;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;

public class DOMModuleLocator
extends DOMPatternLocator {
    private final ModulePattern pattern;

    public DOMModuleLocator(ModuleLocator trl, ModulePattern modulePattern) {
        super((SearchPattern)modulePattern);
        this.pattern = modulePattern;
    }

    @Override
    public LocatorResponse match(ModuleDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (this.pattern.findDeclarations && this.matchesName(this.pattern.name, node.getName().toString().toCharArray())) {
            return this.toResponse(2);
        }
        return this.toResponse(0);
    }

    @Override
    public LocatorResponse match(Name name, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (this.pattern.findReferences && this.isValidLocationForModuleNameReference((ASTNode)name) && this.matchesName(name.toString().toCharArray(), this.pattern.name)) {
            return this.toResponse(2);
        }
        return this.toResponse(0);
    }

    private boolean isValidLocationForModuleNameReference(ASTNode name) {
        ImportDeclaration importDecl;
        ASTNode aSTNode;
        if (name.getLocationInParent() == RequiresDirective.NAME_PROPERTY || name.getLocationInParent() == ExportsDirective.MODULES_PROPERTY || name.getLocationInParent() == OpensDirective.MODULES_PROPERTY) {
            return true;
        }
        return name.getAST().apiLevel() >= 23 && name.getLocationInParent() == ImportDeclaration.NAME_PROPERTY && (aSTNode = name.getParent()) instanceof ImportDeclaration && Modifier.isModule((int)(importDecl = (ImportDeclaration)aSTNode).getModifiers());
    }

    @Override
    public LocatorResponse resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        IModuleBinding mod;
        if (binding instanceof IModuleBinding && this.matchesName(this.pattern.name, (mod = (IModuleBinding)binding).getName().toCharArray())) {
            return this.toResponse(3);
        }
        if (binding == null) {
            return this.toResponse(3);
        }
        return this.toResponse(0);
    }
}

