/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Pattern;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.fix.RenameUnusedVariableCleanUpCore;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class RenameUnusedVariableFixCore
extends CompilationUnitRewriteOperationsFixCore {
    private final Map<String, String> fCleanUpOptions;

    public static RenameUnusedVariableFixCore createRenameToUnnamedFix(CompilationUnit compilationUnit, IProblemLocation problem) {
        IBinding binding;
        SimpleName name;
        if ((RenameUnusedVariableFixCore.isUnusedMember(problem) || RenameUnusedVariableFixCore.isUnusedLambdaParameter(problem)) && (name = RenameUnusedVariableFixCore.getUnusedName(compilationUnit, problem)) != null && (binding = name.resolveBinding()) != null && RenameUnusedVariableFixCore.canRenameToUnnamedVariable(compilationUnit, name)) {
            String label = FixMessages.UnusedCodeFix_RenameToUnnamedVariable_description;
            RenameToUnnamedVariableOperation operation = new RenameToUnnamedVariableOperation(name);
            return new RenameUnusedVariableFixCore(label, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{operation}, RenameUnusedVariableFixCore.getCleanUpOptions());
        }
        return null;
    }

    public static boolean isUnusedMember(IProblemLocation problem) {
        int id = problem.getProblemId();
        return id == 536870973;
    }

    public static boolean isUnusedLambdaParameter(IProblemLocation problem) {
        int id = problem.getProblemId();
        return id == 536871193;
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, boolean removeUnusedLocalVariables) {
        IProblem[] problems = compilationUnit.getProblems();
        IProblemLocation[] locations = new IProblemLocation[problems.length];
        int i = 0;
        while (i < problems.length) {
            locations[i] = new ProblemLocation(problems[i]);
            ++i;
        }
        return RenameUnusedVariableFixCore.createCleanUp(compilationUnit, locations, removeUnusedLocalVariables);
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] problems, boolean removeUnusedLocalVariables) {
        ArrayList<RenameToUnnamedVariableOperation> result = new ArrayList<RenameToUnnamedVariableOperation>();
        IProblemLocation[] iProblemLocationArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding;
            SimpleName name;
            IProblemLocation problem = iProblemLocationArray[n2];
            int id = problem.getProblemId();
            if ((removeUnusedLocalVariables && id == 536870973 || removeUnusedLocalVariables && id == 536871193) && (name = RenameUnusedVariableFixCore.getUnusedName(compilationUnit, problem)) != null && (binding = name.resolveBinding()) instanceof IVariableBinding && RenameUnusedVariableFixCore.canRenameToUnnamedVariable(compilationUnit, name)) {
                result.add(new RenameToUnnamedVariableOperation(name));
            }
            ++n2;
        }
        if (result.isEmpty()) {
            return null;
        }
        return new RenameUnusedVariableFixCore(FixMessages.UnusedCodeFix_change_name, compilationUnit, result.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[result.size()]));
    }

    public static boolean canRenameToUnnamedVariable(CompilationUnit compilationUnit, SimpleName name) {
        if (JavaModelUtil.is22OrHigher(compilationUnit.getJavaElement().getJavaProject())) {
            ASTNode aSTNode = name.getParent();
            if (aSTNode instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration nameParent = (SingleVariableDeclaration)aSTNode;
                if (nameParent.getParent() instanceof Pattern || nameParent.getParent() instanceof EnhancedForStatement) {
                    return true;
                }
            } else {
                ASTNode aSTNode2 = name.getParent();
                if (aSTNode2 instanceof VariableDeclarationFragment) {
                    VariableDeclarationExpression varFragmentParent;
                    VariableDeclarationFragment varFragment = (VariableDeclarationFragment)aSTNode2;
                    if (varFragment.getParent() instanceof LambdaExpression) {
                        return true;
                    }
                    ASTNode aSTNode3 = varFragment.getParent();
                    if (aSTNode3 instanceof VariableDeclarationExpression && ((varFragmentParent = (VariableDeclarationExpression)aSTNode3).getParent() instanceof TryStatement || varFragmentParent.getParent() instanceof ForStatement)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static SimpleName getUnusedName(CompilationUnit compilationUnit, IProblemLocation problem) {
        ASTNode selectedNode = problem.getCoveringNode(compilationUnit);
        if (selectedNode instanceof MethodDeclaration) {
            return ((MethodDeclaration)selectedNode).getName();
        }
        if (selectedNode instanceof SimpleName) {
            return (SimpleName)selectedNode;
        }
        return null;
    }

    public static Map<String, String> getCleanUpOptions() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.put("cleanup.remove_unused_local_variables", "true");
        return result;
    }

    private RenameUnusedVariableFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        this(name, compilationUnit, fixRewriteOperations, (Map<String, String>)null);
    }

    private RenameUnusedVariableFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations, Map<String, String> options) {
        super(name, compilationUnit, fixRewriteOperations);
        this.fCleanUpOptions = options;
    }

    public RenameUnusedVariableCleanUpCore getCleanUp() {
        if (this.fCleanUpOptions == null) {
            return null;
        }
        return new RenameUnusedVariableCleanUpCore(this.fCleanUpOptions);
    }

    public static class RenameToUnnamedVariableOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final SimpleName fName;

        public RenameToUnnamedVariableOperation(SimpleName name) {
            this.fName = name;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore model) throws CoreException {
            AST ast = cuRewrite.getAST();
            SimpleName newName = ast.newSimpleName("_");
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            TextEditGroup group = this.createTextEditGroup(FixMessages.UnusedCodeFix_RenameToUnnamedVariable_description, cuRewrite);
            rewrite.replace((ASTNode)this.fName, (ASTNode)newName, group);
        }
    }
}

